/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.bootstrap;

import com.alipay.sofa.registry.remoting.bolt.exchange.BoltExchange;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.jersey.exchange.JerseyExchange;
import com.alipay.sofa.registry.server.data.bootstrap.CommonConfig;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerBootstrap;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerInitializer;
import com.alipay.sofa.registry.server.data.cache.DataServerCache;
import com.alipay.sofa.registry.server.data.change.DataChangeHandler;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEventCenter;
import com.alipay.sofa.registry.server.data.change.notify.BackUpNotifier;
import com.alipay.sofa.registry.server.data.change.notify.IDataChangeNotifier;
import com.alipay.sofa.registry.server.data.change.notify.SessionServerNotifier;
import com.alipay.sofa.registry.server.data.change.notify.TempPublisherNotifier;
import com.alipay.sofa.registry.server.data.correction.LocalDataServerCleanHandler;
import com.alipay.sofa.registry.server.data.datasync.AcceptorStore;
import com.alipay.sofa.registry.server.data.datasync.SyncDataService;
import com.alipay.sofa.registry.server.data.datasync.sync.LocalAcceptorStore;
import com.alipay.sofa.registry.server.data.datasync.sync.Scheduler;
import com.alipay.sofa.registry.server.data.datasync.sync.StoreServiceFactory;
import com.alipay.sofa.registry.server.data.datasync.sync.SyncDataServiceImpl;
import com.alipay.sofa.registry.server.data.event.EventCenter;
import com.alipay.sofa.registry.server.data.event.handler.DataServerChangeEventHandler;
import com.alipay.sofa.registry.server.data.event.handler.LocalDataServerChangeEventHandler;
import com.alipay.sofa.registry.server.data.event.handler.MetaServerChangeEventHandler;
import com.alipay.sofa.registry.server.data.event.handler.StartTaskEventHandler;
import com.alipay.sofa.registry.server.data.node.DataNodeStatus;
import com.alipay.sofa.registry.server.data.remoting.DataNodeExchanger;
import com.alipay.sofa.registry.server.data.remoting.MetaNodeExchanger;
import com.alipay.sofa.registry.server.data.remoting.dataserver.DataServerConnectionFactory;
import com.alipay.sofa.registry.server.data.remoting.dataserver.GetSyncDataHandler;
import com.alipay.sofa.registry.server.data.remoting.dataserver.handler.DataSyncServerConnectionHandler;
import com.alipay.sofa.registry.server.data.remoting.dataserver.handler.FetchDataHandler;
import com.alipay.sofa.registry.server.data.remoting.dataserver.handler.NotifyDataSyncHandler;
import com.alipay.sofa.registry.server.data.remoting.dataserver.handler.NotifyFetchDatumHandler;
import com.alipay.sofa.registry.server.data.remoting.dataserver.handler.NotifyOnlineHandler;
import com.alipay.sofa.registry.server.data.remoting.dataserver.handler.SyncDataHandler;
import com.alipay.sofa.registry.server.data.remoting.dataserver.task.AbstractTask;
import com.alipay.sofa.registry.server.data.remoting.dataserver.task.ConnectionRefreshTask;
import com.alipay.sofa.registry.server.data.remoting.dataserver.task.ReNewNodeTask;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractClientHandler;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.data.remoting.metaserver.DefaultMetaServiceImpl;
import com.alipay.sofa.registry.server.data.remoting.metaserver.IMetaServerService;
import com.alipay.sofa.registry.server.data.remoting.metaserver.MetaServerConnectionFactory;
import com.alipay.sofa.registry.server.data.remoting.metaserver.handler.ServerChangeHandler;
import com.alipay.sofa.registry.server.data.remoting.metaserver.handler.StatusConfirmHandler;
import com.alipay.sofa.registry.server.data.remoting.metaserver.task.ConnectionRefreshMetaTask;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.SessionServerConnectionFactory;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.DisconnectEventHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.forward.ForwardService;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.forward.ForwardServiceImpl;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.handler.ClientOffHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.handler.DataServerConnectionHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.handler.GetDataHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.handler.GetDataVersionsHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.handler.PublishDataHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.handler.SessionServerRegisterHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.handler.UnPublishDataHandler;
import com.alipay.sofa.registry.server.data.resource.DataDigestResource;
import com.alipay.sofa.registry.server.data.resource.HealthResource;
import com.alipay.sofa.registry.util.PropertySplitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DataServerInitializer.class})
@EnableConfigurationProperties
public class DataServerBeanConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DataServerBootstrap dataServerBootstrap() {
        return new DataServerBootstrap();
    }

    @Configuration
    public static class ResourceConfiguration {
        @Bean
        public ResourceConfig jerseyResourceConfig() {
            ResourceConfig resourceConfig = new ResourceConfig();
            resourceConfig.register(JacksonFeature.class);
            return resourceConfig;
        }

        @Bean
        public HealthResource healthResource() {
            return new HealthResource();
        }

        @Bean
        public DataDigestResource dataDigestResource() {
            return new DataDigestResource();
        }
    }

    @Configuration
    public static class DataServerRemotingBeanConfiguration {
        @Bean
        public ConnectionRefreshTask connectionRefreshTask() {
            return new ConnectionRefreshTask();
        }

        @Bean
        public ConnectionRefreshMetaTask connectionRefreshMetaTask() {
            return new ConnectionRefreshMetaTask();
        }

        @Bean
        public ReNewNodeTask reNewNodeTask() {
            return new ReNewNodeTask();
        }

        @Bean(name={"tasks"})
        public List<AbstractTask> tasks() {
            ArrayList<AbstractTask> list = new ArrayList<AbstractTask>();
            list.add(this.connectionRefreshTask());
            list.add(this.connectionRefreshMetaTask());
            list.add(this.reNewNodeTask());
            return list;
        }

        @Bean
        public IMetaServerService metaServerService() {
            return new DefaultMetaServiceImpl();
        }
    }

    @Configuration
    public static class DataServerEventBeanConfiguration {
        @Bean
        public DataServerChangeEventHandler dataServerChangeEventHandler() {
            return new DataServerChangeEventHandler();
        }

        @Bean
        public LocalDataServerChangeEventHandler localDataServerChangeEventHandler() {
            return new LocalDataServerChangeEventHandler();
        }

        @Bean
        public MetaServerChangeEventHandler metaServerChangeEventHandler() {
            return new MetaServerChangeEventHandler();
        }

        @Bean
        public StartTaskEventHandler startTaskEventHandler() {
            return new StartTaskEventHandler();
        }

        @Bean
        public LocalDataServerCleanHandler localDataServerCleanHandler() {
            return new LocalDataServerCleanHandler();
        }

        @Bean
        public GetSyncDataHandler getSyncDataHandler() {
            return new GetSyncDataHandler();
        }

        @Bean
        public DisconnectEventHandler disconnectEventHandler() {
            return new DisconnectEventHandler();
        }

        @Bean
        public EventCenter eventCenter() {
            return new EventCenter();
        }

        @Bean
        public DataChangeEventCenter dataChangeEventCenter() {
            return new DataChangeEventCenter();
        }
    }

    @Configuration
    public static class DataServerSyncBeanConfiguration {
        @Bean
        public SyncDataService syncDataService() {
            return new SyncDataServiceImpl();
        }

        @Bean
        public AcceptorStore localAcceptorStore() {
            return new LocalAcceptorStore();
        }

        @Bean
        public Scheduler syncDataScheduler() {
            return new Scheduler();
        }

        @Bean
        public StoreServiceFactory storeServiceFactory() {
            return new StoreServiceFactory();
        }
    }

    @Configuration
    public static class DataServerNotifyBeanConfiguration {
        @Bean
        public DataChangeHandler dataChangeHandler() {
            return new DataChangeHandler();
        }

        @Bean
        public SessionServerNotifier sessionServerNotifier() {
            return new SessionServerNotifier();
        }

        @Bean
        public TempPublisherNotifier tempPublisherNotifier() {
            return new TempPublisherNotifier();
        }

        @Bean
        public BackUpNotifier backUpNotifier() {
            return new BackUpNotifier();
        }

        @Bean(name={"dataChangeNotifiers"})
        public List<IDataChangeNotifier> dataChangeNotifiers(DataServerConfig dataServerBootstrapConfig) {
            ArrayList<IDataChangeNotifier> list = new ArrayList<IDataChangeNotifier>();
            list.add(this.sessionServerNotifier());
            list.add(this.tempPublisherNotifier());
            list.add(this.backUpNotifier());
            return list;
        }
    }

    @Configuration
    public static class SessionRemotingConfiguration {
        @Bean
        public Exchange jerseyExchange() {
            return new JerseyExchange();
        }

        @Bean
        public Exchange boltExchange() {
            return new BoltExchange();
        }

        @Bean
        public MetaNodeExchanger metaNodeExchanger() {
            return new MetaNodeExchanger();
        }

        @Bean
        public DataNodeExchanger dataNodeExchanger() {
            return new DataNodeExchanger();
        }

        @Bean
        public DataServerCache dataServerCache() {
            return new DataServerCache();
        }

        @Bean
        public ForwardService forwardService() {
            return new ForwardServiceImpl();
        }

        @Bean
        public SessionServerConnectionFactory sessionServerConnectionFactory() {
            return new SessionServerConnectionFactory();
        }

        @Bean
        public DataServerConnectionFactory dataServerConnectionFactory() {
            return new DataServerConnectionFactory();
        }

        @Bean
        public MetaServerConnectionFactory metaServerConnectionFactory() {
            return new MetaServerConnectionFactory();
        }

        @Bean(name={"serverHandlers"})
        public Collection<AbstractServerHandler> serverHandlers(DataServerConfig dataServerBootstrapConfig) {
            ArrayList<AbstractServerHandler> list = new ArrayList<AbstractServerHandler>();
            list.add(this.getDataHandler());
            list.add(this.clientOffHandler());
            list.add(this.getDataVersionsHandler());
            list.add(this.publishDataProcessor(dataServerBootstrapConfig));
            list.add(this.sessionServerRegisterHandler());
            list.add(this.unPublishDataHandler());
            list.add(this.dataServerConnectionHandler());
            return list;
        }

        @Bean(name={"serverSyncHandlers"})
        public Collection<AbstractServerHandler> serverSyncHandlers(DataServerConfig dataServerBootstrapConfig) {
            ArrayList<AbstractServerHandler> list = new ArrayList<AbstractServerHandler>();
            list.add(this.getDataHandler());
            list.add(this.publishDataProcessor(dataServerBootstrapConfig));
            list.add(this.unPublishDataHandler());
            list.add(this.notifyFetchDatumHandler());
            list.add(this.notifyOnlineHandler());
            list.add(this.syncDataHandler());
            list.add(this.dataSyncServerConnectionHandler());
            return list;
        }

        @Bean(name={"dataClientHandlers"})
        public Collection<AbstractClientHandler> dataClientHandlers() {
            ArrayList<AbstractClientHandler> list = new ArrayList<AbstractClientHandler>();
            list.add(this.notifyDataSyncHandler());
            list.add(this.fetchDataHandler());
            return list;
        }

        @Bean(name={"metaClientHandlers"})
        public Collection<AbstractClientHandler> metaClientHandlers() {
            ArrayList<AbstractClientHandler> list = new ArrayList<AbstractClientHandler>();
            list.add(this.serverChangeHandler());
            list.add(this.statusConfirmHandler());
            return list;
        }

        @Bean
        public AbstractServerHandler dataServerConnectionHandler() {
            return new DataServerConnectionHandler();
        }

        @Bean
        public AbstractServerHandler dataSyncServerConnectionHandler() {
            return new DataSyncServerConnectionHandler();
        }

        @Bean
        public AbstractServerHandler getDataHandler() {
            return new GetDataHandler();
        }

        @Bean
        public AbstractServerHandler getDataVersionsHandler() {
            return new GetDataVersionsHandler();
        }

        @Bean
        public AbstractServerHandler clientOffHandler() {
            return new ClientOffHandler();
        }

        @Bean
        public AbstractServerHandler publishDataProcessor(DataServerConfig dataServerBootstrapConfig) {
            return new PublishDataHandler(dataServerBootstrapConfig);
        }

        @Bean
        public AbstractServerHandler sessionServerRegisterHandler() {
            return new SessionServerRegisterHandler();
        }

        @Bean
        public AbstractServerHandler unPublishDataHandler() {
            return new UnPublishDataHandler();
        }

        @Bean
        public AbstractServerHandler notifyFetchDatumHandler() {
            return new NotifyFetchDatumHandler();
        }

        @Bean
        public AbstractServerHandler notifyOnlineHandler() {
            return new NotifyOnlineHandler();
        }

        @Bean
        public AbstractServerHandler syncDataHandler() {
            return new SyncDataHandler();
        }

        @Bean
        public AbstractClientHandler notifyDataSyncHandler() {
            return new NotifyDataSyncHandler();
        }

        @Bean
        public AbstractClientHandler fetchDataHandler() {
            return new FetchDataHandler();
        }

        @Bean
        public AbstractClientHandler serverChangeHandler() {
            return new ServerChangeHandler();
        }

        @Bean
        public AbstractClientHandler statusConfirmHandler() {
            return new StatusConfirmHandler();
        }
    }

    @Configuration
    protected static class DataServerBootstrapConfigConfiguration {
        protected DataServerBootstrapConfigConfiguration() {
        }

        @Bean
        public CommonConfig commonConfig() {
            return new CommonConfig();
        }

        @Bean
        public DataServerConfig dataServerBootstrapConfig(CommonConfig commonConfig) {
            return new DataServerConfig(commonConfig);
        }

        @Bean
        public DataNodeStatus dataNodeStatus() {
            return new DataNodeStatus();
        }

        @Bean(name={"PropertySplitter"})
        public PropertySplitter propertySplitter() {
            return new PropertySplitter();
        }
    }
}

