/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.jersey.exchange;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.jersey.JerseyClient;
import com.alipay.sofa.registry.remoting.jersey.JerseyJettyServer;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.server.ResourceConfig;

public class JerseyExchange
implements Exchange<ResourceConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JerseyExchange.class);
    private ConcurrentHashMap<Integer, Server> serverMap = new ConcurrentHashMap();
    private Client client;

    public Client connect(String serverType, URL serverUrl, ResourceConfig ... channelHandlers) {
        JerseyClient jerseyClient = JerseyClient.getInstance();
        this.setClient(jerseyClient);
        return jerseyClient;
    }

    public Server open(URL url, ResourceConfig ... resources) {
        URI uri;
        try {
            uri = UriBuilder.fromUri((String)("http://" + url.getIpAddress() + "/")).port(url.getPort()).build(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("get server URI error!", (Throwable)e);
            throw new RuntimeException("get server URI error!", e);
        }
        JerseyJettyServer jerseyServer = new JerseyJettyServer(resources[0], uri);
        this.setServer(jerseyServer, url);
        jerseyServer.startServer();
        return jerseyServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Client getClient(String serverType) {
        if (null != this.client) return this.client;
        Class<JerseyExchange> clazz = JerseyExchange.class;
        synchronized (JerseyExchange.class) {
            if (null != this.client) return this.client;
            JerseyClient jerseyClient = JerseyClient.getInstance();
            this.setClient(jerseyClient);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.client;
        }
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Server getServer(Integer port) {
        return this.serverMap.get(port);
    }

    public void setServer(Server server, URL url) {
        this.serverMap.putIfAbsent(url.getPort(), server);
    }
}

