/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.impl;

import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.conf.ConfigurationEntry;
import com.alipay.sofa.jraft.conf.ConfigurationManager;
import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.codec.LogEntryDecoder;
import com.alipay.sofa.jraft.entity.codec.LogEntryEncoder;
import com.alipay.sofa.jraft.option.LogStorageOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.LogStorage;
import com.alipay.sofa.jraft.util.Bits;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.DebugStatistics;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.StorageOptionsFactory;
import com.alipay.sofa.jraft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.MergeOperator;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBLogStorage
implements LogStorage,
Describer {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBLogStorage.class);
    private final String path;
    private final boolean sync;
    private final boolean openStatistics;
    private RocksDB db;
    private DBOptions dbOptions;
    private WriteOptions writeOptions;
    private final List<ColumnFamilyOptions> cfOptions = new ArrayList<ColumnFamilyOptions>();
    private ColumnFamilyHandle defaultHandle;
    private ColumnFamilyHandle confHandle;
    private ReadOptions totalOrderReadOptions;
    private DebugStatistics statistics;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private volatile long firstLogIndex = 1L;
    private volatile boolean hasLoadFirstLogIndex;
    private LogEntryEncoder logEntryEncoder;
    private LogEntryDecoder logEntryDecoder;
    public static final byte[] FIRST_LOG_IDX_KEY;

    public RocksDBLogStorage(String path, RaftOptions raftOptions) {
        this.path = path;
        this.sync = raftOptions.isSync();
        this.openStatistics = raftOptions.isOpenStatistics();
    }

    public static DBOptions createDBOptions() {
        return StorageOptionsFactory.getRocksDBOptions(RocksDBLogStorage.class);
    }

    public static ColumnFamilyOptions createColumnFamilyOptions() {
        BlockBasedTableConfig tConfig = StorageOptionsFactory.getRocksDBTableFormatConfig(RocksDBLogStorage.class);
        return StorageOptionsFactory.getRocksDBColumnFamilyOptions(RocksDBLogStorage.class).useFixedLengthPrefixExtractor(8).setTableFormatConfig((TableFormatConfig)tConfig).setMergeOperator((MergeOperator)new StringAppendOperator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(LogStorageOptions opts) {
        Requires.requireNonNull(opts.getConfigurationManager(), "Null conf manager");
        Requires.requireNonNull(opts.getLogEntryCodecFactory(), "Null log entry codec factory");
        this.writeLock.lock();
        try {
            if (this.db != null) {
                LOG.warn("RocksDBLogStorage init() already.");
                boolean bl = true;
                return bl;
            }
            this.logEntryDecoder = opts.getLogEntryCodecFactory().decoder();
            this.logEntryEncoder = opts.getLogEntryCodecFactory().encoder();
            Requires.requireNonNull(this.logEntryDecoder, "Null log entry decoder");
            Requires.requireNonNull(this.logEntryEncoder, "Null log entry encoder");
            this.dbOptions = RocksDBLogStorage.createDBOptions();
            if (this.openStatistics) {
                this.statistics = new DebugStatistics();
                this.dbOptions.setStatistics((Statistics)this.statistics);
            }
            this.writeOptions = new WriteOptions();
            this.writeOptions.setSync(this.sync);
            this.totalOrderReadOptions = new ReadOptions();
            this.totalOrderReadOptions.setTotalOrderSeek(true);
            boolean bl = this.initAndLoad(opts.getConfigurationManager());
            return bl;
        }
        catch (RocksDBException e) {
            LOG.error("Fail to init RocksDBLogStorage, path={}.", (Object)this.path, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean initAndLoad(ConfigurationManager confManager) throws RocksDBException {
        this.hasLoadFirstLogIndex = false;
        this.firstLogIndex = 1L;
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        ColumnFamilyOptions cfOption = RocksDBLogStorage.createColumnFamilyOptions();
        this.cfOptions.add(cfOption);
        columnFamilyDescriptors.add(new ColumnFamilyDescriptor("Configuration".getBytes(), cfOption));
        columnFamilyDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, cfOption));
        this.openDB(columnFamilyDescriptors);
        this.load(confManager);
        return this.onInitLoaded();
    }

    private void load(ConfigurationManager confManager) {
        this.checkState();
        try (RocksIterator it = this.db.newIterator(this.confHandle, this.totalOrderReadOptions);){
            it.seekToFirst();
            while (it.isValid()) {
                byte[] ks = it.key();
                byte[] bs = it.value();
                if (ks.length == 8) {
                    LogEntry entry = this.logEntryDecoder.decode(bs);
                    if (entry != null) {
                        if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                            ConfigurationEntry confEntry = new ConfigurationEntry();
                            confEntry.setId(new LogId(entry.getId().getIndex(), entry.getId().getTerm()));
                            confEntry.setConf(new Configuration(entry.getPeers(), entry.getLearners()));
                            if (entry.getOldPeers() != null) {
                                confEntry.setOldConf(new Configuration(entry.getOldPeers(), entry.getOldLearners()));
                            }
                            if (confManager != null) {
                                confManager.add(confEntry);
                            }
                        }
                    } else {
                        LOG.warn("Fail to decode conf entry at index {}, the log data is: {}.", (Object)Bits.getLong(ks, 0), (Object)BytesUtil.toHex(bs));
                    }
                } else if (Arrays.equals(FIRST_LOG_IDX_KEY, ks)) {
                    this.setFirstLogIndex(Bits.getLong(bs, 0));
                    this.truncatePrefixInBackground(0L, this.firstLogIndex);
                } else {
                    LOG.warn("Unknown entry in configuration storage key={}, value={}.", (Object)BytesUtil.toHex(ks), (Object)BytesUtil.toHex(bs));
                }
                it.next();
            }
        }
    }

    private void setFirstLogIndex(long index) {
        this.firstLogIndex = index;
        this.hasLoadFirstLogIndex = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFirstLogIndex(long firstLogIndex) {
        this.readLock.lock();
        try {
            byte[] vs = new byte[8];
            Bits.putLong(vs, 0, firstLogIndex);
            this.checkState();
            this.db.put(this.confHandle, this.writeOptions, FIRST_LOG_IDX_KEY, vs);
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            LOG.error("Fail to save first log index {}.", (Object)firstLogIndex, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void openDB(List<ColumnFamilyDescriptor> columnFamilyDescriptors) throws RocksDBException {
        ArrayList columnFamilyHandles = new ArrayList();
        File dir = new File(this.path);
        if (dir.exists() && !dir.isDirectory()) {
            throw new IllegalStateException("Invalid log path, it's a regular file: " + this.path);
        }
        this.db = RocksDB.open((DBOptions)this.dbOptions, (String)this.path, columnFamilyDescriptors, columnFamilyHandles);
        assert (columnFamilyHandles.size() == 2);
        this.confHandle = (ColumnFamilyHandle)columnFamilyHandles.get(0);
        this.defaultHandle = (ColumnFamilyHandle)columnFamilyHandles.get(1);
    }

    private void checkState() {
        Requires.requireNonNull(this.db, "DB not initialized or destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeBatch(WriteBatchTemplate template) {
        this.readLock.lock();
        if (this.db == null) {
            LOG.warn("DB not initialized or destroyed.");
            this.readLock.unlock();
            return false;
        }
        try (WriteBatch batch = new WriteBatch();){
            template.execute(batch);
            this.db.write(this.writeOptions, batch);
        }
        catch (RocksDBException e) {
            LOG.error("Execute batch failed with rocksdb exception.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Execute batch failed with io exception.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            LOG.error("Execute batch failed with interrupt.", (Throwable)e);
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.writeLock.lock();
        try {
            this.closeDB();
            this.onShutdown();
            for (ColumnFamilyOptions opt : this.cfOptions) {
                opt.close();
            }
            this.dbOptions.close();
            if (this.statistics != null) {
                this.statistics.close();
            }
            this.writeOptions.close();
            this.totalOrderReadOptions.close();
            this.cfOptions.clear();
            this.dbOptions = null;
            this.statistics = null;
            this.writeOptions = null;
            this.totalOrderReadOptions = null;
            this.defaultHandle = null;
            this.confHandle = null;
            this.db = null;
            LOG.info("DB destroyed, the db path is: {}.", (Object)this.path);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void closeDB() {
        this.confHandle.close();
        this.defaultHandle.close();
        this.db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFirstLogIndex() {
        this.readLock.lock();
        RocksIterator it = null;
        try {
            if (this.hasLoadFirstLogIndex) {
                long l = this.firstLogIndex;
                return l;
            }
            this.checkState();
            it = this.db.newIterator(this.defaultHandle, this.totalOrderReadOptions);
            it.seekToFirst();
            if (it.isValid()) {
                long ret = Bits.getLong(it.key(), 0);
                this.saveFirstLogIndex(ret);
                this.setFirstLogIndex(ret);
                long l = ret;
                return l;
            }
            long l = 1L;
            return l;
        }
        finally {
            if (it != null) {
                it.close();
            }
            this.readLock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public long getLastLogIndex() {
        this.readLock.lock();
        this.checkState();
        try {
            try (RocksIterator it = this.db.newIterator(this.defaultHandle, this.totalOrderReadOptions);){
                it.seekToLast();
                if (it.isValid()) {
                    long l = Bits.getLong(it.key(), 0);
                    return l;
                }
                long l = 0L;
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry getEntry(long index) {
        this.readLock.lock();
        try {
            if (this.hasLoadFirstLogIndex && index < this.firstLogIndex) {
                LogEntry logEntry = null;
                return logEntry;
            }
            byte[] keyBytes = this.getKeyBytes(index);
            byte[] bs = this.onDataGet(index, this.getValueFromRocksDB(keyBytes));
            if (bs != null) {
                LogEntry entry = this.logEntryDecoder.decode(bs);
                if (entry != null) {
                    LogEntry logEntry = entry;
                    return logEntry;
                }
                LOG.error("Bad log entry format for index={}, the log data is: {}.", (Object)index, (Object)BytesUtil.toHex(bs));
                LogEntry logEntry = null;
                return logEntry;
            }
        }
        catch (IOException | RocksDBException e) {
            LOG.error("Fail to get log entry at index {}.", (Object)index, (Object)e);
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    protected byte[] getValueFromRocksDB(byte[] keyBytes) throws RocksDBException {
        this.checkState();
        return this.db.get(this.defaultHandle, keyBytes);
    }

    protected byte[] getKeyBytes(long index) {
        byte[] ks = new byte[8];
        Bits.putLong(ks, 0, index);
        return ks;
    }

    @Override
    public long getTerm(long index) {
        LogEntry entry = this.getEntry(index);
        if (entry != null) {
            return entry.getId().getTerm();
        }
        return 0L;
    }

    private void addConfBatch(LogEntry entry, WriteBatch batch) throws RocksDBException {
        byte[] ks = this.getKeyBytes(entry.getId().getIndex());
        byte[] content = this.logEntryEncoder.encode(entry);
        batch.put(this.defaultHandle, ks, content);
        batch.put(this.confHandle, ks, content);
    }

    private void addDataBatch(LogEntry entry, WriteBatch batch, WriteContext ctx) throws RocksDBException, IOException, InterruptedException {
        long logIndex = entry.getId().getIndex();
        byte[] content = this.logEntryEncoder.encode(entry);
        batch.put(this.defaultHandle, this.getKeyBytes(logIndex), this.onDataAppend(logIndex, content, ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean appendEntry(LogEntry entry) {
        if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
            return this.executeBatch(batch -> this.addConfBatch(entry, batch));
        }
        this.readLock.lock();
        try {
            if (this.db == null) {
                LOG.warn("DB not initialized or destroyed.");
                boolean bl = false;
                return bl;
            }
            WriteContext writeCtx = this.newWriteContext();
            long logIndex = entry.getId().getIndex();
            byte[] valueBytes = this.logEntryEncoder.encode(entry);
            byte[] newValueBytes = this.onDataAppend(logIndex, valueBytes, writeCtx);
            writeCtx.startJob();
            this.db.put(this.defaultHandle, this.writeOptions, this.getKeyBytes(logIndex), newValueBytes);
            writeCtx.joinAll();
            if (newValueBytes != valueBytes) {
                this.doSync();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | RocksDBException e) {
            LOG.error("Fail to append entry.", e);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void doSync() throws IOException, InterruptedException {
        this.onSync();
    }

    @Override
    public int appendEntries(List<LogEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return 0;
        }
        int entriesCount = entries.size();
        boolean ret = this.executeBatch(batch -> {
            WriteContext writeCtx = this.newWriteContext();
            for (int i = 0; i < entriesCount; ++i) {
                LogEntry entry = (LogEntry)entries.get(i);
                if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                    this.addConfBatch(entry, batch);
                    continue;
                }
                writeCtx.startJob();
                this.addDataBatch(entry, batch, writeCtx);
            }
            writeCtx.joinAll();
            this.doSync();
        });
        if (ret) {
            return entriesCount;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncatePrefix(long firstIndexKept) {
        this.readLock.lock();
        try {
            long startIndex = this.getFirstLogIndex();
            boolean ret = this.saveFirstLogIndex(firstIndexKept);
            if (ret) {
                this.setFirstLogIndex(firstIndexKept);
            }
            this.truncatePrefixInBackground(startIndex, firstIndexKept);
            boolean bl = ret;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void truncatePrefixInBackground(long startIndex, long firstIndexKept) {
        Utils.runInThread(() -> {
            this.readLock.lock();
            try {
                if (this.db == null) {
                    return;
                }
                this.onTruncatePrefix(startIndex, firstIndexKept);
                this.db.deleteRange(this.defaultHandle, this.getKeyBytes(startIndex), this.getKeyBytes(firstIndexKept));
                this.db.deleteRange(this.confHandle, this.getKeyBytes(startIndex), this.getKeyBytes(firstIndexKept));
            }
            catch (IOException | RocksDBException e) {
                LOG.error("Fail to truncatePrefix {}.", (Object)firstIndexKept, (Object)e);
            }
            finally {
                this.readLock.unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncateSuffix(long lastIndexKept) {
        this.readLock.lock();
        try {
            try {
                this.onTruncateSuffix(lastIndexKept);
            }
            finally {
                this.db.deleteRange(this.defaultHandle, this.writeOptions, this.getKeyBytes(lastIndexKept + 1L), this.getKeyBytes(this.getLastLogIndex() + 1L));
                this.db.deleteRange(this.confHandle, this.writeOptions, this.getKeyBytes(lastIndexKept + 1L), this.getKeyBytes(this.getLastLogIndex() + 1L));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | RocksDBException e) {
            LOG.error("Fail to truncateSuffix {}.", (Object)lastIndexKept, (Object)e);
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean reset(long nextLogIndex) {
        if (nextLogIndex <= 0L) {
            throw new IllegalArgumentException("Invalid next log index.");
        }
        this.writeLock.lock();
        try {
            try (Options opt = new Options();){
                LogEntry entry = this.getEntry(nextLogIndex);
                this.closeDB();
                try {
                    RocksDB.destroyDB((String)this.path, (Options)opt);
                    this.onReset(nextLogIndex);
                    if (this.initAndLoad(null)) {
                        if (entry == null) {
                            entry = new LogEntry();
                            entry.setType(EnumOutter.EntryType.ENTRY_TYPE_NO_OP);
                            entry.setId(new LogId(nextLogIndex, 0L));
                            LOG.warn("Entry not found for nextLogIndex {} when reset.", (Object)nextLogIndex);
                        }
                        boolean bl = this.appendEntry(entry);
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (RocksDBException e) {
                    LOG.error("Fail to reset next log index.", (Throwable)e);
                    boolean bl = false;
                    this.writeLock.unlock();
                    return bl;
                }
            }
            {
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected boolean onInitLoaded() {
        return true;
    }

    protected void onShutdown() {
    }

    protected void onReset(long nextLogIndex) {
    }

    protected void onTruncatePrefix(long startIndex, long firstIndexKept) throws RocksDBException, IOException {
    }

    protected void onSync() throws IOException, InterruptedException {
    }

    protected boolean isSync() {
        return this.sync;
    }

    protected void onTruncateSuffix(long lastIndexKept) throws RocksDBException, IOException {
    }

    protected WriteContext newWriteContext() {
        return EmptyWriteContext.INSTANCE;
    }

    protected byte[] onDataAppend(long logIndex, byte[] value, WriteContext ctx) throws IOException, InterruptedException {
        ctx.finishJob();
        return value;
    }

    protected byte[] onDataGet(long logIndex, byte[] value) throws IOException {
        return value;
    }

    @Override
    public void describe(Describer.Printer out) {
        this.readLock.lock();
        try {
            if (this.db != null) {
                out.println(this.db.getProperty("rocksdb.stats"));
            }
            out.println("");
            if (this.statistics != null) {
                out.println(this.statistics.getString());
            }
        }
        catch (RocksDBException e) {
            out.println((Object)e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    static {
        RocksDB.loadLibrary();
        FIRST_LOG_IDX_KEY = Utils.getBytes("meta/firstLogIndex");
    }

    protected static class EmptyWriteContext
    implements WriteContext {
        static EmptyWriteContext INSTANCE = new EmptyWriteContext();

        protected EmptyWriteContext() {
        }
    }

    public static interface WriteContext {
        default public void startJob() {
        }

        default public void finishJob() {
        }

        default public void addFinishHook(Runnable r) {
        }

        default public void setError(Exception e) {
        }

        default public void joinAll() throws InterruptedException, IOException {
        }
    }

    private static interface WriteBatchTemplate {
        public void execute(WriteBatch var1) throws RocksDBException, IOException, InterruptedException;
    }
}

