/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.impl;

import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.core.NodeMetrics;
import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LocalStorageOutter;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.option.RaftMetaStorageOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.RaftMetaStorage;
import com.alipay.sofa.jraft.storage.io.ProtoBufFile;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.Message;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRaftMetaStorage
implements RaftMetaStorage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalRaftMetaStorage.class);
    private static final String RAFT_META = "raft_meta";
    private boolean isInited;
    private final String path;
    private long term;
    private PeerId votedFor = PeerId.emptyPeer();
    private final RaftOptions raftOptions;
    private NodeMetrics nodeMetrics;
    private NodeImpl node;

    public LocalRaftMetaStorage(String path, RaftOptions raftOptions) {
        this.path = path;
        this.raftOptions = raftOptions;
    }

    @Override
    public boolean init(RaftMetaStorageOptions opts) {
        if (this.isInited) {
            LOG.warn("Raft meta storage is already inited.");
            return true;
        }
        this.node = opts.getNode();
        this.nodeMetrics = this.node.getNodeMetrics();
        try {
            FileUtils.forceMkdir((File)new File(this.path));
        }
        catch (IOException e) {
            LOG.error("Fail to mkdir {}", (Object)this.path);
            return false;
        }
        if (this.load()) {
            this.isInited = true;
            return true;
        }
        return false;
    }

    private boolean load() {
        ProtoBufFile pbFile = this.newPbFile();
        try {
            LocalStorageOutter.StablePBMeta meta = (LocalStorageOutter.StablePBMeta)pbFile.load();
            if (meta != null) {
                this.term = meta.getTerm();
                return this.votedFor.parse(meta.getVotedfor());
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (IOException e) {
            LOG.error("Fail to load raft meta storage", (Throwable)e);
            return false;
        }
    }

    private ProtoBufFile newPbFile() {
        return new ProtoBufFile(this.path + File.separator + RAFT_META);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save() {
        boolean bl;
        long start;
        block9: {
            start = Utils.monotonicMs();
            LocalStorageOutter.StablePBMeta meta = LocalStorageOutter.StablePBMeta.newBuilder().setTerm(this.term).setVotedfor(this.votedFor.toString()).build();
            ProtoBufFile pbFile = this.newPbFile();
            if (pbFile.save((Message)meta, this.raftOptions.isSyncMeta())) break block9;
            this.reportIOError();
            boolean bl2 = false;
            long cost = Utils.monotonicMs() - start;
            if (this.nodeMetrics != null) {
                this.nodeMetrics.recordLatency("save-raft-meta", cost);
            }
            LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Exception e) {
            boolean bl3;
            try {
                LOG.error("Fail to save raft meta", (Throwable)e);
                this.reportIOError();
                bl3 = false;
            }
            catch (Throwable throwable) {
                long cost = Utils.monotonicMs() - start;
                if (this.nodeMetrics != null) {
                    this.nodeMetrics.recordLatency("save-raft-meta", cost);
                }
                LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
                throw throwable;
            }
            long cost = Utils.monotonicMs() - start;
            if (this.nodeMetrics != null) {
                this.nodeMetrics.recordLatency("save-raft-meta", cost);
            }
            LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
            return bl3;
        }
        long cost = Utils.monotonicMs() - start;
        if (this.nodeMetrics != null) {
            this.nodeMetrics.recordLatency("save-raft-meta", cost);
        }
        LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
        return bl;
    }

    private void reportIOError() {
        this.node.onError(new RaftException(EnumOutter.ErrorType.ERROR_TYPE_META, RaftError.EIO, "Fail to save raft meta, path=%s", this.path));
    }

    @Override
    public void shutdown() {
        if (!this.isInited) {
            return;
        }
        this.save();
        this.isInited = false;
    }

    private void checkState() {
        if (!this.isInited) {
            throw new IllegalStateException("LocalRaftMetaStorage not initialized");
        }
    }

    @Override
    public boolean setTerm(long term) {
        this.checkState();
        this.term = term;
        return this.save();
    }

    @Override
    public long getTerm() {
        this.checkState();
        return this.term;
    }

    @Override
    public boolean setVotedFor(PeerId peerId) {
        this.checkState();
        this.votedFor = peerId;
        return this.save();
    }

    @Override
    public PeerId getVotedFor() {
        this.checkState();
        return this.votedFor;
    }

    @Override
    public boolean setTermAndVotedFor(long term, PeerId peerId) {
        this.checkState();
        this.votedFor = peerId;
        this.term = term;
        return this.save();
    }

    public String toString() {
        return "RaftMetaStorageImpl [path=" + this.path + ", term=" + this.term + ", votedFor=" + this.votedFor + "]";
    }
}

