/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage;

import com.alipay.sofa.jraft.core.NodeMetrics;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.LogManager;
import com.alipay.sofa.jraft.storage.LogStorage;
import com.alipay.sofa.jraft.storage.RaftMetaStorage;
import com.alipay.sofa.jraft.storage.SnapshotStorage;
import com.alipay.sofa.jraft.storage.impl.LocalRaftMetaStorage;
import com.alipay.sofa.jraft.storage.impl.LogManagerImpl;
import com.alipay.sofa.jraft.storage.impl.RocksDBLogStorage;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotStorage;
import com.alipay.sofa.jraft.util.Requires;
import org.apache.commons.lang.StringUtils;

public class StorageFactory {
    public static LogStorage createLogStorage(String uri, RaftOptions raftOptions) {
        Requires.requireTrue(!StringUtils.isBlank((String)uri), "Blank log storage uri.");
        return new RocksDBLogStorage(uri, raftOptions);
    }

    public static LogManager createLogManager() {
        return new LogManagerImpl();
    }

    public static SnapshotStorage createSnapshotStorage(String uri, RaftOptions raftOptions) {
        Requires.requireTrue(!StringUtils.isBlank((String)uri), "Blank snapshot storage uri.");
        return new LocalSnapshotStorage(uri, raftOptions);
    }

    public static RaftMetaStorage createRaftMetaStorage(String uri, RaftOptions raftOptions, NodeMetrics nodeMetrics) {
        Requires.requireTrue(!StringUtils.isBlank((String)uri), "Blank raft meta storage uri.");
        return new LocalRaftMetaStorage(uri, raftOptions, nodeMetrics);
    }
}

