/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc;

import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.rpc.RpcServer;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.jraft.rpc.impl.PingRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.cli.AddPeerRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.cli.ChangePeersRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.cli.GetLeaderRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.cli.GetPeersRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.cli.RemovePeerRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.cli.ResetPeerRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.cli.SnapshotRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.cli.TransferLeaderRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.core.AppendEntriesRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.core.GetFileRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.core.InstallSnapshotRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.core.ReadIndexRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.core.RequestVoteRequestProcessor;
import com.alipay.sofa.jraft.rpc.impl.core.TimeoutNowRequestProcessor;
import com.alipay.sofa.jraft.util.Endpoint;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftRpcServerFactory {
    public static final Logger LOG = LoggerFactory.getLogger(RaftRpcServerFactory.class);

    public static RpcServer createRaftRpcServer(Endpoint endpoint) {
        return RaftRpcServerFactory.createRaftRpcServer(endpoint, null, null);
    }

    public static RpcServer createRaftRpcServer(Endpoint endpoint, Executor raftExecutor, Executor cliExecutor) {
        RpcServer rpcServer = new RpcServer(endpoint.getPort(), true, true);
        RaftRpcServerFactory.addRaftRequestProcessors(rpcServer, raftExecutor, cliExecutor);
        return rpcServer;
    }

    public static void addRaftRequestProcessors(RpcServer rpcServer) {
        RaftRpcServerFactory.addRaftRequestProcessors(rpcServer, null, null);
    }

    public static void addRaftRequestProcessors(RpcServer rpcServer, Executor raftExecutor, Executor cliExecutor) {
        AppendEntriesRequestProcessor appendEntriesRequestProcessor = new AppendEntriesRequestProcessor(raftExecutor);
        rpcServer.addConnectionEventProcessor(ConnectionEventType.CLOSE, (ConnectionEventProcessor)appendEntriesRequestProcessor);
        rpcServer.registerUserProcessor((UserProcessor)appendEntriesRequestProcessor);
        rpcServer.registerUserProcessor((UserProcessor)new GetFileRequestProcessor(raftExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new InstallSnapshotRequestProcessor(raftExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new RequestVoteRequestProcessor(raftExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new PingRequestProcessor());
        rpcServer.registerUserProcessor((UserProcessor)new TimeoutNowRequestProcessor(raftExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new ReadIndexRequestProcessor(raftExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new AddPeerRequestProcessor(cliExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new RemovePeerRequestProcessor(cliExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new ResetPeerRequestProcessor(cliExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new ChangePeersRequestProcessor(cliExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new GetLeaderRequestProcessor(cliExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new SnapshotRequestProcessor(cliExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new TransferLeaderRequestProcessor(cliExecutor));
        rpcServer.registerUserProcessor((UserProcessor)new GetPeersRequestProcessor(cliExecutor));
    }

    public static RpcServer createAndStartRaftRpcServer(Endpoint endpoint) {
        return RaftRpcServerFactory.createAndStartRaftRpcServer(endpoint, null, null);
    }

    public static RpcServer createAndStartRaftRpcServer(Endpoint endpoint, Executor raftExecutor, Executor cliExecutor) {
        RpcServer server = RaftRpcServerFactory.createRaftRpcServer(endpoint, raftExecutor, cliExecutor);
        server.start();
        return server;
    }
}

