/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.JRaftException;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.impl.cli.BoltCliClientService;
import com.alipay.sofa.jraft.util.Requires;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliServiceImpl
implements CliService {
    private static final Logger LOG = LoggerFactory.getLogger(CliServiceImpl.class);
    private CliOptions cliOptions;
    private CliClientService cliClientService;

    @Override
    public synchronized boolean init(CliOptions opts) {
        Requires.requireNonNull(opts, "Null cli options");
        if (this.cliClientService != null) {
            return true;
        }
        this.cliOptions = opts;
        this.cliClientService = new BoltCliClientService();
        return this.cliClientService.init(this.cliOptions);
    }

    @Override
    public synchronized void shutdown() {
        if (this.cliClientService == null) {
            return;
        }
        this.cliClientService.shutdown();
        this.cliClientService = null;
    }

    @Override
    public Status addPeer(String groupId, Configuration conf, PeerId peer) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireNonNull(peer, "Null peer");
        PeerId leaderId = new PeerId();
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        if (!this.cliClientService.connect(leaderId.getEndpoint())) {
            return new Status(-1, "Fail to init channel to leader %s", leaderId);
        }
        CliRequests.AddPeerRequest.Builder rb = CliRequests.AddPeerRequest.newBuilder();
        rb.setGroupId(groupId);
        rb.setLeaderId(leaderId.toString());
        rb.setPeerId(peer.toString());
        try {
            Message result = this.cliClientService.addPeer(leaderId.getEndpoint(), rb.build(), null).get();
            if (result instanceof CliRequests.AddPeerResponse) {
                CliRequests.AddPeerResponse resp = (CliRequests.AddPeerResponse)result;
                Configuration oldConf = new Configuration();
                for (String peerIdStr : resp.getOldPeersList()) {
                    PeerId oldPeer = new PeerId();
                    oldPeer.parse(peerIdStr);
                    oldConf.addPeer(oldPeer);
                }
                Configuration newConf = new Configuration();
                for (String peerIdStr : resp.getNewPeersList()) {
                    PeerId newPeer = new PeerId();
                    newPeer.parse(peerIdStr);
                    newConf.addPeer(newPeer);
                }
                LOG.info("Configuration of replication group {} changed from {} to {}", new Object[]{groupId, oldConf, newConf});
                return Status.OK();
            }
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    private Status statusFromResponse(Message result) {
        RpcRequests.ErrorResponse resp = (RpcRequests.ErrorResponse)result;
        return new Status(resp.getErrorCode(), resp.getErrorMsg());
    }

    @Override
    public Status removePeer(String groupId, Configuration conf, PeerId peer) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireNonNull(peer, "Null peer");
        Requires.requireTrue(!peer.isEmpty(), "Removing peer is blank");
        PeerId leaderId = new PeerId();
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        if (!this.cliClientService.connect(leaderId.getEndpoint())) {
            return new Status(-1, "Fail to init channel to leader %s", leaderId);
        }
        CliRequests.RemovePeerRequest.Builder rb = CliRequests.RemovePeerRequest.newBuilder();
        rb.setGroupId(groupId);
        rb.setLeaderId(leaderId.toString());
        rb.setPeerId(peer.toString());
        try {
            Message result = this.cliClientService.removePeer(leaderId.getEndpoint(), rb.build(), null).get();
            if (result instanceof CliRequests.RemovePeerResponse) {
                CliRequests.RemovePeerResponse resp = (CliRequests.RemovePeerResponse)result;
                Configuration oldConf = new Configuration();
                for (String peerIdStr : resp.getOldPeersList()) {
                    PeerId oldPeer = new PeerId();
                    oldPeer.parse(peerIdStr);
                    oldConf.addPeer(oldPeer);
                }
                Configuration newConf = new Configuration();
                for (String peerIdStr : resp.getNewPeersList()) {
                    PeerId newPeer = new PeerId();
                    newPeer.parse(peerIdStr);
                    newConf.addPeer(newPeer);
                }
                LOG.info("Configuration of replication group {} changed from {} to {}", new Object[]{groupId, oldConf, newConf});
                return Status.OK();
            }
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status changePeers(String groupId, Configuration conf, Configuration newPeers) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireNonNull(newPeers, "Null new peers");
        PeerId leaderId = new PeerId();
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        if (!this.cliClientService.connect(leaderId.getEndpoint())) {
            return new Status(-1, "Fail to init channel to leader %s", leaderId);
        }
        CliRequests.ChangePeersRequest.Builder rb = CliRequests.ChangePeersRequest.newBuilder();
        rb.setGroupId(groupId);
        rb.setLeaderId(leaderId.toString());
        for (PeerId peer : newPeers) {
            rb.addNewPeers(peer.toString());
        }
        try {
            Message result = this.cliClientService.changePeers(leaderId.getEndpoint(), rb.build(), null).get();
            if (result instanceof CliRequests.ChangePeersResponse) {
                CliRequests.ChangePeersResponse resp = (CliRequests.ChangePeersResponse)result;
                Configuration oldConf = new Configuration();
                for (String peerIdStr : resp.getOldPeersList()) {
                    PeerId oldPeer = new PeerId();
                    oldPeer.parse(peerIdStr);
                    oldConf.addPeer(oldPeer);
                }
                Configuration newConf = new Configuration();
                for (String peerIdStr : resp.getNewPeersList()) {
                    PeerId newPeer = new PeerId();
                    newPeer.parse(peerIdStr);
                    newConf.addPeer(newPeer);
                }
                LOG.info("Configuration of replication group {} changed from {} to {}", new Object[]{groupId, oldConf, newConf});
                return Status.OK();
            }
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status resetPeer(String groupId, PeerId peerId, Configuration newPeers) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireNonNull(peerId, "Null peerId");
        Requires.requireNonNull(newPeers, "Null new peers");
        if (!this.cliClientService.connect(peerId.getEndpoint())) {
            return new Status(-1, "Fail to init channel to %s", peerId);
        }
        CliRequests.ResetPeerRequest.Builder rb = CliRequests.ResetPeerRequest.newBuilder();
        rb.setGroupId(groupId);
        rb.setPeerId(peerId.toString());
        for (PeerId peer : newPeers) {
            rb.addNewPeers(peer.toString());
        }
        try {
            Message result = this.cliClientService.resetPeer(peerId.getEndpoint(), rb.build(), null).get();
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status transferLeader(String groupId, Configuration conf, PeerId peer) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireNonNull(peer, "Null peer");
        PeerId leaderId = new PeerId();
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        if (!this.cliClientService.connect(leaderId.getEndpoint())) {
            return new Status(-1, "Fail to init channel to leader %s", leaderId);
        }
        CliRequests.TransferLeaderRequest.Builder rb = CliRequests.TransferLeaderRequest.newBuilder();
        rb.setGroupId(groupId);
        rb.setLeaderId(leaderId.toString());
        if (!peer.isEmpty()) {
            rb.setPeerId(peer.toString());
        }
        try {
            Message result = this.cliClientService.transferLeader(leaderId.getEndpoint(), rb.build(), null).get();
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status snapshot(String groupId, PeerId peer) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireNonNull(peer, "Null peer");
        if (!this.cliClientService.connect(peer.getEndpoint())) {
            return new Status(-1, "Fail to init channel to %s", peer);
        }
        CliRequests.SnapshotRequest.Builder rb = CliRequests.SnapshotRequest.newBuilder();
        rb.setGroupId(groupId);
        rb.setPeerId(peer.toString());
        try {
            Message result = this.cliClientService.snapshot(peer.getEndpoint(), rb.build(), null).get();
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status getLeader(String groupId, Configuration conf, PeerId leaderId) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireNonNull(leaderId, "Null leader id");
        if (conf == null || conf.isEmpty()) {
            return new Status(RaftError.EINVAL, "Empty group configuration", new Object[0]);
        }
        Status st = new Status(-1, "Fail to get leader of group %s", groupId);
        for (PeerId peer : conf) {
            String savedMsg;
            if (!this.cliClientService.connect(peer.getEndpoint())) {
                LOG.error("Fail to connect peer {} to get leader for group {}.", (Object)groupId);
                continue;
            }
            CliRequests.GetLeaderRequest.Builder rb = CliRequests.GetLeaderRequest.newBuilder();
            rb.setGroupId(groupId);
            rb.setPeerId(peer.toString());
            Future<Message> result = this.cliClientService.getLeader(peer.getEndpoint(), rb.build(), null);
            try {
                Message msg = result.get(this.cliOptions.getTimeoutMs() <= 0 ? (long)this.cliOptions.getRpcDefaultTimeout() : (long)this.cliOptions.getTimeoutMs(), TimeUnit.MILLISECONDS);
                if (msg instanceof RpcRequests.ErrorResponse) {
                    if (st.isOk()) {
                        st.setError(-1, ((RpcRequests.ErrorResponse)msg).getErrorMsg(), new Object[0]);
                        continue;
                    }
                    savedMsg = st.getErrorMsg();
                    st.setError(-1, "%s, %s", savedMsg, ((RpcRequests.ErrorResponse)msg).getErrorMsg());
                    continue;
                }
                CliRequests.GetLeaderResponse response = (CliRequests.GetLeaderResponse)msg;
                if (!leaderId.parse(response.getLeaderId())) continue;
                break;
            }
            catch (Exception e) {
                if (st.isOk()) {
                    st.setError(-1, e.getMessage(), new Object[0]);
                    continue;
                }
                savedMsg = st.getErrorMsg();
                st.setError(-1, "%s, %s", savedMsg, e.getMessage());
            }
        }
        if (leaderId.isEmpty()) {
            return st;
        }
        return Status.OK();
    }

    @Override
    public List<PeerId> getPeers(String groupId, Configuration conf) {
        Requires.requireTrue(!StringUtils.isBlank((String)groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null conf");
        PeerId leaderId = new PeerId();
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            throw new IllegalStateException(st.getErrorMsg());
        }
        if (!this.cliClientService.connect(leaderId.getEndpoint())) {
            throw new IllegalStateException("Fail to init channel to leader " + leaderId);
        }
        CliRequests.GetPeersRequest.Builder rb = CliRequests.GetPeersRequest.newBuilder();
        rb.setGroupId(groupId);
        rb.setLeaderId(leaderId.toString());
        try {
            Message result = this.cliClientService.getPeers(leaderId.getEndpoint(), rb.build(), null).get(this.cliOptions.getTimeoutMs() <= 0 ? (long)this.cliOptions.getRpcDefaultTimeout() : (long)this.cliOptions.getTimeoutMs(), TimeUnit.MILLISECONDS);
            if (result instanceof CliRequests.GetPeersResponse) {
                CliRequests.GetPeersResponse resp = (CliRequests.GetPeersResponse)result;
                ArrayList<PeerId> peerIdList = new ArrayList<PeerId>();
                for (String peerIdStr : resp.getPeersList()) {
                    PeerId newPeer = new PeerId();
                    newPeer.parse(peerIdStr);
                    peerIdList.add(newPeer);
                }
                return peerIdList;
            }
            RpcRequests.ErrorResponse resp = (RpcRequests.ErrorResponse)result;
            throw new JRaftException(resp.getErrorMsg());
        }
        catch (JRaftException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRaftException(e);
        }
    }

    public CliClientService getCliClientService() {
        return this.cliClientService;
    }
}

