/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.closure;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.closure.ClosureQueue;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosureQueueImpl
implements ClosureQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ClosureQueueImpl.class);
    private final Lock lock = new ReentrantLock();
    private long firstIndex = 0L;
    private LinkedList<Closure> queue = new LinkedList();

    @OnlyForTest
    public long getFirstIndex() {
        return this.firstIndex;
    }

    @OnlyForTest
    public LinkedList<Closure> getQueue() {
        return this.queue;
    }

    @Override
    public void clear() {
        LinkedList<Closure> savedQueue;
        this.lock.lock();
        try {
            this.firstIndex = 0L;
            savedQueue = this.queue;
            this.queue = new LinkedList();
        }
        finally {
            this.lock.unlock();
        }
        Status status = new Status(RaftError.EPERM, "Leader stepped down", new Object[0]);
        for (Closure done : savedQueue) {
            if (done == null) continue;
            Utils.runClosureInThread(done, status);
        }
    }

    @Override
    public void resetFirstIndex(long firstIndex) {
        this.lock.lock();
        try {
            Requires.requireTrue(this.queue.isEmpty(), "Queue is not empty.");
            this.firstIndex = firstIndex;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void appendPendingClosure(Closure closure) {
        this.lock.lock();
        try {
            this.queue.add(closure);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long popClosureUntil(long index, List<Closure> out) {
        out.clear();
        this.lock.lock();
        try {
            if (this.queue.isEmpty() || index < this.firstIndex) {
                long outFirstIndex;
                long l = outFirstIndex = index + 1L;
                return l;
            }
            if (index > this.firstIndex + (long)this.queue.size() - 1L) {
                LOG.error("Invalid index={}, firstIndex={}, closureQueueSize={}", new Object[]{index, this.firstIndex, this.queue.size()});
                long l = -1L;
                return l;
            }
            long outFirstIndex = this.firstIndex;
            for (long i = this.firstIndex; i <= index; ++i) {
                out.add(this.queue.pollFirst());
            }
            this.firstIndex = index + 1L;
            long l = outFirstIndex;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

