/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.infra.autoconfigure;

import com.alipay.sofa.infra.endpoint.SofaBootVersionEndpoint;
import com.alipay.sofa.infra.endpoint.SofaBootVersionEndpointMvcAdapter;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SofaBootInfraAutoConfiguration {

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={Endpoint.class})
    public static class SofaBootVersionEndpointMvcAdapterConfiguration {
        @Bean
        @ConditionalOnProperty(prefix="com.alipay.sofa.versions", name={"enabled"}, matchIfMissing=true)
        public SofaBootVersionEndpointMvcAdapter sofaBootVersionEndpointMvcAdapter(SofaBootVersionEndpoint sofaBootVersionEndpoint) {
            return new SofaBootVersionEndpointMvcAdapter(sofaBootVersionEndpoint);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    public static class SofaBootVersionEndpointConfiguration {
        @Bean
        @ConditionalOnProperty(prefix="com.alipay.sofa.versions", name={"enabled"}, matchIfMissing=true)
        public SofaBootVersionEndpoint sofaBootVersionEndpoint() {
            return new SofaBootVersionEndpoint();
        }
    }
}

