/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.config;

import java.util.Arrays;

public class ConfigKey<T> {
    private final String key;
    private final String[] alias;
    private final T defaultValue;
    private final String description;
    private final boolean modifiable;

    public ConfigKey(String key, String[] alias, T defaultValue, boolean modifiable, String description) {
        this.preCheckNotNull("key", key);
        this.preCheckNotNull("defaultValue", defaultValue);
        this.preCheckNotNull("description", description);
        this.key = key;
        this.alias = null == alias ? new String[0] : alias;
        this.defaultValue = defaultValue;
        this.modifiable = modifiable;
        this.description = description;
    }

    public static <T> ConfigKey<T> build(String key, T defaultValue, boolean modifiable, String description) {
        return new ConfigKey<T>(key, null, defaultValue, modifiable, description);
    }

    public static <T> ConfigKey<T> build(String key, T defaultValue, boolean modifiable, String description, String[] alias) {
        return new ConfigKey<T>(key, alias, defaultValue, modifiable, description);
    }

    private void preCheckNotNull(String key, Object value) {
        if (value == null) {
            throw new NullPointerException("\"" + key + "\" of ConfigKey cannot be null,please check it");
        }
    }

    public String getKey() {
        return this.key;
    }

    public String[] getAlias() {
        return Arrays.copyOf(this.alias, this.alias.length);
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<T> getType() {
        return this.defaultValue.getClass();
    }

    public boolean isModifiable() {
        return this.modifiable;
    }
}

