/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.sofa.common.utils.StringUtil;
import java.util.concurrent.TimeUnit;

public class ThreadPoolConfig {
    private String threadPoolName;
    private String spaceName;
    private long taskTimeout;
    private long period;
    private TimeUnit timeUnit;
    private long taskTimeoutMilli;
    private String identity;

    public static SofaThreadConfigBuilder newBuilder() {
        return new SofaThreadConfigBuilder();
    }

    public ThreadPoolConfig(SofaThreadConfigBuilder builder) {
        this.threadPoolName = builder.threadPoolName;
        this.spaceName = builder.spaceName;
        this.taskTimeout = builder.taskTimeout == 0L ? 30000L : builder.taskTimeout;
        this.period = builder.period == 0L ? 5000L : builder.period;
        this.timeUnit = builder.timeUnit == null ? TimeUnit.MILLISECONDS : builder.timeUnit;
        this.taskTimeoutMilli = this.timeUnit.toMillis(this.taskTimeout);
        this.identity = ThreadPoolConfig.buildIdentity(this.threadPoolName, this.spaceName);
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public long getTaskTimeout() {
        return this.taskTimeout;
    }

    public long getPeriod() {
        return this.period;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getTaskTimeoutMilli() {
        return this.taskTimeoutMilli;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
        this.identity = ThreadPoolConfig.buildIdentity(this.threadPoolName, this.spaceName);
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
        this.identity = ThreadPoolConfig.buildIdentity(this.threadPoolName, this.spaceName);
    }

    public void setTaskTimeout(long taskTimeout) {
        this.taskTimeout = taskTimeout;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setTaskTimeoutMilli(long taskTimeoutMilli) {
        this.taskTimeoutMilli = taskTimeoutMilli;
    }

    public static String buildIdentity(String threadPoolName, String spaceName) {
        if (StringUtil.isEmpty(spaceName)) {
            return threadPoolName;
        }
        return spaceName + "-" + threadPoolName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThreadPoolConfig{");
        sb.append("threadPoolName='").append(this.threadPoolName).append('\'');
        sb.append(", spaceName='").append(this.spaceName).append('\'');
        sb.append(", taskTimeout=").append(this.taskTimeout);
        sb.append(", period=").append(this.period);
        sb.append(", timeUnit=").append((Object)this.timeUnit);
        sb.append(", taskTimeoutMilli=").append(this.taskTimeoutMilli);
        sb.append(", identity='").append(this.identity).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static final class SofaThreadConfigBuilder {
        private String threadPoolName;
        private String spaceName;
        private long taskTimeout;
        private long period;
        private TimeUnit timeUnit;

        private SofaThreadConfigBuilder() {
        }

        public SofaThreadConfigBuilder threadPoolName(String threadPoolName) {
            this.threadPoolName = threadPoolName;
            return this;
        }

        public SofaThreadConfigBuilder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public SofaThreadConfigBuilder taskTimeout(long taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        public SofaThreadConfigBuilder period(long period) {
            this.period = period;
            return this;
        }

        public SofaThreadConfigBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public ThreadPoolConfig build() {
            return new ThreadPoolConfig(this);
        }
    }
}

