/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.OptionHelper;
import com.alipay.sofa.common.log.CommonLoggingConfigurations;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.space.SpaceId;
import com.alipay.sofa.common.utils.StringUtil;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class LogbackLoggerSpaceFactory
extends AbstractLoggerSpaceFactory {
    private SpaceId spaceId;
    private LoggerContext loggerContext;
    private Properties properties;
    private final ConsoleAppender<ILoggingEvent> consoleAppender;
    private final Level consoleLevel;

    public LogbackLoggerSpaceFactory(SpaceId spaceId, LoggerContext loggerContext, Properties properties, URL confFile, String source) {
        super(source);
        this.spaceId = spaceId;
        this.loggerContext = loggerContext;
        this.properties = properties;
        this.consoleAppender = this.createConsoleAppender(loggerContext, properties);
        this.consoleLevel = this.getConsoleLevel(spaceId.getSpaceName(), properties);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            loggerContext.putProperty((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            new ContextInitializer(loggerContext).configureByResource(confFile);
        }
        catch (JoranException e) {
            throw new IllegalStateException("Logback loggerSpaceFactory build error", e);
        }
        String value = properties.getProperty(String.format("sofa.middleware.log.%s.console", spaceId.getSpaceName()));
        if (StringUtil.isEmpty(value)) {
            value = properties.getProperty("sofa.middleware.log.console");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            loggerContext.addTurboFilter(new TurboFilter(){

                public FilterReply decide(Marker marker, ch.qos.logback.classic.Logger logger, Level level, String format, Object[] params, Throwable t) {
                    if (CommonLoggingConfigurations.shouldAttachConsoleAppender(logger.getName()) && !logger.isAttached((Appender)LogbackLoggerSpaceFactory.this.consoleAppender)) {
                        logger.addAppender((Appender)LogbackLoggerSpaceFactory.this.consoleAppender);
                        if (logger.getEffectiveLevel().isGreaterOrEqual(LogbackLoggerSpaceFactory.this.consoleLevel)) {
                            logger.setLevel(LogbackLoggerSpaceFactory.this.consoleLevel);
                        }
                    }
                    return FilterReply.NEUTRAL;
                }
            });
        }
    }

    private ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext loggerContext, Properties properties) {
        ConsoleAppender appender = new ConsoleAppender();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        String logPattern = properties.getProperty("sofa.middleware.log.console.logback.pattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} %5p ${PID:- } --- [%15.15t] %-40.40logger{39} : %m%n");
        encoder.setPattern(OptionHelper.substVars((String)logPattern, (PropertyContainer)loggerContext));
        encoder.setContext((Context)loggerContext);
        encoder.start();
        appender.setEncoder((Encoder)encoder);
        appender.setName("CONSOLE");
        appender.start();
        return appender;
    }

    public SpaceId getSpaceId() {
        return this.spaceId;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private Level getConsoleLevel(String spaceId, Properties properties) {
        String defaultLevel = properties.getProperty("sofa.middleware.log.console.level", "INFO");
        String level = properties.getProperty(String.format("sofa.middleware.log.%s.console.level", spaceId), defaultLevel);
        return Level.toLevel((String)level, (Level)Level.INFO);
    }

    public Logger getLogger(String name) {
        return this.loggerContext.getLogger(name);
    }

    @Override
    public Logger setLevel(String loggerName, AdapterLevel adapterLevel) {
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)this.getLogger(loggerName);
        Level logbackLevel = this.toLogbackLevel(adapterLevel);
        logbackLogger.setLevel(logbackLevel);
        return logbackLogger;
    }

    @Deprecated
    public void reInitialize(Map<String, String> environment) {
    }

    private Level toLogbackLevel(AdapterLevel adapterLevel) {
        if (adapterLevel == null) {
            throw new IllegalStateException("AdapterLevel is NULL when adapter to logback.");
        }
        switch (adapterLevel) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        throw new IllegalStateException((Object)((Object)adapterLevel) + " is unknown when adapter to logback.");
    }
}

