/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import com.alipay.sofa.common.log.CommonLoggingConfigurations;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.space.SpaceId;
import com.alipay.sofa.common.utils.StringUtil;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.slf4j.Log4jLogger;
import org.slf4j.Logger;

public class Log4j2LoggerSpaceFactory
extends AbstractLoggerSpaceFactory {
    private static final String CONSOLE = "CONSOLE";
    private ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();
    private SpaceId spaceId;
    private Properties properties;
    private LoggerContext loggerContext;
    private URL confFile;
    private final ConsoleAppender consoleAppender;
    private final Level consoleLevel;

    public Log4j2LoggerSpaceFactory(SpaceId spaceId, Properties properties, URL confFile, String source) throws Throwable {
        super(source);
        this.spaceId = spaceId;
        this.properties = properties;
        this.confFile = confFile;
        this.consoleAppender = this.createConsoleAppender();
        this.consoleLevel = this.getConsoleLevel();
        this.loggerContext = this.initialize();
        this.attachConsoleAppender();
    }

    private LoggerContext initialize() throws Throwable {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            ThreadContext.put((String)((String)entry.getKey()), (String)this.properties.getProperty((String)entry.getKey()));
        }
        LoggerContext context = new LoggerContext(this.spaceId.getSpaceName(), null, this.confFile.toURI());
        Configuration config = null;
        ConfigurationFactory configurationFactory = ConfigurationFactory.getInstance();
        try {
            Method getConfigurationMethod = configurationFactory.getClass().getMethod("getConfiguration", String.class, URI.class, ClassLoader.class);
            config = (Configuration)getConfigurationMethod.invoke((Object)configurationFactory, this.spaceId.getSpaceName(), this.confFile.toURI(), this.getClass().getClassLoader());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method getConfigurationMethod = configurationFactory.getClass().getMethod("getConfiguration", LoggerContext.class, String.class, URI.class, ClassLoader.class);
            config = (Configuration)getConfigurationMethod.invoke((Object)configurationFactory, context, this.spaceId.getSpaceName(), this.confFile.toURI(), this.getClass().getClassLoader());
        }
        if (config == null) {
            throw new RuntimeException("No log4j2 configuration are found.");
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            config.getProperties().put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            config.getProperties().put((String)entry.getKey(), (String)entry.getValue());
        }
        context.start(config);
        return context;
    }

    private void attachConsoleAppender() {
        String value = this.properties.getProperty(String.format("sofa.middleware.log.%s.console", this.spaceId.getSpaceName()));
        if (StringUtil.isEmpty(value)) {
            value = this.properties.getProperty("sofa.middleware.log.console");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            this.loggerContext.addFilter((Filter)new AbstractFilter(){

                private void process(org.apache.logging.log4j.core.Logger logger, Level level) {
                    if (CommonLoggingConfigurations.shouldAttachConsoleAppender(logger.getName()) && !logger.getAppenders().containsKey(Log4j2LoggerSpaceFactory.CONSOLE)) {
                        logger.addAppender((Appender)Log4j2LoggerSpaceFactory.this.consoleAppender);
                        int intLevel = Level.DEBUG.intLevel();
                        if (logger.getLevel() != null) {
                            intLevel = logger.getLevel().intLevel();
                        }
                        if (intLevel > Log4j2LoggerSpaceFactory.this.consoleLevel.intLevel()) {
                            logger.setLevel(level);
                        }
                    }
                }

                public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable t) {
                    this.process(logger, level);
                    return Filter.Result.NEUTRAL;
                }

                public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t) {
                    this.process(logger, level);
                    return Filter.Result.NEUTRAL;
                }

                public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
                    this.process(logger, level);
                    return Filter.Result.NEUTRAL;
                }
            });
        }
    }

    @Override
    public Logger setLevel(String loggerName, AdapterLevel adapterLevel) {
        String key = "ROOT".equals(loggerName) ? "" : loggerName;
        org.apache.logging.log4j.core.Logger log4j2Logger = this.loggerContext.getLogger(key);
        Level log4j2Level = this.toLog4j2Level(adapterLevel);
        log4j2Logger.setLevel(log4j2Level);
        return this.getLogger(loggerName);
    }

    @Deprecated
    public void reInitialize(Map<String, String> environment) {
    }

    public Logger getLogger(String name) {
        Logger logger = (Logger)this.loggerMap.get(name);
        if (logger != null) {
            return logger;
        }
        this.loggerMap.putIfAbsent(name, this.newLogger(name, this.loggerContext));
        return (Logger)this.loggerMap.get(name);
    }

    private ConsoleAppender createConsoleAppender() {
        String logPattern = this.properties.getProperty("sofa.middleware.log.console.log4j2.pattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} %5p %X{PID} --- [%15.15t] %-40.40logger{39} : %m%n");
        PatternLayout patternLayout = PatternLayout.newBuilder().withPattern(logPattern).build();
        ConsoleAppender.Builder builder = ConsoleAppender.newBuilder();
        builder.withLayout((Layout)patternLayout).withName(CONSOLE);
        ConsoleAppender appender = builder.build();
        appender.start();
        return appender;
    }

    private Level getConsoleLevel() {
        String defaultLevel = this.properties.getProperty("sofa.middleware.log.console.level", "INFO");
        String level = this.properties.getProperty(String.format("sofa.middleware.log.%s.console.level", this.spaceId), defaultLevel);
        return Level.toLevel((String)level);
    }

    private Logger newLogger(String name, LoggerContext loggerContext) {
        String key = "ROOT".equals(name) ? "" : name;
        return new Log4jLogger((ExtendedLogger)loggerContext.getLogger(key), name);
    }

    private Level toLog4j2Level(AdapterLevel adapterLevel) {
        if (adapterLevel == null) {
            throw new IllegalStateException("AdapterLevel is NULL when adapter to log4j2.");
        }
        switch (adapterLevel) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        throw new IllegalStateException((Object)((Object)adapterLevel) + " is unknown when adapter to log4j2.");
    }
}

