/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.config;

import com.alipay.sofa.common.config.ConfigKey;
import com.alipay.sofa.common.config.ConfigManager;
import com.alipay.sofa.common.config.ConfigSource;
import com.alipay.sofa.common.config.ManagementListener;
import com.alipay.sofa.common.utils.OrderComparator;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultConfigManager
implements ConfigManager {
    private final Object EMPTY = new Object();
    private final List<ConfigSource> configSources = new CopyOnWriteArrayList<ConfigSource>();
    private final List<ManagementListener> configListeners = new CopyOnWriteArrayList<ManagementListener>();
    private LoadingCache<ConfigKey, Object> cache;

    public DefaultConfigManager(long expireAfterSecond, long maximumSize) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(expireAfterSecond)).maximumSize(maximumSize).build((CacheLoader)new CacheLoader<ConfigKey, Object>(){

            public Object load(ConfigKey key) {
                Object config = DefaultConfigManager.this.getConfig(key, null);
                if (config == null) {
                    return DefaultConfigManager.this.EMPTY;
                }
                return config;
            }
        });
    }

    @Override
    public <T> T getOrDefault(ConfigKey<T> key) {
        return this.getConfig(key, key.getDefaultValue());
    }

    @Override
    public <T> T getOrCustomDefault(ConfigKey<T> key, T customDefault) {
        return this.getConfig(key, customDefault);
    }

    @Override
    public <T> T getOrDefaultWithCache(ConfigKey<T> key) {
        return this.getConfigWithCache(key, key.getDefaultValue());
    }

    @Override
    public <T> T getOrCustomDefaultWithCache(ConfigKey<T> key, T customDefault) {
        return this.getConfigWithCache(key, customDefault);
    }

    private <T> T getConfigWithCache(ConfigKey<T> key, T defaultValue) {
        Object result = null;
        try {
            result = this.cache.getUnchecked(key);
        }
        catch (ExecutionError error) {
            throw new IllegalStateException(error);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Unexpected type of exception when getConfigWithCache:" + cause, cause);
        }
        if (result == this.EMPTY) {
            return defaultValue;
        }
        return (T)result;
    }

    public <T> T getConfig(ConfigKey<T> key, T defaultValue) {
        T result = null;
        this.beforeConfigLoading(key);
        for (ConfigSource configSource : this.configSources) {
            result = configSource.getConfig(key);
            if (result == null) continue;
            this.onConfigLoaded(key, configSource);
            return result;
        }
        this.onLoadDefaultValue(key, defaultValue);
        return defaultValue;
    }

    private <T> void onLoadDefaultValue(ConfigKey<T> key, Object defaultValue) {
        for (ManagementListener configListener : this.configListeners) {
            configListener.onLoadDefaultValue(key, defaultValue);
        }
    }

    private <T> void beforeConfigLoading(ConfigKey<T> key) {
        for (ManagementListener configListener : this.configListeners) {
            configListener.beforeConfigLoading(key, this.configSources);
        }
    }

    private <T> void onConfigLoaded(ConfigKey<T> key, ConfigSource configSource) {
        for (ManagementListener configListener : this.configListeners) {
            configListener.afterConfigLoaded(key, configSource, this.configSources);
        }
    }

    @Override
    public void addConfigSource(ConfigSource configSource) {
        this.configSources.add(configSource);
        OrderComparator.sort(this.configSources);
    }

    @Override
    public void addConfigListener(ManagementListener configListener) {
        this.configListeners.add(configListener);
        OrderComparator.sort(this.configListeners);
    }

    List<ConfigSource> getConfigSources() {
        return this.configSources;
    }

    List<ManagementListener> getConfigListeners() {
        return this.configListeners;
    }
}

