/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.config.source;

import com.alipay.sofa.common.config.ConfigKey;
import com.alipay.sofa.common.config.ConfigSource;
import com.alipay.sofa.common.config.Converter;
import com.alipay.sofa.common.config.converter.GlobalConverterHolder;
import com.alipay.sofa.common.utils.StringUtil;

public abstract class AbstractConfigSource
implements ConfigSource {
    @Override
    public <T> T getConfig(ConfigKey<T> key) {
        String value = this.getStringConfig(key);
        return this.changeValueType(value, key.getType());
    }

    @Override
    public String getStringConfig(ConfigKey key) {
        String value = this.doGetConfig(key.getKey());
        if (StringUtil.isNotBlank(value)) {
            return value;
        }
        for (String alias : key.getAlias()) {
            value = this.doGetConfig(alias);
            if (!StringUtil.isNotBlank(value)) continue;
            return value;
        }
        return value;
    }

    @Override
    public String getEffectiveKey(ConfigKey configKey) {
        String[] alias;
        String key = configKey.getKey();
        if (this.hasKey(key)) {
            return key;
        }
        for (String alia : alias = configKey.getAlias()) {
            if (!this.hasKey(alia)) continue;
            return alia;
        }
        return "";
    }

    protected <T> T changeValueType(String value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType == null) {
            return (T)value;
        }
        Converter converter = GlobalConverterHolder.getGlobalConverter();
        if (converter == null) {
            converter = GlobalConverterHolder.DEFAULT_CONVERTER;
        }
        return converter.convert(value, targetType);
    }

    public abstract String doGetConfig(String var1);

    public abstract boolean hasKey(String var1);
}

