/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.boot.logging;

import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.log.MultiAppLoggerSpaceManager;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.SpaceInfo;
import com.alipay.sofa.common.log.env.LogEnvUtils;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.Log4j2LoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.LogbackLoggerSpaceFactory;
import com.alipay.sofa.common.utils.ReportUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class CommonLoggingApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        this.reInitializeLog(this.loadApplicationEnvironment(event.getEnvironment()));
    }

    private void reInitializeLog(Map<String, String> context) {
        for (Map.Entry entry : MultiAppLoggerSpaceManager.getSpacesMap().entrySet()) {
            SpaceId spaceId = (SpaceId)entry.getKey();
            SpaceInfo spaceInfo = (SpaceInfo)entry.getValue();
            ReportUtil.reportDebug((String)("Re-initialize log of " + spaceId.getSpaceName()));
            AbstractLoggerSpaceFactory abstractLoggerSpaceFactory = spaceInfo.getAbstractLoggerSpaceFactory();
            if (abstractLoggerSpaceFactory instanceof LogbackLoggerSpaceFactory) {
                ((LogbackLoggerSpaceFactory)abstractLoggerSpaceFactory).reInitialize(context);
            }
            if (!(abstractLoggerSpaceFactory instanceof Log4j2LoggerSpaceFactory)) continue;
            ((Log4j2LoggerSpaceFactory)abstractLoggerSpaceFactory).reInitialize(context);
        }
    }

    private Map<String, String> loadApplicationEnvironment(ConfigurableEnvironment environment) {
        HashMap<String, String> context = new HashMap<String, String>();
        this.readLogConfiguration("logging.path", environment.getProperty("logging.path"), context, Constants.LOGGING_PATH_DEFAULT);
        this.readLogConfiguration("loggingRoot", environment.getProperty("loggingRoot"), context, (String)context.get("logging.path"));
        this.readLogConfiguration("file.encoding", environment.getProperty("file.encoding"), context);
        LogEnvUtils.keepCompatible(context);
        HashSet<String> configKeys = new HashSet<String>();
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            configKeys.addAll(Arrays.asList(((EnumerablePropertySource)propertySource).getPropertyNames()));
        }
        for (String key : configKeys) {
            if (!key.startsWith("sofa.middleware.log.") && !key.startsWith("logging.level.") && !key.startsWith("logging.path.") && !key.startsWith("logging.config.")) continue;
            this.readLogConfiguration(key, environment.getProperty(key), context);
        }
        return context;
    }

    private void readLogConfiguration(String key, String value, Map<String, String> context) {
        if (!StringUtil.isBlank((String)value)) {
            context.put(key, value);
        }
    }

    private void readLogConfiguration(String key, String value, Map<String, String> context, String defaultValue) {
        if (!StringUtil.isBlank((String)value)) {
            context.put(key, value);
        } else {
            context.put(key, defaultValue);
        }
    }

    public int getOrder() {
        return -2147483628;
    }
}

