/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.CommandEncoder;
import com.alipay.remoting.Connection;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.RpcCommand;
import com.alipay.remoting.util.CrcUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCommandEncoderV2
implements CommandEncoder {
    private static final Logger logger = LoggerFactory.getLogger((String)"RpcRemoting");

    @Override
    public void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        try {
            if (msg instanceof RpcCommand) {
                int index = out.writerIndex();
                RpcCommand cmd = (RpcCommand)msg;
                out.writeByte(2);
                Attribute version = ctx.channel().attr(Connection.VERSION);
                int ver = 1;
                if (version != null && version.get() != null) {
                    ver = ((Byte)version.get()).byteValue();
                }
                out.writeByte(ver);
                out.writeByte((int)cmd.getType());
                out.writeShort((int)((RpcCommand)msg).getCmdCode().value());
                out.writeByte((int)cmd.getVersion());
                out.writeInt(cmd.getId());
                out.writeByte((int)cmd.getSerializer());
                out.writeByte((int)cmd.getProtocolSwitch().toByte());
                if (cmd instanceof RequestCommand) {
                    out.writeInt(((RequestCommand)cmd).getTimeout());
                }
                if (cmd instanceof ResponseCommand) {
                    ResponseCommand response = (ResponseCommand)cmd;
                    out.writeShort((int)response.getResponseStatus().getValue());
                }
                out.writeShort((int)cmd.getClazzLength());
                out.writeShort((int)cmd.getHeaderLength());
                out.writeInt(cmd.getContentLength());
                if (cmd.getClazzLength() > 0) {
                    out.writeBytes(cmd.getClazz());
                }
                if (cmd.getHeaderLength() > 0) {
                    out.writeBytes(cmd.getHeader());
                }
                if (cmd.getContentLength() > 0) {
                    out.writeBytes(cmd.getContent());
                }
                if (ver == 2 && cmd.getProtocolSwitch().isOn(0)) {
                    byte[] frame = new byte[out.readableBytes()];
                    out.getBytes(index, frame);
                    out.writeInt(CrcUtil.crc32(frame));
                }
            } else {
                String warnMsg = "msg type [" + msg.getClass() + "] is not subclass of RpcCommand";
                logger.warn(warnMsg);
            }
        }
        catch (Exception e) {
            logger.error("Exception caught!", (Throwable)e);
            throw e;
        }
    }
}

