/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.Scannable;
import com.alipay.remoting.log.BoltLoggerFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class RpcTaskScanner {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");
    private ScheduledExecutorService scheduledService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "RpcTaskScannerThread");
        }
    });
    private List<Scannable> scanlist = new LinkedList<Scannable>();

    public void start() {
        this.scheduledService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (Scannable scanned : RpcTaskScanner.this.scanlist) {
                    try {
                        scanned.scan();
                    }
                    catch (Throwable t) {
                        logger.error("Exception caught when scannings.", t);
                    }
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public void add(Scannable target) {
        this.scanlist.add(target);
    }

    public void shutdown() {
        this.scheduledService.shutdown();
    }
}

