/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.CommandCode;
import com.alipay.remoting.RemotingProcessor;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public abstract class RemotingServer {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    protected int port;
    private AtomicBoolean inited = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);

    public RemotingServer(int port) {
        this.port = port;
    }

    public void init() {
        if (this.inited.compareAndSet(false, true)) {
            logger.warn("Initialize the server.");
            this.doInit();
        } else {
            logger.warn("Server has been inited already.");
        }
    }

    public boolean start() {
        this.init();
        if (this.started.compareAndSet(false, true)) {
            try {
                logger.warn("Server started on port: " + this.port);
                return this.doStart();
            }
            catch (Throwable t) {
                this.started.set(false);
                this.stop();
                logger.error("ERROR: Failed to start the Server!", t);
                return false;
            }
        }
        String errMsg = "ERROR: The server has already started!";
        logger.error(errMsg);
        throw new IllegalStateException(errMsg);
    }

    public boolean start(String ip) {
        this.init();
        if (this.started.compareAndSet(false, true)) {
            try {
                logger.warn("Server started on " + ip + ":" + this.port);
                return this.doStart(ip);
            }
            catch (Throwable t) {
                this.started.set(false);
                this.stop();
                logger.error("ERROR: Failed to start the Server!", t);
                return false;
            }
        }
        String errMsg = "ERROR: The server has already started!";
        logger.error(errMsg);
        throw new IllegalStateException(errMsg);
    }

    public void stop() {
        if (!this.inited.get() && !this.started.get()) {
            throw new IllegalStateException("ERROR: The server has already stopped!");
        }
        this.inited.compareAndSet(true, false);
        this.started.compareAndSet(true, false);
        this.doStop();
    }

    public int getPort() {
        return this.port;
    }

    protected abstract void doInit();

    protected abstract boolean doStart() throws InterruptedException;

    protected abstract boolean doStart(String var1) throws InterruptedException;

    protected abstract void doStop();

    public abstract void registerProcessor(byte var1, CommandCode var2, RemotingProcessor<?> var3);

    public abstract void registerDefaultExecutor(byte var1, ExecutorService var2);

    public abstract void registerUserProcessor(UserProcessor<?> var1);
}

