/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util;

import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.internal.util.RequestParametersHolder;
import com.alipay.api.internal.util.StreamUtil;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlipaySignature {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static String getSignatureContent(RequestParametersHolder requestHolder) {
        return AlipaySignature.getSignContent(AlipaySignature.getSortedMap(requestHolder));
    }

    public static Map<String, String> getSortedMap(RequestParametersHolder requestHolder) {
        AlipayHashMap protocalOptParams;
        AlipayHashMap protocalMustParams;
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        AlipayHashMap appParams = requestHolder.getApplicationParams();
        if (appParams != null && appParams.size() > 0) {
            sortedParams.putAll(appParams);
        }
        if ((protocalMustParams = requestHolder.getProtocalMustParams()) != null && protocalMustParams.size() > 0) {
            sortedParams.putAll(protocalMustParams);
        }
        if ((protocalOptParams = requestHolder.getProtocalOptParams()) != null && protocalOptParams.size() > 0) {
            sortedParams.putAll(protocalOptParams);
        }
        return sortedParams;
    }

    public static String getSignContent(Map<String, String> sortedParams) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String value;
            String key = (String)keys.get(i);
            if (!StringUtils.areNotEmpty(key, value = sortedParams.get(key))) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    public static String extractSignContent(String str, int begin) {
        if (str == null) {
            return null;
        }
        int beginPosition = AlipaySignature.extractBeginPosition(str, begin);
        if (beginPosition >= str.length()) {
            return null;
        }
        return str.substring(beginPosition, AlipaySignature.extractEndPosition(str, beginPosition));
    }

    private static int extractBeginPosition(String responseString, int begin) {
        int beginPosition;
        for (beginPosition = begin; beginPosition < responseString.length() && responseString.charAt(beginPosition) != '{' && responseString.charAt(beginPosition) != '\"'; ++beginPosition) {
        }
        return beginPosition;
    }

    private static int extractEndPosition(String responseString, int beginPosition) {
        if (responseString.charAt(beginPosition) == '{') {
            return AlipaySignature.extractJsonObjectEndPosition(responseString, beginPosition);
        }
        return AlipaySignature.extractJsonBase64ValueEndPosition(responseString, beginPosition);
    }

    private static int extractJsonBase64ValueEndPosition(String responseString, int beginPosition) {
        for (int index = beginPosition; index < responseString.length(); ++index) {
            if (responseString.charAt(index) != '\"' || index == beginPosition) continue;
            return index + 1;
        }
        return responseString.length();
    }

    private static int extractJsonObjectEndPosition(String responseString, int beginPosition) {
        LinkedList<String> braces = new LinkedList<String>();
        boolean inQuotes = false;
        int consecutiveEscapeCount = 0;
        for (int index = beginPosition; index < responseString.length(); ++index) {
            char currentChar = responseString.charAt(index);
            if (currentChar == '\"' && consecutiveEscapeCount % 2 == 0) {
                inQuotes = !inQuotes;
            } else if (currentChar == '{' && !inQuotes) {
                braces.push("{");
            } else if (currentChar == '}' && !inQuotes) {
                braces.pop();
                if (braces.isEmpty()) {
                    return index + 1;
                }
            }
            if (currentChar == '\\') {
                ++consecutiveEscapeCount;
                continue;
            }
            consecutiveEscapeCount = 0;
        }
        return responseString.length();
    }

    public static String rsaSign(String content, String privateKey, String charset, String signType) throws AlipayApiException {
        if ("RSA".equals(signType)) {
            return AlipaySignature.rsaSign(content, privateKey, charset);
        }
        if ("RSA2".equals(signType)) {
            return AlipaySignature.rsa256Sign(content, privateKey, charset);
        }
        throw new AlipayApiException("Sign Type is Not Support : signType=" + signType);
    }

    public static String rsa256Sign(String content, String privateKey, String charset) throws AlipayApiException {
        try {
            PrivateKey priKey = AlipaySignature.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64(signed));
        }
        catch (Exception e) {
            throw new AlipayApiException("RSAcontent = " + content + "; charset = " + charset, e);
        }
    }

    public static String rsaSign(String content, String privateKey, String charset) throws AlipayApiException {
        try {
            PrivateKey priKey = AlipaySignature.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64(signed));
        }
        catch (InvalidKeySpecException ie) {
            throw new AlipayApiException("RSA\u02fd\u053f\ufffd\ufffd\u02bd\ufffd\ufffd\ufffd\ufffd\u0237\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\u0237\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdPKCS8\ufffd\ufffd\u02bd\ufffd\ufffd\u02fd\u053f", ie);
        }
        catch (Exception e) {
            throw new AlipayApiException("RSAcontent = " + content + "; charset = " + charset, e);
        }
    }

    public static String rsaSign(Map<String, String> params, String privateKey, String charset) throws AlipayApiException {
        String signContent = AlipaySignature.getSignContent(params);
        return AlipaySignature.rsaSign(signContent, privateKey, charset);
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty(algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtil.readText(ins).getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static String getSignCheckContentV1(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        params.remove("sign_type");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        return content.toString();
    }

    public static String getSignCheckContentV2(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        return content.toString();
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV1(params);
        return AlipaySignature.rsaCheckContent(content, sign, publicKey, charset);
    }

    public static boolean rsaCertCheckV1(Map<String, String> params, String alipayPublicCertPath, String charset) throws AlipayApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheckV1(params, publicKey, charset);
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset, String signType) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV1(params);
        return AlipaySignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    public static boolean rsaCertCheckV1(Map<String, String> params, String alipayPublicCertPath, String charset, String signType) throws AlipayApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheckV1(params, publicKey, charset, signType);
    }

    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV2(params);
        return AlipaySignature.rsaCheckContent(content, sign, publicKey, charset);
    }

    public static boolean rsaCertCheckV2(Map<String, String> params, String alipayPublicCertPath, String charset) throws AlipayApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheckV2(params, publicKey, charset);
    }

    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset, String signType) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV2(params);
        return AlipaySignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    public static boolean rsaCertCheckV2(Map<String, String> params, String alipayPublicCertPath, String charset, String signType) throws AlipayApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheckV2(params, publicKey, charset, signType);
    }

    public static boolean rsaCheck(String content, String sign, String publicKey, String charset, String signType) throws AlipayApiException {
        if ("RSA".equals(signType)) {
            return AlipaySignature.rsaCheckContent(content, sign, publicKey, charset);
        }
        if ("RSA2".equals(signType)) {
            return AlipaySignature.rsa256CheckContent(content, sign, publicKey, charset);
        }
        throw new AlipayApiException("Sign Type is Not Support : signType=" + signType);
    }

    public static boolean rsaCertCheck(String content, String sign, String alipayPublicCertPath, String charset, String signType) throws AlipayApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    public static boolean rsa256CheckContent(String content, String sign, String publicKey, String charset) throws AlipayApiException {
        try {
            PublicKey pubKey = AlipaySignature.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64(sign.getBytes()));
        }
        catch (Exception e) {
            throw new AlipayApiException("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, e);
        }
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws AlipayApiException {
        try {
            PublicKey pubKey = AlipaySignature.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64(sign.getBytes()));
        }
        catch (Exception e) {
            throw new AlipayApiException("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, e);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String alipayPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt) throws AlipayApiException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !AlipaySignature.rsaCheckV2(params, alipayPublicKey, charset)) {
            throw new AlipayApiException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return AlipaySignature.rsaDecrypt(bizContent, cusPrivateKey, charset);
        }
        return bizContent;
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String alipayPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt, String signType) throws AlipayApiException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !AlipaySignature.rsaCheckV2(params, alipayPublicKey, charset, signType)) {
            throw new AlipayApiException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return AlipaySignature.rsaDecrypt(bizContent, cusPrivateKey, charset);
        }
        return bizContent;
    }

    public static String encryptAndSign(String bizContent, String alipayPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign) throws AlipayApiException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(charset)) {
            charset = "GBK";
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
        if (isEncrypt) {
            sb.append("<alipay>");
            String encrypted = AlipaySignature.rsaEncrypt(bizContent, alipayPublicKey, charset);
            sb.append("<response>" + encrypted + "</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = AlipaySignature.rsaSign(encrypted, cusPrivateKey, charset);
                sb.append("<sign>" + sign + "</sign>");
                sb.append("<sign_type>RSA</sign_type>");
            }
            sb.append("</alipay>");
        } else if (isSign) {
            sb.append("<alipay>");
            sb.append("<response>" + bizContent + "</response>");
            String sign = AlipaySignature.rsaSign(bizContent, cusPrivateKey, charset);
            sb.append("<sign>" + sign + "</sign>");
            sb.append("<sign_type>RSA</sign_type>");
            sb.append("</alipay>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String encryptAndSign(String bizContent, String alipayPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign, String signType) throws AlipayApiException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(charset)) {
            charset = "GBK";
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
        if (isEncrypt) {
            sb.append("<alipay>");
            String encrypted = AlipaySignature.rsaEncrypt(bizContent, alipayPublicKey, charset);
            sb.append("<response>" + encrypted + "</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = AlipaySignature.rsaSign(encrypted, cusPrivateKey, charset, signType);
                sb.append("<sign>" + sign + "</sign>");
                sb.append("<sign_type>");
                sb.append(signType);
                sb.append("</sign_type>");
            }
            sb.append("</alipay>");
        } else if (isSign) {
            sb.append("<alipay>");
            sb.append("<response>" + bizContent + "</response>");
            String sign = AlipaySignature.rsaSign(bizContent, cusPrivateKey, charset, signType);
            sb.append("<sign>" + sign + "</sign>");
            sb.append("<sign_type>");
            sb.append(signType);
            sb.append("</sign_type>");
            sb.append("</alipay>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String rsaEncrypt(String content, String publicKey, String charset) throws AlipayApiException {
        try {
            PublicKey pubKey = AlipaySignature.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            byte[] data = StringUtils.isEmpty(charset) ? content.getBytes() : content.getBytes(charset);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = Base64.encodeBase64(out.toByteArray());
            out.close();
            return StringUtils.isEmpty(charset) ? new String(encryptedData) : new String(encryptedData, charset);
        }
        catch (Exception e) {
            throw new AlipayApiException("EncryptContent = " + content + ",charset = " + charset, e);
        }
    }

    public static String rsaDecrypt(String content, String privateKey, String charset) throws AlipayApiException {
        try {
            PrivateKey priKey = AlipaySignature.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, priKey);
            byte[] encryptedData = StringUtils.isEmpty(charset) ? Base64.decodeBase64(content.getBytes()) : Base64.decodeBase64(content.getBytes(charset));
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return StringUtils.isEmpty(charset) ? new String(decryptedData) : new String(decryptedData, charset);
        }
        catch (Exception e) {
            throw new AlipayApiException("EncodeContent = " + content + ",charset = " + charset, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCertSN(String certPath) throws AlipayApiException {
        String string;
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(certPath);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update((cert.getIssuerX500Principal().getName() + cert.getSerialNumber()).getBytes());
                String certSN = new BigInteger(1, md.digest()).toString(16);
                string = certSN = AlipaySignature.fillMD5(certSN);
                Object var8_10 = null;
            }
            catch (NoSuchAlgorithmException e) {
                throw new AlipayApiException(e);
            }
            catch (IOException e) {
                throw new AlipayApiException(e);
            }
            catch (CertificateException e) {
                throw new AlipayApiException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                if (inputStream == null) throw throwable;
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new AlipayApiException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        if (inputStream == null) return string;
        ((InputStream)inputStream).close();
        return string;
    }

    private static String fillMD5(String md5) {
        return md5.length() == 32 ? md5 : AlipaySignature.fillMD5("0" + md5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAlipayPublicKey(String alipayPublicCertPath) throws AlipayApiException {
        String string;
        FileInputStream inputStream = null;
        try {
            try {
                String apipayPublicKey;
                inputStream = new FileInputStream(alipayPublicCertPath);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
                PublicKey publicKey = cert.getPublicKey();
                Base64.Encoder encoder = java.util.Base64.getEncoder();
                string = apipayPublicKey = encoder.encodeToString(publicKey.getEncoded());
                Object var9_10 = null;
            }
            catch (IOException e) {
                throw new AlipayApiException(e);
            }
            catch (CertificateException e) {
                throw new AlipayApiException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (inputStream == null) throw throwable;
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new AlipayApiException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        if (inputStream == null) return string;
        ((InputStream)inputStream).close();
        return string;
    }
}

