/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util.asymmetric;

import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.asymmetric.IAsymmetricEncryptor;

public abstract class BaseAsymmetricEncryptor
implements IAsymmetricEncryptor {
    private static String DEFAULT_CHARSET = "UTF-8";

    public String decrypt(String cipherTextBase64, String charset, String privateKey) throws AlipayApiException {
        try {
            if (StringUtils.isEmpty(cipherTextBase64)) {
                throw new AlipayApiException("\u5bc6\u6587\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(privateKey)) {
                throw new AlipayApiException("\u79c1\u94a5\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(charset)) {
                charset = DEFAULT_CHARSET;
            }
            return this.doDecrypt(cipherTextBase64, charset, privateKey);
        }
        catch (Exception e) {
            String errorMessage = this.getAsymmetricType() + "\u975e\u5bf9\u79f0\u89e3\u5bc6\u906d\u9047\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u79c1\u94a5\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002" + e.getMessage() + " cipherTextBase64=" + cipherTextBase64 + "\uff0ccharset=" + charset + "\uff0cprivateKeySize=" + privateKey.length();
            throw new AlipayApiException(errorMessage, e);
        }
    }

    public String encrypt(String plainText, String charset, String publicKey) throws AlipayApiException {
        try {
            if (StringUtils.isEmpty(plainText)) {
                throw new AlipayApiException("\u5bc6\u6587\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(publicKey)) {
                throw new AlipayApiException("\u516c\u94a5\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(charset)) {
                charset = DEFAULT_CHARSET;
            }
            return this.doEncrypt(plainText, charset, publicKey);
        }
        catch (Exception e) {
            String errorMessage = this.getAsymmetricType() + "\u975e\u5bf9\u79f0\u89e3\u5bc6\u906d\u9047\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u516c\u94a5\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002" + e.getMessage() + " plainText=" + plainText + "\uff0ccharset=" + charset + "\uff0cpublicKey=" + publicKey;
            throw new AlipayApiException(errorMessage, e);
        }
    }

    public String sign(String content, String charset, String privateKey) throws AlipayApiException {
        try {
            if (StringUtils.isEmpty(content)) {
                throw new AlipayApiException("\u5f85\u7b7e\u540d\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(privateKey)) {
                throw new AlipayApiException("\u79c1\u94a5\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(charset)) {
                charset = DEFAULT_CHARSET;
            }
            return this.doSign(content, charset, privateKey);
        }
        catch (Exception e) {
            String errorMessage = this.getAsymmetricType() + "\u7b7e\u540d\u906d\u9047\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u79c1\u94a5\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002" + e.getMessage() + " content=" + content + "\uff0ccharset=" + charset + "\uff0cprivateKeySize=" + privateKey.length();
            throw new AlipayApiException(errorMessage, e);
        }
    }

    public boolean verify(String content, String charset, String publicKey, String sign) throws AlipayApiException {
        try {
            if (StringUtils.isEmpty(content)) {
                throw new AlipayApiException("\u5f85\u9a8c\u7b7e\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(publicKey)) {
                throw new AlipayApiException("\u516c\u94a5\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(sign)) {
                throw new AlipayApiException("\u7b7e\u540d\u4e32\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(charset)) {
                charset = DEFAULT_CHARSET;
            }
            return this.doVerify(content, charset, publicKey, sign);
        }
        catch (Exception e) {
            String errorMessage = this.getAsymmetricType() + "\u9a8c\u7b7e\u906d\u9047\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u516c\u94a5\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002" + e.getMessage() + " content=" + content + "\uff0ccharset=" + charset + "\uff0cpublicKey=" + publicKey;
            throw new AlipayApiException(errorMessage, e);
        }
    }

    protected abstract String doDecrypt(String var1, String var2, String var3) throws Exception;

    protected abstract String doEncrypt(String var1, String var2, String var3) throws Exception;

    protected abstract String doSign(String var1, String var2, String var3) throws Exception;

    protected abstract boolean doVerify(String var1, String var2, String var3, String var4) throws Exception;

    protected abstract String getAsymmetricType();
}

