package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 商户部门信息修改
 *
 * @author auto create
 * @since 1.0, 2018-03-23 13:52:04
 */
public class KoubeiMerchantDepartmentModifyModel extends AlipayObject {

	private static final long serialVersionUID = 7397117281274218184L;

	/**
	 * isv回传的auth_code，通过auth_code校验当前操作人与商户的关系
	 */
	@ApiField("auth_code")
	private String authCode;

	/**
	 * 商户部门id
	 */
	@ApiField("dept_id")
	private String deptId;

	/**
	 * 商户创建的部门名称，可以修改
	 */
	@ApiField("dept_name")
	private String deptName;

	/**
	 * 当前部门对应的上级部门id
	 */
	@ApiField("parent_dept_id")
	private String parentDeptId;

	public String getAuthCode() {
		return this.authCode;
	}
	public void setAuthCode(String authCode) {
		this.authCode = authCode;
	}

	public String getDeptId() {
		return this.deptId;
	}
	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}

	public String getDeptName() {
		return this.deptName;
	}
	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public String getParentDeptId() {
		return this.parentDeptId;
	}
	public void setParentDeptId(String parentDeptId) {
		this.parentDeptId = parentDeptId;
	}

}
