/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAmount;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.UnsupportedTemporalTypeException;

@NoMetadata
public final class Duration
implements TemporalAmount,
Comparable<Duration>,
Serializable {
    public static final Duration ZERO = new Duration(0L, 0);
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static BigInteger bigIntNanosPerSecond;
    private final long seconds;
    private final int nanos;

    private static BigInteger getBigIntNanosPerSecond() {
        if (bigIntNanosPerSecond == null) {
            bigIntNanosPerSecond = BigInteger.valueOf(1000000000L);
        }
        return bigIntNanosPerSecond;
    }

    public static Duration ofDays(long days) {
        return Duration.create(Jdk8Methods.safeMultiply(days, 86400), 0);
    }

    public static Duration ofHours(long hours) {
        return Duration.create(Jdk8Methods.safeMultiply(hours, 3600), 0);
    }

    public static Duration ofMinutes(long minutes) {
        return Duration.create(Jdk8Methods.safeMultiply(minutes, 60), 0);
    }

    public static Duration ofSeconds(long seconds) {
        return Duration.create(seconds, 0);
    }

    public static Duration ofSeconds(long seconds, long nanoAdjustment) {
        long secs = Jdk8Methods.safeAdd(seconds, Jdk8Methods.floorDiv(nanoAdjustment, 1000000000L));
        int nos = Jdk8Methods.floorMod(nanoAdjustment, 1000000000);
        return Duration.create(secs, nos);
    }

    public static Duration ofMillis(long millis) {
        long secs = millis / 1000L;
        int mos = (int)(millis % 1000L);
        if (mos < 0) {
            mos += 1000;
            --secs;
        }
        return Duration.create(secs, mos * 1000000);
    }

    public static Duration ofNanos(long nanos) {
        long secs = nanos / 1000000000L;
        int nos = (int)(nanos % 1000000000L);
        if (nos < 0) {
            nos += 1000000000;
            --secs;
        }
        return Duration.create(secs, nos);
    }

    public static Duration of(long amount, TemporalUnit unit) {
        Objects.requireNonNull(unit, "Duration.of null unit");
        return ZERO.plus(amount, unit);
    }

    public static Duration from(TemporalAmount amount) {
        Objects.requireNonNull(amount, "amount");
        Duration duration = ZERO;
        for (TemporalUnit unit : amount.getUnits()) {
            duration = duration.plus(amount.get(unit), unit);
        }
        return duration;
    }

    public static Duration between(Temporal startInclusive, Temporal endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        long secs = startInclusive.until(endExclusive, ChronoUnit.SECONDS);
        long nanos = 0L;
        if (startInclusive.isSupported(ChronoField.NANO_OF_SECOND) && endExclusive.isSupported(ChronoField.NANO_OF_SECOND)) {
            try {
                long startNos = startInclusive.getLong(ChronoField.NANO_OF_SECOND);
                nanos = endExclusive.getLong(ChronoField.NANO_OF_SECOND) - startNos;
                if (secs > 0L && nanos < 0L) {
                    nanos += 1000000000L;
                } else if (secs < 0L && nanos > 0L) {
                    nanos -= 1000000000L;
                } else if (secs == 0L && nanos != 0L) {
                    Temporal adjustedEnd = endExclusive.with(ChronoField.NANO_OF_SECOND, startNos);
                    secs = startInclusive.until(adjustedEnd, ChronoUnit.SECONDS);
                }
            }
            catch (ArithmeticException | DateTimeException runtimeException) {
                // empty catch block
            }
        }
        return Duration.ofSeconds(secs, nanos);
    }

    public static Duration parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        Parser parser = new Parser(text);
        if (!parser.parse() || !parser.hasOneField) {
            throw new DateTimeParseException("Text cannot be parsed to a Duration: " + text, text, parser.ptr);
        }
        return Duration.create(parser.negative, parser.days * 86400L, parser.hours * 3600L, parser.minutes * 60L, parser.seconds, (int)parser.nanos);
    }

    private static Duration create(boolean negate, long daysAsSecs, long hoursAsSecs, long minsAsSecs, long secs, int nanos) {
        long seconds = Jdk8Methods.safeAdd(daysAsSecs, Jdk8Methods.safeAdd(hoursAsSecs, Jdk8Methods.safeAdd(minsAsSecs, secs)));
        if (negate) {
            return Duration.ofSeconds(seconds, nanos).negated();
        }
        return Duration.ofSeconds(seconds, nanos);
    }

    private static Duration create(long seconds, int nanoAdjustment) {
        if ((seconds | (long)nanoAdjustment) == 0L) {
            return ZERO;
        }
        return new Duration(seconds, nanoAdjustment);
    }

    private Duration(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.unmodifiableList(Arrays.asList(ChronoUnit.SECONDS, ChronoUnit.NANOS));
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.SECONDS) {
            return this.seconds;
        }
        if (unit == ChronoUnit.NANOS) {
            return this.nanos;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    public boolean isZero() {
        return (this.seconds | (long)this.nanos) == 0L;
    }

    public boolean isNegative() {
        return this.seconds < 0L;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNano() {
        return this.nanos;
    }

    public Duration withSeconds(long seconds) {
        return Duration.create(seconds, this.nanos);
    }

    public Duration withNanos(int nanoOfSecond) {
        ChronoField.NANO_OF_SECOND.checkValidIntValue(nanoOfSecond);
        return Duration.create(this.seconds, nanoOfSecond);
    }

    public Duration plus(Duration duration) {
        if (duration == null) {
            throw new NullPointerException("Duration.plus null duration");
        }
        return this.plus(duration.getSeconds(), duration.getNano());
    }

    public Duration plus(long amountToAdd, TemporalUnit unit) {
        Objects.requireNonNull(unit, "unit");
        if (unit == ChronoUnit.DAYS) {
            return this.plus(Jdk8Methods.safeMultiply(amountToAdd, 86400), 0L);
        }
        if (unit.isDurationEstimated()) {
            throw new DateTimeException("Unit must not have an estimated duration");
        }
        if (amountToAdd == 0L) {
            return this;
        }
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case NANOS: {
                    return this.plusNanos(amountToAdd);
                }
                case MICROS: {
                    return this.plusSeconds(amountToAdd / 1000000000L * 1000L).plusNanos(amountToAdd % 1000000000L * 1000L);
                }
                case MILLIS: {
                    return this.plusMillis(amountToAdd);
                }
                case SECONDS: {
                    return this.plusSeconds(amountToAdd);
                }
            }
            return this.plusSeconds(Jdk8Methods.safeMultiply(unit.getDuration().seconds, amountToAdd));
        }
        Duration duration = unit.getDuration().multipliedBy(amountToAdd);
        return this.plusSeconds(duration.getSeconds()).plusNanos(duration.getNano());
    }

    public Duration plusDays(long daysToAdd) {
        return this.plus(Jdk8Methods.safeMultiply(daysToAdd, 86400), 0L);
    }

    public Duration plusHours(long hoursToAdd) {
        return this.plus(Jdk8Methods.safeMultiply(hoursToAdd, 3600), 0L);
    }

    public Duration plusMinutes(long minutesToAdd) {
        return this.plus(Jdk8Methods.safeMultiply(minutesToAdd, 60), 0L);
    }

    public Duration plusSeconds(long secondsToAdd) {
        return this.plus(secondsToAdd, 0L);
    }

    public Duration plusMillis(long millisToAdd) {
        return this.plus(millisToAdd / 1000L, millisToAdd % 1000L * 1000000L);
    }

    public Duration plusNanos(long nanosToAdd) {
        return this.plus(0L, nanosToAdd);
    }

    private Duration plus(long secondsToAdd, long nanosToAdd) {
        if ((secondsToAdd | nanosToAdd) == 0L) {
            return this;
        }
        long epochSec = Jdk8Methods.safeAdd(this.seconds, secondsToAdd);
        epochSec = Jdk8Methods.safeAdd(epochSec, nanosToAdd / 1000000000L);
        long nanoAdjustment = (long)this.nanos + (nanosToAdd %= 1000000000L);
        return Duration.ofSeconds(epochSec, nanoAdjustment);
    }

    public Duration minus(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        long secsToSubtract = duration.getSeconds();
        int nanosToSubtract = duration.getNano();
        if (secsToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, -nanosToSubtract).plus(1L, 0L);
        }
        return this.plus(-secsToSubtract, -nanosToSubtract);
    }

    public Duration minus(long amountToSubtract, TemporalUnit unit) {
        Objects.requireNonNull(unit, "unit");
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public Duration minusDays(long daysToSubtract) {
        return daysToSubtract == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-daysToSubtract);
    }

    public Duration minusHours(long hoursToSubtract) {
        return hoursToSubtract == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-hoursToSubtract);
    }

    public Duration minusMinutes(long minutesToSubtract) {
        return minutesToSubtract == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-minutesToSubtract);
    }

    public Duration minusSeconds(long secondsToSubtract) {
        return secondsToSubtract == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-secondsToSubtract);
    }

    public Duration minusMillis(long millisToSubtract) {
        return millisToSubtract == Long.MIN_VALUE ? this.plusMillis(Long.MAX_VALUE).plusMillis(1L) : this.plusMillis(-millisToSubtract);
    }

    public Duration minusNanos(long nanosToSubtract) {
        return nanosToSubtract == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-nanosToSubtract);
    }

    public Duration multipliedBy(long multiplicand) {
        if (multiplicand == 0L) {
            return ZERO;
        }
        if (multiplicand == 1L) {
            return this;
        }
        return Duration.create(this.toSeconds().multiply(BigDecimal.valueOf(multiplicand)));
    }

    public Duration dividedBy(long divisor) {
        if (divisor == 0L) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (divisor == 1L) {
            return this;
        }
        return Duration.create(this.toSeconds().divide(BigDecimal.valueOf(divisor), RoundingMode.DOWN));
    }

    private BigDecimal toSeconds() {
        return BigDecimal.valueOf(this.seconds).add(BigDecimal.valueOf(this.nanos, 9));
    }

    private static Duration create(BigDecimal seconds) {
        Objects.requireNonNull(seconds, "seconds");
        BigInteger nanos = seconds.movePointRight(9).toBigIntegerExact();
        BigInteger[] divRem = nanos.divideAndRemainder(Duration.getBigIntNanosPerSecond());
        if (divRem[0].bitLength() > 64) {
            throw new ArithmeticException("Exceeds capacity of Duration: " + nanos);
        }
        return Duration.ofSeconds(divRem[0].longValue(), divRem[1].intValue());
    }

    public Duration negated() {
        return this.multipliedBy(-1L);
    }

    public Duration abs() {
        return this.isNegative() ? this.negated() : this;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        if (this.seconds != 0L) {
            temporal = temporal.plus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanos != 0) {
            temporal = temporal.plus(this.nanos, ChronoUnit.NANOS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        if (this.seconds != 0L) {
            temporal = temporal.minus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanos != 0) {
            temporal = temporal.minus(this.nanos, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public long toDays() {
        return this.seconds / 86400L;
    }

    public long toHours() {
        return this.seconds / 3600L;
    }

    public long toMinutes() {
        return this.seconds / 60L;
    }

    public long toMillis() {
        long result = Jdk8Methods.safeMultiply(this.seconds, 1000);
        result = Jdk8Methods.safeAdd(result, (long)(this.nanos / 1000000));
        return result;
    }

    public long toNanos() {
        long result = Jdk8Methods.safeMultiply(this.seconds, 1000000000);
        result = Jdk8Methods.safeAdd(result, (long)this.nanos);
        return result;
    }

    @Override
    public int compareTo(Duration otherDuration) {
        Objects.requireNonNull(otherDuration, "otherDuration");
        int cmp = Long.compare(this.seconds, otherDuration.seconds);
        if (cmp != 0) {
            return cmp;
        }
        return this.nanos - otherDuration.nanos;
    }

    public boolean equals(Object otherDuration) {
        if (this == otherDuration) {
            return true;
        }
        if (otherDuration instanceof Duration) {
            Duration other = (Duration)otherDuration;
            return this.seconds == other.seconds && this.nanos == other.nanos;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32) + 51 * this.nanos;
    }

    public String toString() {
        if (this == ZERO) {
            return "PT0S";
        }
        long hours = this.seconds / 3600L;
        int minutes = (int)(this.seconds % 3600L / 60L);
        int secs = (int)(this.seconds % 60L);
        StringBuilder buf = new StringBuilder(24);
        buf.append("PT");
        if (hours != 0L) {
            buf.append(hours).append('H');
        }
        if (minutes != 0) {
            buf.append(minutes).append('M');
        }
        if (secs == 0 && this.nanos == 0 && buf.length() > 2) {
            return buf.toString();
        }
        if (secs < 0 && this.nanos > 0) {
            if (secs == -1) {
                buf.append("-0");
            } else {
                buf.append(secs + 1);
            }
        } else {
            buf.append(secs);
        }
        if (this.nanos > 0) {
            int pos = buf.length();
            if (secs < 0) {
                buf.append(2000000000 - this.nanos);
            } else {
                buf.append(this.nanos + 1000000000);
            }
            while (buf.charAt(buf.length() - 1) == '0') {
                buf.setLength(buf.length() - 1);
            }
            buf.setCharAt(pos, '.');
        }
        buf.append('S');
        return buf.toString();
    }

    public static void main(String[] args) {
        String text = "P12DT-0.35S";
        Duration d = Duration.parse(text);
        System.out.println(d.seconds + " + " + d.nanos + ", negative: " + d.isNegative());
        java.time.Duration d2 = java.time.Duration.parse(text);
        System.out.println(d2.getSeconds() + " + " + d2.getNano() + ", negative: " + d2.isNegative());
    }

    static class Parser {
        private int ptr;
        private CharSequence text;
        private long days;
        private long hours;
        private long minutes;
        private long seconds;
        private long nanos;
        private boolean negative;
        private boolean hasOneField;
        private long parsedNumber;
        private int parsedNumberDigits;

        Parser(CharSequence text) {
            this.text = text.toString().toUpperCase();
        }

        boolean parse() {
            this.negative = this.sign();
            if (this.eof() || this.text.charAt(this.ptr) != 'P') {
                return false;
            }
            ++this.ptr;
            if (this.eof()) {
                return false;
            }
            boolean hasBeforePart = false;
            if (this.text.charAt(this.ptr) != 'T') {
                if (!this.tryParseDays()) {
                    return false;
                }
                if (this.eof()) {
                    return true;
                }
                hasBeforePart = true;
                if (this.text.charAt(this.ptr) != 'T') {
                    return false;
                }
                ++this.ptr;
                this.hasOneField = false;
            } else {
                ++this.ptr;
            }
            int state = 0;
            block5: while (true) {
                boolean negativeInCurrentPart = this.sign();
                if (!hasBeforePart && !this.negative && negativeInCurrentPart) {
                    this.negative = true;
                }
                hasBeforePart = true;
                if (!this.number()) break;
                if (this.eof()) {
                    return false;
                }
                this.hasOneField = true;
                char c = this.text.charAt(this.ptr);
                switch (state) {
                    case 0: {
                        if (c == 'H') {
                            ++this.ptr;
                            this.hours = this.parsedNumber;
                            state = 1;
                            break;
                        }
                    }
                    case 1: {
                        if (c == 'M') {
                            ++this.ptr;
                            this.minutes = this.parsedNumber;
                            state = 2;
                            break;
                        }
                    }
                    case 2: {
                        if (c == 'S') {
                            ++this.ptr;
                            this.seconds = this.parsedNumber;
                            break block5;
                        }
                        if (c == '.' || c == ',') {
                            ++this.ptr;
                            this.seconds = this.parsedNumber;
                            if (!this.number()) {
                                return false;
                            }
                            this.nanos = this.parsedNumber;
                            if (this.parsedNumberDigits > 9) {
                                this.parsedNumberDigits = 9;
                            }
                            int fraction = 1;
                            for (int i = 0; i < 9 - this.parsedNumberDigits; ++i) {
                                fraction *= 10;
                            }
                            this.nanos *= (long)fraction;
                            if (!this.negative && negativeInCurrentPart && this.nanos > 0L) {
                                this.seconds = -this.seconds - 1L;
                                this.nanos = 1000000000L - this.nanos;
                            }
                            if (this.eof() || this.text.charAt(this.ptr) != 'S') {
                                return false;
                            }
                            ++this.ptr;
                            break block5;
                        }
                    }
                    default: {
                        return false;
                    }
                }
            }
            return this.eof() && this.hasOneField;
        }

        private boolean tryParseDays() {
            if (!this.number()) {
                return false;
            }
            this.days = this.parsedNumber;
            this.hasOneField = true;
            if (this.ptr >= this.text.length() || this.text.charAt(this.ptr) != 'D') {
                return false;
            }
            ++this.ptr;
            return true;
        }

        boolean eof() {
            return this.ptr >= this.text.length();
        }

        boolean sign() {
            if (!this.eof()) {
                if (this.text.charAt(this.ptr) == '-') {
                    ++this.ptr;
                    return true;
                }
                if (this.text.charAt(this.ptr) == '+') {
                    ++this.ptr;
                }
            }
            return false;
        }

        boolean number() {
            char c;
            boolean negative = this.sign();
            this.parsedNumber = 0L;
            int oldPtr = this.ptr;
            boolean hasDigits = false;
            while (this.ptr < this.text.length() && (c = this.text.charAt(this.ptr)) >= '0' && c <= '9') {
                ++this.ptr;
                hasDigits = true;
                this.parsedNumber = this.parsedNumber * 10L + (long)c - 48L;
            }
            if (negative) {
                this.parsedNumber = -this.parsedNumber;
            }
            this.parsedNumberDigits = this.ptr - oldPtr;
            return hasDigits;
        }
    }
}

