/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONAware;
import com.antgroup.antchain.myjson.JSONStreamAware;
import com.antgroup.antchain.myjson.PropertyNamingStrategy;
import com.antgroup.antchain.myjson.serializer.ArraySerializer;
import com.antgroup.antchain.myjson.serializer.BigDecimalCodec;
import com.antgroup.antchain.myjson.serializer.BigIntegerCodec;
import com.antgroup.antchain.myjson.serializer.BooleanCodec;
import com.antgroup.antchain.myjson.serializer.CharacterCodec;
import com.antgroup.antchain.myjson.serializer.CollectionCodec;
import com.antgroup.antchain.myjson.serializer.DoubleSerializer;
import com.antgroup.antchain.myjson.serializer.FloatCodec;
import com.antgroup.antchain.myjson.serializer.IntegerCodec;
import com.antgroup.antchain.myjson.serializer.JSONAwareSerializer;
import com.antgroup.antchain.myjson.serializer.JavaBeanSerializer;
import com.antgroup.antchain.myjson.serializer.ListSerializer;
import com.antgroup.antchain.myjson.serializer.LongCodec;
import com.antgroup.antchain.myjson.serializer.MapSerializer;
import com.antgroup.antchain.myjson.serializer.MiscCodec;
import com.antgroup.antchain.myjson.serializer.ObjectArrayCodec;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.PrimitiveArraySerializer;
import com.antgroup.antchain.myjson.serializer.SerializeBeanInfo;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import com.antgroup.antchain.myjson.serializer.StringCodec;
import com.antgroup.antchain.myjson.util.TypeUtils;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@NoMetadata
public class SerializeConfig {
    public static final SerializeConfig globalInstance = new SerializeConfig();
    public PropertyNamingStrategy propertyNamingStrategy;
    private final Map<String, ObjectSerializer> serializers;
    private static final int DEFAULT_TABLE_SIZE = 8192;

    public final ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        SerializeBeanInfo beanInfo = TypeUtils.buildBeanInfo(clazz, null, this.propertyNamingStrategy);
        if (beanInfo.fields.length == 0 && Iterable.class.isAssignableFrom(clazz)) {
            return MiscCodec.instance;
        }
        return this.createJavaBeanSerializer(beanInfo);
    }

    public ObjectSerializer createJavaBeanSerializer(SerializeBeanInfo beanInfo) {
        if (!Modifier.isPublic(beanInfo.beanType.getModifiers())) {
            return new JavaBeanSerializer(beanInfo);
        }
        return new JavaBeanSerializer(beanInfo);
    }

    public static SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(8192);
    }

    public SerializeConfig(int tableSize) {
        this.serializers = new HashMap<String, ObjectSerializer>(tableSize);
        this.initSerializers();
    }

    private void initSerializers() {
        this.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.put((Type)((Object)Character.class), CharacterCodec.instance);
        this.put((Type)((Object)Byte.class), IntegerCodec.instance);
        this.put((Type)((Object)Short.class), IntegerCodec.instance);
        this.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.put((Type)((Object)Long.class), LongCodec.instance);
        this.put((Type)((Object)Float.class), FloatCodec.instance);
        this.put((Type)((Object)Double.class), DoubleSerializer.instance);
        this.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.put((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        this.put((Type)((Object)String.class), StringCodec.instance);
        this.put((Type)((Object)byte[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)short[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)int[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)long[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)float[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)double[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)boolean[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)char[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)Object[].class), ObjectArrayCodec.instance);
        this.put((Type)((Object)Class.class), MiscCodec.instance);
        this.putByString("java.util.LinkedList", CollectionCodec.instance);
    }

    public void config(Class<?> clazz, SerializerFeature feature, boolean value) {
        ObjectSerializer serializer = this.getObjectWriter(clazz, false);
        if (serializer == null) {
            SerializeBeanInfo beanInfo = TypeUtils.buildBeanInfo(clazz, null, this.propertyNamingStrategy);
            beanInfo.features = value ? (beanInfo.features |= feature.mask) : (beanInfo.features &= ~feature.mask);
            serializer = this.createJavaBeanSerializer(beanInfo);
            this.put(clazz, serializer);
            return;
        }
        if (serializer instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)serializer;
            SerializeBeanInfo beanInfo = javaBeanSerializer.beanInfo;
            int originalFeaturs = beanInfo.features;
            beanInfo.features = value ? (beanInfo.features |= feature.mask) : (beanInfo.features &= ~feature.mask);
            if (originalFeaturs == beanInfo.features) {
                return;
            }
            Class<?> serializerClass = serializer.getClass();
            if (serializerClass != JavaBeanSerializer.class) {
                ObjectSerializer newSerializer = this.createJavaBeanSerializer(beanInfo);
                this.put(clazz, newSerializer);
            }
        }
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.getObjectWriter(clazz, true);
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz, boolean create) {
        ObjectSerializer writer = this.get(clazz);
        if (writer != null) {
            return writer;
        }
        if (writer == null) {
            if (Map.class.isAssignableFrom(clazz)) {
                writer = MapSerializer.instance;
                this.put(clazz, writer);
            } else if (List.class.isAssignableFrom(clazz)) {
                writer = ListSerializer.instance;
                this.put(clazz, writer);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                writer = CollectionCodec.instance;
                this.put(clazz, writer);
            } else if (JSONAware.class.isAssignableFrom(clazz)) {
                writer = JSONAwareSerializer.instance;
                this.put(clazz, writer);
            } else if (JSONStreamAware.class.isAssignableFrom(clazz)) {
                writer = MiscCodec.instance;
                this.put(clazz, writer);
            } else if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                ObjectSerializer compObjectSerializer = this.getObjectWriter(componentType);
                writer = new ArraySerializer(componentType, compObjectSerializer);
                this.put(clazz, writer);
            } else if (create) {
                writer = this.createJavaBeanSerializer(clazz);
                this.put(clazz, writer);
            }
            if (writer == null) {
                writer = this.get(clazz);
            }
        }
        return writer;
    }

    public final ObjectSerializer get(Type type) {
        return this.serializers.get(type.getTypeName());
    }

    public boolean put(Type type, ObjectSerializer value) {
        this.putByString(type.getTypeName(), value);
        return true;
    }

    public void putByString(String typeName, ObjectSerializer value) {
        this.serializers.put(typeName, value);
    }
}

