/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSON;
import com.antgroup.antchain.myjson.JSONObject;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerialContext;
import com.antgroup.antchain.myjson.serializer.SerializeFilterable;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@NoMetadata
public class MapSerializer
extends SerializeFilterable
implements ObjectSerializer {
    public static MapSerializer instance = new MapSerializer();
    private static final int NON_STRINGKEY_AS_STRING = SerializerFeature.of(new SerializerFeature[]{SerializerFeature.BrowserCompatible, SerializerFeature.WriteNonStringKeyAsString});

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        this.write(serializer, object, fieldName, fieldType, features, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features, boolean unwrapped) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        Map<String, Object> map = (Map<String, Object>)object;
        int mapSortFieldMask = SerializerFeature.MapSortField.mask;
        if ((out.features & mapSortFieldMask) != 0 || (features & mapSortFieldMask) != 0) {
            if (map instanceof JSONObject) {
                map = ((JSONObject)map).getInnerMap();
            }
            try {
                map = new HashMap<String, Object>(map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (serializer.containsReference(object)) {
            serializer.writeReference(object);
            return;
        }
        SerialContext parent = serializer.context;
        serializer.setContext(parent, object, fieldName, 0);
        try {
            if (!unwrapped) {
                out.write(123);
            }
            serializer.incrementIndent();
            Class<?> preClazz = null;
            ObjectSerializer preWriter = null;
            boolean first = true;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                String entryKey = entry.getKey();
                if (entryKey == null || entryKey instanceof String) {
                    value = this.processValue(serializer, null, object, entryKey, value, features);
                } else {
                    boolean objectOrArray;
                    boolean bl = objectOrArray = entryKey instanceof Map || entryKey instanceof Collection;
                    if (!objectOrArray) {
                        String strKey = JSON.toJSONString(entryKey);
                        value = this.processValue(serializer, null, object, strKey, value, features);
                    }
                }
                if (value == null) continue;
                if (entryKey instanceof String) {
                    String key = entryKey;
                    if (!first) {
                        out.write(44);
                    }
                    out.writeFieldName(key, true);
                } else {
                    if (!first) {
                        out.write(44);
                    }
                    if ((out.isEnabled(NON_STRINGKEY_AS_STRING) || SerializerFeature.isEnabled(features, SerializerFeature.WriteNonStringKeyAsString)) && !(entryKey instanceof Enum)) {
                        String strEntryKey = JSON.toJSONString(entryKey);
                        serializer.write(strEntryKey);
                    } else {
                        serializer.write((Object)entryKey);
                    }
                    out.write(58);
                }
                first = false;
                if (value == null) {
                    out.writeNull();
                    continue;
                }
                Class<?> clazz = value.getClass();
                if (clazz != preClazz) {
                    preClazz = clazz;
                    preWriter = serializer.getObjectWriter(clazz);
                }
                preWriter.write(serializer, value, entryKey, null, features);
            }
        }
        finally {
            serializer.context = parent;
        }
        serializer.decrementIdent();
        if (!unwrapped) {
            out.write(125);
        }
    }
}

