/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.JSONObject;
import com.antgroup.antchain.myjson.parser.DefaultJSONParser;
import com.antgroup.antchain.myjson.parser.JSONScanner;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import com.antgroup.antchain.myjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

@NoMetadata
public class IntegerCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static IntegerCodec instance = new IntegerCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        Number value = (Number)object;
        if (value == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        if (object instanceof Long) {
            out.writeLong(value.longValue());
        } else {
            out.writeInt(value.intValue());
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Integer intObj;
        JSONScanner lexer = parser.lexer;
        int token = lexer.token();
        if (token == 8) {
            lexer.nextToken(16);
            return null;
        }
        try {
            if (token == 2) {
                int val = lexer.intValue();
                lexer.nextToken(16);
                intObj = val;
            } else if (token == 3) {
                BigDecimal number = lexer.decimalValue();
                intObj = TypeUtils.intValue(number);
                lexer.nextToken(16);
            } else if (token == 12) {
                JSONObject jsonObject = new JSONObject();
                parser.parseObject(jsonObject);
                intObj = TypeUtils.castToInt(jsonObject);
            } else {
                Object value = parser.parse();
                intObj = TypeUtils.castToInt(value);
            }
        }
        catch (Exception ex) {
            String message = "parseInt error";
            if (fieldName != null) {
                message = message + ", field : " + fieldName;
            }
            throw new JSONException(message, ex);
        }
        return (T)intObj;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

