/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.parser.DefaultJSONParser;
import com.antgroup.antchain.myjson.parser.JSONScanner;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import com.antgroup.antchain.myjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

@NoMetadata
public class BigDecimalCodec
implements ObjectSerializer,
ObjectDeserializer {
    static final long LOW = -9007199254740991L;
    static final long HIGH = 0x1FFFFFFFFFFFFFL;
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            BigDecimal val = (BigDecimal)object;
            int scale = val.scale();
            String outText = SerializerFeature.isEnabled(features, out.features, SerializerFeature.WriteBigDecimalAsPlain) && scale >= -100 && scale < 100 ? val.toPlainString() : val.toString();
            if (scale == 0 && outText.length() >= 16 && SerializerFeature.isEnabled(features, out.features, SerializerFeature.BrowserCompatible) && (val.longValue() < -9007199254740991L || val.longValue() > 0x1FFFFFFFFFFFFFL)) {
                out.writeString(outText);
                return;
            }
            out.write(outText);
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        try {
            return BigDecimalCodec.deserialze(parser);
        }
        catch (Exception ex) {
            throw new JSONException("parseDecimal error, field : " + fieldName, ex);
        }
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONScanner lexer = parser.lexer;
        if (lexer.token() == 2) {
            BigDecimal decimalValue = lexer.decimalValue();
            lexer.nextToken(16);
            return (T)decimalValue;
        }
        if (lexer.token() == 3) {
            BigDecimal val = lexer.decimalValue();
            lexer.nextToken(16);
            return (T)val;
        }
        Object value = parser.parse();
        return (T)(value == null ? null : TypeUtils.castToBigDecimal(value));
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

