/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.wasc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;

public final class WasmMemorySegmentSplitter {
    public static WasmMemoryPart[] splitWasmMemoryToParts(byte[] memoryBytes) {
        int zerosCount;
        int sepZerosCount = 16;
        ArrayList<WasmMemoryPart> parts = new ArrayList<WasmMemoryPart>();
        int currentPosition = 0;
        Function<Integer, Boolean> isSepPosition = pos -> {
            if (memoryBytes.length - pos < sepZerosCount) {
                return false;
            }
            for (int i = pos.intValue(); i < pos + sepZerosCount; ++i) {
                if (memoryBytes[i] == 0) continue;
                return false;
            }
            return true;
        };
        Function<Integer, Integer> findNextSepPosition = pos -> {
            for (int i = pos.intValue(); i < memoryBytes.length; ++i) {
                if (!((Boolean)isSepPosition.apply(i)).booleanValue()) continue;
                return i;
            }
            return -1;
        };
        Function<Integer, Integer> countZerosCountByOffset = pos -> {
            for (int i = pos.intValue(); i < memoryBytes.length; ++i) {
                if (memoryBytes[i] == 0) continue;
                return i - pos;
            }
            return memoryBytes.length - pos;
        };
        while (currentPosition < memoryBytes.length) {
            zerosCount = countZerosCountByOffset.apply(currentPosition);
            if (zerosCount > 0) {
                currentPosition += zerosCount;
                continue;
            }
            int nextSepOffset = findNextSepPosition.apply(currentPosition);
            if (nextSepOffset < 0) break;
            WasmMemoryPart part = new WasmMemoryPart(memoryBytes, currentPosition, nextSepOffset - currentPosition);
            parts.add(part);
            currentPosition = nextSepOffset;
        }
        if (currentPosition < memoryBytes.length && (zerosCount = countZerosCountByOffset.apply(currentPosition).intValue()) > 0) {
            currentPosition += zerosCount;
        }
        if (currentPosition < memoryBytes.length) {
            WasmMemoryPart part = new WasmMemoryPart(memoryBytes, currentPosition, memoryBytes.length - currentPosition);
            parts.add(part);
        }
        return parts.toArray(new WasmMemoryPart[0]);
    }

    private static byte[] mergeParts(WasmMemoryPart[] parts, int maxLength) {
        byte[] target = new byte[maxLength];
        for (WasmMemoryPart part : parts) {
            if (part.offset + part.length > maxLength) {
                return null;
            }
            System.arraycopy(part.origin, part.offset, target, part.offset, part.length);
        }
        return target;
    }

    public static boolean validateWasmMemoryParts(WasmMemoryPart[] parts, byte[] originMemoryBytes) {
        byte[] merged = WasmMemorySegmentSplitter.mergeParts(parts, originMemoryBytes.length);
        if (merged == null) {
            return false;
        }
        return Arrays.equals(merged, originMemoryBytes);
    }

    public static class WasmMemoryPart {
        private byte[] origin;
        private int offset;
        private int length;

        public WasmMemoryPart(byte[] origin, int offset, int length) {
            this.origin = origin;
            this.offset = offset;
            this.length = length;
        }

        public byte[] getData() {
            return Arrays.copyOfRange(this.origin, this.offset, this.offset + this.length);
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

