/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.vm;

import com.antgroup.antchain.myjava.interop.PlatformMarker;
import com.antgroup.antchain.myjava.vm.MyJavaBootstrapPluginLoader;
import com.antgroup.antchain.myjava.vm.MyJavaPluginReader;
import com.antgroup.antchain.myjava.vm.spi.MyJavaPlugin;
import java.util.ArrayList;
import java.util.List;

public final class MyJavaPluginLoader {
    private MyJavaPluginLoader() {
    }

    public static List<MyJavaPlugin> load(ClassLoader classLoader) {
        if (MyJavaPluginLoader.isBootstrap()) {
            return MyJavaBootstrapPluginLoader.loadPlugins(false);
        }
        ArrayList<MyJavaPlugin> plugins = new ArrayList<MyJavaPlugin>();
        MyJavaPluginReader.load(classLoader, className -> plugins.add(MyJavaPluginLoader.instantiate(classLoader, className)));
        return plugins;
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }

    private static MyJavaPlugin instantiate(ClassLoader classLoader, String className) {
        try {
            return (MyJavaPlugin)Class.forName(className, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Can't instantiate plugin " + className, e);
        }
    }
}

