/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.tooling.builder;

import com.antgroup.antchain.myjava.callgraph.CallGraph;
import com.antgroup.antchain.myjava.diagnostics.ProblemProvider;
import com.antgroup.antchain.myjava.tooling.InstructionLocationReader;
import com.antgroup.antchain.myjava.tooling.builder.BuildResult;
import com.antgroup.antchain.myjava.vm.MyJavaVM;
import java.util.Collection;
import java.util.List;

public class SimpleBuildResult
implements BuildResult {
    private MyJavaVM vm;
    private List<String> generatedFiles;
    private Collection<String> usedResources;

    public SimpleBuildResult(MyJavaVM vm, List<String> generatedFiles) {
        this.vm = vm;
        this.generatedFiles = generatedFiles;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.vm.getDependencyInfo().getCallGraph();
    }

    @Override
    public ProblemProvider getProblems() {
        return this.vm.getProblemProvider();
    }

    @Override
    public Collection<String> getUsedResources() {
        if (this.usedResources == null) {
            this.usedResources = InstructionLocationReader.extractUsedResources(this.vm);
        }
        return this.usedResources;
    }

    @Override
    public Collection<String> getClasses() {
        return this.vm.getClasses();
    }

    @Override
    public Collection<String> getGeneratedFiles() {
        return this.generatedFiles;
    }
}

