/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.tooling;

import com.antgroup.antchain.myjava.callgraph.CallGraph;
import com.antgroup.antchain.myjava.callgraph.CallGraphNode;
import com.antgroup.antchain.myjava.callgraph.CallSite;
import com.antgroup.antchain.myjava.diagnostics.DefaultProblemTextConsumer;
import com.antgroup.antchain.myjava.diagnostics.Problem;
import com.antgroup.antchain.myjava.diagnostics.ProblemProvider;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.tooling.MyJavaToolLog;
import com.antgroup.antchain.myjava.vm.MyJavaVM;
import java.util.Collection;
import java.util.Iterator;

public final class MyJavaProblemRenderer {
    private MyJavaProblemRenderer() {
    }

    public static void describeProblems(MyJavaVM vm, MyJavaToolLog log) {
        MyJavaProblemRenderer.describeProblems(vm.getDependencyInfo().getCallGraph(), vm.getProblemProvider(), log);
    }

    public static void describeProblems(CallGraph cg, ProblemProvider problems, MyJavaToolLog log) {
        DefaultProblemTextConsumer consumer = new DefaultProblemTextConsumer();
        for (Problem problem : problems.getProblems()) {
            consumer.clear();
            problem.render(consumer);
            StringBuilder sb = new StringBuilder();
            sb.append(consumer.getText());
            MyJavaProblemRenderer.renderCallStack(cg, problem.getLocation(), sb);
            String problemText = sb.toString();
            switch (problem.getSeverity()) {
                case ERROR: {
                    log.error(problemText);
                    break;
                }
                case WARNING: {
                    log.warning(problemText);
                }
            }
        }
    }

    public static void renderCallStack(CallGraph cg, CallLocation location, StringBuilder sb) {
        if (location == null) {
            return;
        }
        sb.append("\n    at ");
        MyJavaProblemRenderer.renderCallLocation(location.getMethod(), location.getSourceLocation(), sb);
        if (location.getMethod() != null) {
            Iterator<? extends CallSite> callSites;
            CallGraphNode node = cg.getNode(location.getMethod());
            for (int i = 0; i < 100 && (callSites = node.getCallerCallSites().iterator()).hasNext(); ++i) {
                CallSite callSite = callSites.next();
                sb.append("\n    at ");
                CallGraphNode caller = MyJavaProblemRenderer.getCaller(callSite);
                MyJavaProblemRenderer.renderCallLocation(caller.getMethod(), MyJavaProblemRenderer.getLocation(callSite, caller), sb);
                node = caller;
            }
        }
    }

    private static CallGraphNode getCaller(CallSite callSite) {
        Collection<? extends CallGraphNode> callers = callSite.getCallers();
        if (callers.isEmpty()) {
            return null;
        }
        return callers.iterator().next();
    }

    private static TextLocation getLocation(CallSite callSite, CallGraphNode caller) {
        if (caller == null) {
            return null;
        }
        Collection<? extends TextLocation> locations = callSite.getLocations(caller);
        if (locations.isEmpty()) {
            return null;
        }
        return locations.iterator().next();
    }

    public static void renderCallLocation(MethodReference method, TextLocation location, StringBuilder sb) {
        if (method != null) {
            sb.append(method.getClassName() + "." + method.getName());
        } else {
            sb.append("unknown method");
        }
        if (location != null) {
            sb.append("(");
            String fileName = location.getFileName();
            if (fileName != null) {
                sb.append(fileName.substring(fileName.lastIndexOf(47) + 1));
                sb.append(':');
            }
            sb.append(location.getLine());
            sb.append(')');
        }
    }
}

