/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.Import;
import com.antgroup.antchain.myjava.interop.LinkClass;
import com.antgroup.antchain.myjava.interop.LinkClasses;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.Base64Exception;
import com.antgroup.antchain.myjava.runtime.BoolResult;
import com.antgroup.antchain.myjava.runtime.ContractException;
import com.antgroup.antchain.myjava.runtime.ContractRuntimeException;
import com.antgroup.antchain.myjava.runtime.EVMParameter;
import com.antgroup.antchain.myjava.runtime.HexException;
import com.antgroup.antchain.myjava.runtime.Identity;
import com.antgroup.antchain.myjava.runtime.IntResult;
import com.antgroup.antchain.myjava.runtime.IntWrapper;
import com.antgroup.antchain.myjava.runtime.LongWrapper;
import com.antgroup.antchain.myjava.runtime.MyContractBase;
import com.antgroup.antchain.myjava.runtime.ParamsStream;
import com.antgroup.antchain.myjava.runtime.PrimitiveAlgoUtil;
import com.antgroup.antchain.myjava.runtime.Result;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@StaticInit
@NoMetadata
public final class MychainLib {
    public static final int STORAGE_LIMIT = 524288;
    public static final int GET_CODE_LIMIT = 0x100000;
    public static final int HASH_SIZE = 32;
    public static final int IDENTITY_SIZE = 32;
    public static final byte[] OUT_OF_MEMORY = MychainLib.pack("JAVAGC_ERROR: memory allocation failed");
    public static final byte[] NOT_HANDLED_EXCEPTION_MESSAGE = MychainLib.pack("JAVA_ERROR: not handled exception");
    public static final int NOHASH = 0;
    public static final int SM2 = 0;
    public static final int SHA256 = 1;
    public static final int SM3 = 2;
    public static final int KECCAK256 = 3;
    public static final int SHA1 = 4;
    private static final List<Object> savedContractAbiParams = new ArrayList<Object>();
    private static boolean reverted = false;
    private static IntWrapper lastRawIntWrapper1 = null;
    private static IntWrapper lastRawIntWrapper2 = null;
    private static LongWrapper lastRawLongWrapper1 = null;
    private static LongWrapper lastRawLongWrapper2 = null;

    private MychainLib() {
    }

    public static void saveContractAbiParam(Object object) {
        savedContractAbiParams.add(object);
    }

    @Import(name="__dispatch__")
    public static native int dispatchContractInterface(MyContractBase var0, String var1, Address var2, int var3, ParamsStream var4);

    public static boolean isSameString(String a, String b) {
        return a != null && a.equals(b);
    }

    @Unmanaged
    public static boolean isSameCharArrayPart(Address aCharArrayPart, int aLength, Address bCharArrayPart, int bLength) {
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            short bChar;
            short aChar = aCharArrayPart.add(i * 2).getShort();
            if (aChar == (bChar = bCharArrayPart.add(i * 2).getShort())) continue;
            return false;
        }
        return true;
    }

    @LinkClasses(value={@LinkClass(target=ParamsStream.class, methods={"readInt", "readString", "readHexString", "readBoolean", "readByte", "readChar", "readLong", "readBooleanArray", "readByteArray", "readCharArray", "readIntArray", "readLongArray", "readStringArray", "readHexStringArray", "readIdentity", "readIdentityArray", "requireEnd"}), @LinkClass(target=MychainLib.class, methods={"setReturnStringValue", "setReturnIntValue", "setReturnLongValue", "setReturnBooleanValue", "setReturnByteArray", "revertAbiNotFound", "isSameString", "isSameCharArrayPart", "saveContractAbiParam"}), @LinkClass(target=Identity.class, methods={"getData", "equals", "hashCode"})})
    public static int applyContractEntrypoint(MyContractBase app) {
        String abiName = MychainLib.readInterfaceName();
        byte[] abiParamsSerialized = MychainLib.readInterfaceParams();
        ParamsStream paramsStream = new ParamsStream(abiParamsSerialized);
        Address abiCharactersAddress = Address.ofObject(abiName).add(RuntimeObject.sizeOf(RuntimeObject.class)).getAddress();
        char[] abiCharacters = (char[])WasmRuntime.addressToObject(abiCharactersAddress);
        int abiCharsLength = abiCharacters.length;
        return MychainLib.dispatchContractInterface(app, abiName, Address.ofData(abiCharacters), abiCharsLength, paramsStream);
    }

    public static int revertString(String str) {
        if (reverted) {
            return MychainLib.revert(OUT_OF_MEMORY);
        }
        reverted = true;
        if (str == null) {
            return MychainLib.revert(new byte[0]);
        }
        byte[] bytes = ParamsStream.packString(str);
        return MychainLib.revert(bytes);
    }

    @Unmanaged
    public static int revert(byte[] value) {
        return MychainLib.revertRaw(Address.ofData(value).toInt(), value.length);
    }

    private static native int revertRaw(int var0, int var1);

    public static native void abort();

    public static byte[] hexToBytes(String s) throws HexException {
        if (s.length() % 2 != 0) {
            throw new HexException("hexToBytes: invalid hex string");
        }
        if (s.length() >= 2 && s.charAt(0) == '0' && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
            s = s.substring(2);
        }
        byte[] targetByte = new byte[s.length() / 2];
        for (int i = 0; i < targetByte.length; ++i) {
            targetByte[i] = (byte)(0xFF & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
        }
        return targetByte;
    }

    public static String bytesToHex(byte[] byteArr) {
        char[] resultHexBytes = new char[byteArr.length * 2];
        for (int i = 0; i < byteArr.length; ++i) {
            char[] hex = PrimitiveAlgoUtil.toHexStringFromByte(byteArr[i]);
            if (hex.length < 2) {
                resultHexBytes[i * 2] = 48;
                resultHexBytes[i * 2 + 1] = hex[0];
                continue;
            }
            resultHexBytes[i * 2] = hex[0];
            resultHexBytes[i * 2 + 1] = hex[1];
        }
        return new String(resultHexBytes);
    }

    public static boolean checkAccount(Identity id) {
        return MychainLib.checkAccountBytes(id.getData()) != 0;
    }

    private static native int checkAccountBytes(byte[] var0);

    @Import(name="GetBlockNumber", module="env")
    public static native long getBlockNumber();

    public static byte[] getBlockHash(long blockNum) throws ContractException {
        byte[] hashDataBytes = new byte[32];
        Address blockHashLenAddr = MychainLib.allocateRawIntPointer(32);
        int blockHashLenAddrInt = blockHashLenAddr.toInt();
        int code = MychainLib.getBlockHashBytes(blockNum, hashDataBytes, blockHashLenAddrInt);
        if (code == 0) {
            return hashDataBytes;
        }
        throw new ContractException(code, "GetBlockHash failed. The block doesn't exist.");
    }

    private static native int getBlockHashBytes(long var0, byte[] var2, int var3);

    @Import(name="GetBlockTimeStamp", module="env")
    public static native long getBlockTimeStamp();

    public static Identity getOrigin() throws ContractException {
        byte[] nameBytes = new byte[32];
        Address lengthAddr = MychainLib.allocateRawIntPointer(32);
        int lengthAddrInt = lengthAddr.toInt();
        int code = MychainLib.getOriginBytes(nameBytes, lengthAddrInt);
        if (code == 0) {
            return new Identity(nameBytes);
        }
        throw new ContractException(code, "GetOrigin failed.");
    }

    private static native int getOriginBytes(byte[] var0, int var1);

    public static Map<byte[], Integer> getAuthMap(Identity id) throws ContractException {
        Address retAddr = MychainLib.allocateRawIntPointer(524288);
        int retLen = retAddr.toInt();
        byte[] retBytes = new byte[524288];
        int code = MychainLib.getAuthMapBytes(id.getData(), retBytes, retLen);
        if (code == 0) {
            int retSize = Address.fromInt(retLen).getInt();
            MychainLib.require(retSize <= 524288, "MYCHAINLIB_ERROR: getAuthMap map size too large");
            byte[] actualBytes = Arrays.copyOf(retBytes, retSize);
            return MychainLib.unpackMap(actualBytes, byte[].class, Integer.class);
        }
        throw new ContractException(code, "GetAuthMap failed. The account doesn't exist or is frozen.");
    }

    private static native int getAuthMapBytes(byte[] var0, byte[] var1, int var2);

    public static Map<byte[], Integer> getAuthMapInCache(Identity id) throws ContractException {
        Address retAddr = MychainLib.allocateRawIntPointer(524288);
        int retLen = retAddr.toInt();
        byte[] retBytes = new byte[524288];
        int code = MychainLib.getAuthMapInCacheBytes(id.getData(), retBytes, retLen);
        if (code == 0) {
            int retSize = Address.fromInt(retLen).getInt();
            MychainLib.require(retSize <= 524288, "MYCHAINLIB_ERROR: getAuthMapInCache map size too large");
            byte[] actualBytes = Arrays.copyOf(retBytes, retSize);
            return MychainLib.unpackMap(actualBytes, byte[].class, Integer.class);
        }
        throw new ContractException(code, "GetAuthMapInCache failed. The account doesn't exist or is frozen.");
    }

    private static native int getAuthMapInCacheBytes(byte[] var0, byte[] var1, int var2);

    public static long getBalance(Identity id) throws ContractException {
        Address outBalanceAddr = MychainLib.allocateRawLongPointer(0L);
        int outBalanceAddrInt = outBalanceAddr.toInt();
        int code = MychainLib.getBalanceBytes(id.getData(), outBalanceAddrInt);
        if (code == 0) {
            return Address.fromInt(outBalanceAddrInt).getLong();
        }
        throw new ContractException(code, "GetBalance failed. The account doesn't exist or is frozen.");
    }

    private static native int getBalanceBytes(byte[] var0, int var1);

    public static byte[] getCode(Identity id) throws ContractException {
        int codeDataBytesArrayAddress;
        Address codeLenAddr = MychainLib.allocateRawIntPointer(0x100000);
        int codeLen = codeLenAddr.toInt();
        byte[] idBytes = id.getData();
        byte[] codeDataBytes = new byte[0x100000];
        int idBytesArrayAddress = Address.ofData(idBytes).toInt();
        int code = MychainLib.getCodeBytes(idBytesArrayAddress, idBytes.length, codeDataBytesArrayAddress = Address.ofData(codeDataBytes).toInt(), codeLen);
        if (code == 0) {
            int retSize = Address.fromInt(codeLen).getInt();
            MychainLib.require(retSize <= 0x100000, "MYCHAINLIB_ERROR: getCode code size too large");
            byte[] result = new byte[retSize];
            System.arraycopy(codeDataBytes, 0, result, 0, retSize);
            return result;
        }
        throw new ContractException(code, "GetCode failed. The contract doesn't exist or is frozen.");
    }

    private static native int getCodeBytes(int var0, int var1, int var2, int var3);

    public static byte[] getCodeHash(Identity id) throws ContractException {
        Address hashLenAddr = MychainLib.allocateRawIntPointer(32);
        int hashLenAddrInt = hashLenAddr.toInt();
        byte[] hashDataBytes = new byte[32];
        int code = MychainLib.getCodeHashBytes(id.getData(), hashDataBytes, hashLenAddrInt);
        if (code == 0) {
            return hashDataBytes;
        }
        throw new ContractException(code, "GetCodeHash failed. The contract doesn't exist or is frozen.");
    }

    private static native int getCodeHashBytes(byte[] var0, byte[] var1, int var2);

    public static byte[] getRecoverKey(Identity id) throws ContractException {
        int maxLength = 2048;
        Address recoverKeyAddr = MychainLib.allocateRawIntPointer(maxLength);
        int recoverKeyInt = recoverKeyAddr.toInt();
        byte[] recoverKeyBytes = new byte[maxLength];
        int code = MychainLib.getRecoverKeyBytes(id.getData(), recoverKeyBytes, recoverKeyInt);
        if (code == 0) {
            int retSize = Address.fromInt(recoverKeyInt).getInt();
            MychainLib.require(retSize <= maxLength, "MYCHAINLIB_ERROR: getRecoverKey key size too large");
            return Arrays.copyOf(recoverKeyBytes, retSize);
        }
        throw new ContractException(code, "GetRecoverKey failed. The account doesn't exist or is frozen.");
    }

    private static native int getRecoverKeyBytes(byte[] var0, byte[] var1, int var2);

    public static int getAccountStatus(Identity id) throws ContractException {
        Address statusAddr = MychainLib.allocateRawIntPointer(0);
        int statusAddrInt = statusAddr.toInt();
        int code = MychainLib.getAccountStatusBytes(id.getData(), statusAddrInt);
        if (code == 0) {
            return Address.fromInt(statusAddrInt).getInt();
        }
        throw new ContractException(code, "GetAccountStatus failed. The account doesn't exist.");
    }

    private static native int getAccountStatusBytes(byte[] var0, int var1);

    public static byte[] getTxHash() throws ContractException {
        byte[] dataBytes = new byte[32];
        Address lenAddr = MychainLib.allocateRawIntPointer(32);
        int lenAddrInt = lenAddr.toInt();
        int code = MychainLib.getTxHashBytes(dataBytes, lenAddrInt);
        if (code == 0) {
            return dataBytes;
        }
        throw new ContractException(code, "GetTxHash failed.");
    }

    private static native int getTxHashBytes(byte[] var0, int var1);

    public static int transferBalance(Identity to, long balance) throws ContractException {
        if (balance < 0L) {
            throw new ContractException(1, "Transfer balance should not be less than zero.");
        }
        if (Long.MAX_VALUE - MychainLib.getBalance(to) < balance) {
            throw new ContractException(1, "Transfer Balance overflow.");
        }
        int code = MychainLib.transferBalanceBytes(to.getData(), balance);
        if (code == 0) {
            return code;
        }
        throw new ContractException(code, "TransferBalance failed.");
    }

    private static native int transferBalanceBytes(byte[] var0, long var1);

    public static int require(boolean condition, String str) {
        if (!condition) {
            byte[] bytes = ParamsStream.packString(str);
            return MychainLib.revert(bytes);
        }
        return 0;
    }

    public static <T> int log(T data, String[] topics) {
        byte[][] topicsBytes = new byte[topics.length][];
        for (int i = 0; i < topics.length; ++i) {
            topicsBytes[i] = topics[i].getBytes();
        }
        return MychainLib.log(data, topicsBytes);
    }

    public static <T> int log(T data, byte[][] topics) {
        byte[] dataBytes = MychainLib.pack(data);
        int topicsLen = topics.length;
        String[] hexTopic = new String[topicsLen];
        for (int i = 0; i < topicsLen; ++i) {
            hexTopic[i] = MychainLib.bytesToHex(topics[i]);
        }
        byte[] topicsBytes = ParamsStream.packStringArray(hexTopic);
        int code = MychainLib.logBytes(dataBytes, topicsBytes);
        if (code != 0) {
            throw new ContractRuntimeException(code, "Log failed.");
        }
        return code;
    }

    private static native int logBytes(byte[] var0, byte[] var1);

    @Import(name="GetGas", module="env")
    public static native long getGas();

    @Import(name="GetValue", module="env")
    public static native long getValue();

    public static byte[] getData() {
        Address lenAddr;
        int lenAddrInt;
        int length = WasmRuntime.getDataSize();
        byte[] dataBytes = new byte[length];
        int code = MychainLib.getDataBytes(dataBytes, lenAddrInt = (lenAddr = MychainLib.allocateRawIntPointer(length)).toInt());
        if (code == 0) {
            return dataBytes;
        }
        throw new ContractRuntimeException(code, "GetData failed.");
    }

    private static native int getDataBytes(byte[] var0, int var1);

    public static Identity getSender() {
        byte[] dataBytes = new byte[32];
        Address lenAddr = MychainLib.allocateRawIntPointer(32);
        int lenAddrInt = lenAddr.toInt();
        int code = MychainLib.getSenderBytes(dataBytes, lenAddrInt);
        if (code == 0) {
            return new Identity(dataBytes);
        }
        throw new ContractRuntimeException(code, "GetSender failed.");
    }

    private static native int getSenderBytes(byte[] var0, int var1);

    public static Identity getSelf() {
        byte[] dataBytes = new byte[32];
        Address lenAddr = MychainLib.allocateRawIntPointer(32);
        int lenAddrInt = lenAddr.toInt();
        int code = MychainLib.getSelfBytes(dataBytes, lenAddrInt);
        if (code == 0) {
            return new Identity(dataBytes);
        }
        throw new ContractRuntimeException(code, "GetSelf failed.");
    }

    private static native int getSelfBytes(byte[] var0, int var1);

    public static long getRelatedTransactionListSize(Identity recipientId, long depositFlag) throws ContractException {
        Address countAddr = MychainLib.allocateRawLongPointer(0L);
        int countAddrInt = countAddr.toInt();
        int code = MychainLib.getRelatedTransactionListSizeBytes(recipientId.getData(), depositFlag, countAddrInt);
        if (code == 0) {
            return Address.fromInt(countAddrInt).getLong();
        }
        if (code == 10350) {
            throw new ContractException(code, "GetRelatedTransactionListSize failed. The transaction doesn't exist.");
        }
        throw new ContractException(code, "GetRelatedTransactionListSize failed.");
    }

    private static native int getRelatedTransactionListSizeBytes(byte[] var0, long var1, int var3);

    public static byte[][] getRelatedTransactionList(Identity recipientId, long depositFlag, long startIndex, int number) throws ContractException {
        Address outLenAddr = MychainLib.allocateRawIntPointer(0);
        int outLenAddrInt = outLenAddr.toInt();
        int code = MychainLib.getRelatedTransactionListBytes(recipientId.getData(), depositFlag, startIndex, number, outLenAddrInt);
        if (code == 0) {
            int outSize = Address.fromInt(outLenAddrInt).getInt();
            byte[] outBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(outBytes, outSize) == 0) {
                ParamsStream ps = new ParamsStream(outBytes);
                return ps.read2DByteArray();
            }
            MychainLib.revertString("getRelatedTransactionList: read buffer failed");
            return null;
        }
        if (code == 10350) {
            throw new ContractException(code, "GetRelatedTransactionList failed. Wrong startIndex or number.");
        }
        throw new ContractException(code, "GetRelatedTransactionList failed.");
    }

    private static native int getRelatedTransactionListBytes(byte[] var0, long var1, long var3, int var5, int var6);

    private static native int readBufferBytes(byte[] var0, int var1);

    public static Identity getTransactionSender(byte[] txHashBytes) throws ContractException {
        int txField = 1;
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.getTransactionSenderBytes(txField, txHashBytes, outAddrInt);
        if (code == 0) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] senderBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(senderBytes, outSize) == 0) {
                ParamsStream ps = new ParamsStream(senderBytes);
                return new Identity(ps.readByteArray());
            }
            MychainLib.revertString("getTransactionSender: read buffer failed");
            return null;
        }
        if (code == 10315) {
            throw new ContractException(code, "GetTransactionSender failed. Get transaction out of query block limit.");
        }
        if (code == 10316) {
            throw new ContractException(code, "GetTransactionSender failed. Transaction is not deposit transaction.");
        }
        if (code == 10310) {
            throw new ContractException(code, "GetTransactionSender failed. Transaction doesn't exist.");
        }
        throw new ContractException(code, "GetTransactionSender failed.");
    }

    private static native int getTransactionSenderBytes(int var0, byte[] var1, int var2);

    public static Identity getTransactionReceiver(byte[] txHashBytes) throws ContractException {
        int txField = 2;
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.getTransactionReceiverBytes(txField, txHashBytes, outAddrInt);
        if (code == 0) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] receiverBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(receiverBytes, outSize) == 0) {
                ParamsStream ps = new ParamsStream(receiverBytes);
                return new Identity(ps.readByteArray());
            }
            MychainLib.revertString("getTransactionReceiver: read buffer failed");
            return null;
        }
        if (code == 10315) {
            throw new ContractException(code, "GetTransactionReceiver failed. Get transaction out of query block limit.");
        }
        if (code == 10316) {
            throw new ContractException(code, "GetTransactionReceiver failed. Transaction is not deposit transaction.");
        }
        if (code == 10310) {
            throw new ContractException(code, "GetTransactionReceiver failed. Transaction doesn't exist.");
        }
        throw new ContractException(code, "GetTransactionReceiver failed.");
    }

    private static native int getTransactionReceiverBytes(int var0, byte[] var1, int var2);

    public static long getTransactionTimestamp(byte[] txHashBytes) throws ContractException {
        int txField = 3;
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.getTransactionTimestampBytes(txField, txHashBytes, outAddrInt);
        if (code == 0) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] timestampBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(timestampBytes, outSize) == 0) {
                ParamsStream ps = new ParamsStream(timestampBytes);
                return ps.readLong();
            }
            MychainLib.revertString("getTransactionTimestamp: read buffer failed.");
            return -1L;
        }
        if (code == 10315) {
            throw new ContractException(code, "GetTransactionTimestamp failed. Get transaction out of query block limit.");
        }
        if (code == 10316) {
            throw new ContractException(code, "GetTransactionTimestamp failed. Transaction is not deposit transaction.");
        }
        if (code == 10310) {
            throw new ContractException(code, "GetTransactionTimestamp failed. Transaction doesn't exist.");
        }
        throw new ContractException(code, "GetTransactionTimestamp failed.");
    }

    private static native int getTransactionTimestampBytes(int var0, byte[] var1, int var2);

    public static byte[] getTransactionData(byte[] txHashBytes) throws ContractException {
        int txField = 4;
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.getTransactionDataBytes(txField, txHashBytes, outAddrInt);
        if (code == 0) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] dataBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(dataBytes, outSize) == 0) {
                ParamsStream ps = new ParamsStream(dataBytes);
                return ps.readByteArray();
            }
            MychainLib.revertString("getTransactionData: read buffer failed");
            return null;
        }
        if (code == 10315) {
            throw new ContractException(code, "GetTransactionData failed. Get transaction out of query block limit.");
        }
        if (code == 10316) {
            throw new ContractException(code, "GetTransactionData failed. Transaction is not deposit transaction.");
        }
        if (code == 10310) {
            throw new ContractException(code, "GetTransactionData failed. Transaction doesn't exist.");
        }
        throw new ContractException(code, "GetTransactionData failed.");
    }

    private static native int getTransactionDataBytes(int var0, byte[] var1, int var2);

    public static String[] getTransactionBlockIndex(byte[] txHashBytes) throws ContractException {
        int txField = 5;
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.getTransactionBlockIndexBytes(txField, txHashBytes, outAddrInt);
        if (code == 0) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] retBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(retBytes, outSize) == 0) {
                ParamsStream ps = new ParamsStream(retBytes);
                String blockNumber = String.valueOf(ps.readLong());
                String index = String.valueOf(ps.readInt());
                return new String[]{blockNumber, index};
            }
            MychainLib.revertString("getTransactionBlockIndex: read buffer failed");
            return null;
        }
        if (code == 10315) {
            throw new ContractException(code, "GetTransactionBlockIndex failed. Get transaction out of query block limit.");
        }
        if (code == 10310) {
            throw new ContractException(code, "GetTransactionBlockIndex failed. Transaction doesn't exist.");
        }
        throw new ContractException(code, "GetTransactionBlockIndex failed.");
    }

    private static native int getTransactionBlockIndexBytes(int var0, byte[] var1, int var2);

    public static long getTransactionDepositFlag(byte[] txHashBytes) throws ContractException {
        int txField = 6;
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.getTransactionDepositFlagBytes(txField, txHashBytes, outAddrInt);
        if (code == 0) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] retBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(retBytes, outSize) == 0) {
                ParamsStream ps = new ParamsStream(retBytes);
                return ps.readLong();
            }
            MychainLib.revertString("getTransactionDepositFlag: read buffer failed");
            return -1L;
        }
        if (code == 10315) {
            throw new ContractException(code, "GetTransactionDepositFlag failed. Get transaction out of query block limit.");
        }
        if (code == 10316) {
            throw new ContractException(code, "GetTransactionDepositFlag failed. Transaction is not deposit transaction.");
        }
        if (code == 10310) {
            throw new ContractException(code, "GetTransactionDepositFlag failed. Transaction doesn't exist.");
        }
        throw new ContractException(code, "GetTransactionDepositFlag failed.");
    }

    private static native int getTransactionDepositFlagBytes(int var0, byte[] var1, int var2);

    public static byte[] getConfidentialDepositData(byte[] txHashBytes) throws ContractException {
        int txField = 4;
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.getConfidentialDepositDataBytes(txField, txHashBytes, outAddrInt);
        if (code == 0) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] dataBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(dataBytes, outSize) == 0) {
                ParamsStream ps = new ParamsStream(dataBytes);
                return ps.readByteArray();
            }
            MychainLib.revertString("getConfidentialDepositData: read buffer failed");
            return null;
        }
        if (code == 10315) {
            throw new ContractException(code, "GetConfidentialDepositData failed. Get transaction out of query block limit.");
        }
        if (code == 10316) {
            throw new ContractException(code, "GetConfidentialDepositData failed. Transaction is not deposit transaction.");
        }
        if (code == 10310) {
            throw new ContractException(code, "GetConfidentialDepositData failed. Transaction doesn't exist.");
        }
        throw new ContractException(code, "GetConfidentialDepositData failed.");
    }

    private static native int getConfidentialDepositDataBytes(int var0, byte[] var1, int var2);

    public static long getConfidentialDepositFlag(byte[] txHashBytes) throws ContractException {
        int txField = 6;
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.getConfidentialDepositFlagBytes(txField, txHashBytes, outAddrInt);
        if (code == 0) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] retBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(retBytes, outSize) == 0) {
                ParamsStream ps = new ParamsStream(retBytes);
                return ps.readLong();
            }
            MychainLib.revertString("getConfidentialDepositFlag: read buffer failed");
            return -1L;
        }
        if (code == 10315) {
            throw new ContractException(code, "GetConfidentialDepositFlag failed. Get transaction out of query block limit.");
        }
        if (code == 10316) {
            throw new ContractException(code, "GetConfidentialDepositFlag failed. Transaction is not deposit transaction.");
        }
        if (code == 10310) {
            throw new ContractException(code, "GetConfidentialDepositFlag failed. Transaction doesn't exist.");
        }
        throw new ContractException(code, "GetConfidentialDepositFlag failed.");
    }

    private static native int getConfidentialDepositFlagBytes(int var0, byte[] var1, int var2);

    public static int createContract(Identity src, Identity newId) throws ContractException {
        int code = MychainLib.createContractBytes(src.getData(), newId.getData());
        if (code == 0) {
            return code;
        }
        throw new ContractException(code, "CreateContract failed.");
    }

    private static native int createContractBytes(byte[] var0, byte[] var1);

    @Import(name="IsLocalTx", module="env")
    public static native int isLocalTxEnv();

    public static boolean isLocalTx() {
        int ret = MychainLib.isLocalTxEnv();
        return ret != 0;
    }

    @Import(name="GetDigestType", module="env")
    public static native int getDigestType();

    public static byte[] digest(byte[] dataBytes, int digestType) throws ContractException {
        byte[] outDataBytes = new byte[32];
        Address outLenAddr = MychainLib.allocateRawIntPointer(32);
        int outLenAddrInt = outLenAddr.toInt();
        int code = MychainLib.digestBytes(dataBytes, digestType, outDataBytes, outLenAddrInt);
        if (code == 1) {
            return outDataBytes;
        }
        throw new ContractException(code, "Digest failed, not supported digest type.");
    }

    private static native int digestBytes(byte[] var0, int var1, byte[] var2, int var3);

    public static Identity getTargetAddress(byte[] dataBytes) throws ContractException {
        int digestType = MychainLib.getDigestType();
        return new Identity(MychainLib.digest(dataBytes, digestType));
    }

    public static boolean verifyRsa(byte[] pkBytes, byte[] sigBytes, byte[] msgBytes) {
        return MychainLib.verifyRsa(pkBytes, sigBytes, msgBytes, 1);
    }

    public static boolean verifyRsa(byte[] pkBytes, byte[] sigBytes, byte[] msgBytes, int hashType) {
        int ret = MychainLib.verifyRsaBytes(pkBytes, sigBytes, msgBytes, hashType);
        return ret != 0;
    }

    private static native int verifyRsaBytes(byte[] var0, byte[] var1, byte[] var2, int var3);

    public static String base64Encode(byte[] input) {
        int maxLength = (1 + input.length / 3) * 4;
        if (maxLength >= 524288) {
            maxLength = 524288;
        }
        Address outLenAddr = MychainLib.allocateRawIntPointer(maxLength);
        int outLen = outLenAddr.toInt();
        byte[] outDataBytes = new byte[maxLength];
        Address outDataBytesDataPart = Address.ofData(outDataBytes);
        Address intputDataPart = Address.ofData(input);
        int inputArrayLength = input.length;
        int code = MychainLib.base64EncodeBytes(intputDataPart.toInt(), inputArrayLength, outDataBytesDataPart.toInt(), outLen);
        if (code != 0) {
            int retSize = Address.fromInt(outLen).getInt();
            MychainLib.require(retSize <= maxLength, "MYCHAINLIB_ERROR: base64Encode value size too large");
            return new String(Arrays.copyOf(outDataBytes, retSize));
        }
        throw new ContractRuntimeException(code, "Base64Encode failed.");
    }

    private static native int base64EncodeBytes(int var0, int var1, int var2, int var3);

    public static byte[] base64Decode(String input) throws Base64Exception {
        byte[] inputBytes = input.getBytes();
        int maxLength = inputBytes.length;
        if (maxLength >= 524288) {
            maxLength = 524288;
        }
        Address outLenAddr = MychainLib.allocateRawIntPointer(maxLength);
        int outLen = outLenAddr.toInt();
        byte[] outDataBytes = new byte[maxLength];
        Address outDataBytesDataPart = Address.ofData(outDataBytes);
        Address inputBytesDataPart = Address.ofData(inputBytes);
        int inputBytesLength = inputBytes.length;
        int code = MychainLib.base64DecodeBytes(inputBytesDataPart.toInt(), inputBytesLength, outDataBytesDataPart.toInt(), outLen);
        if (code != 0) {
            int retSize = Address.fromInt(outLen).getInt();
            MychainLib.require(retSize <= maxLength, "MYCHAINLIB_ERROR: base64Decode value size too large");
            return Arrays.copyOf(outDataBytes, retSize);
        }
        throw new Base64Exception("Base64Decode failed.");
    }

    private static native int base64DecodeBytes(int var0, int var1, int var2, int var3);

    public static Identity ecrecovery(byte[] hashBytes, byte[] sigBytes) throws ContractException {
        byte[] idBytes = new byte[32];
        Address idLenAddr = MychainLib.allocateRawIntPointer(32);
        int idLenAddrInt = idLenAddr.toInt();
        int code = MychainLib.ecrecoveryBytes(hashBytes, sigBytes, idBytes, idLenAddrInt);
        if (code != 0) {
            return new Identity(idBytes);
        }
        throw new ContractException(code, "Ecrecovery failed. Invalid signature or message, or signature or message do not match.");
    }

    private static native int ecrecoveryBytes(byte[] var0, byte[] var1, byte[] var2, int var3);

    public static boolean verifyMessageSM2(byte[] pkBytes, byte[] sigBytes, byte[] msgBytes) {
        int hashType = 0;
        int ret = MychainLib.verifyMessageSM2Bytes(pkBytes, sigBytes, msgBytes, hashType);
        return ret != 0;
    }

    private static native int verifyMessageSM2Bytes(byte[] var0, byte[] var1, byte[] var2, int var3);

    public static boolean verifyMessageECCK1(byte[] pkBytes, byte[] sigBytes, byte[] msgBytes, int hashType) {
        int ret = MychainLib.verifyMessageECCK1Bytes(pkBytes, sigBytes, msgBytes, hashType);
        return ret != 0;
    }

    private static native int verifyMessageECCK1Bytes(byte[] var0, byte[] var1, byte[] var2, int var3);

    public static boolean verifyMessageECCR1(byte[] pkBytes, byte[] sigBytes, byte[] msgBytes, int hashType) {
        int ret = MychainLib.verifyMessageECCR1Bytes(pkBytes, sigBytes, msgBytes, hashType);
        return ret != 0;
    }

    private static native int verifyMessageECCR1Bytes(byte[] var0, byte[] var1, byte[] var2, int var3);

    public static int bellmanSnarkVerify(byte[] keyBytes, String[] input, byte[] proofBytes) throws ContractException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(input[i]);
        }
        byte[] inputBytes = sb.toString().getBytes();
        int code = MychainLib.bellmanSnarkVerifyBytes(keyBytes, inputBytes, proofBytes);
        if (code == 0) {
            return code;
        }
        throw new ContractException(code, "BellmanSnarkVerify failed.");
    }

    private static native int bellmanSnarkVerifyBytes(byte[] var0, byte[] var1, byte[] var2);

    public static int rangeProofVerify(byte[] proofBytes, byte[][] pcList) throws ContractException {
        byte[] pcListBytes = ParamsStream.pack2DByteArray(pcList);
        Address retAddr = MychainLib.allocateRawIntPointer(0);
        int retAddrInt = retAddr.toInt();
        int code = MychainLib.rangeProofVerifyBytes(retAddrInt, proofBytes, pcListBytes);
        if (code == 0) {
            return Address.fromInt(retAddrInt).getInt();
        }
        throw new ContractException(code, "RangeProofVerify failed.");
    }

    private static native int rangeProofVerifyBytes(int var0, byte[] var1, byte[] var2);

    public static byte[] addPedersenCommit(byte[] pcLeftBytes, byte[] pcRightBytes) throws ContractException {
        Address retLenAddr;
        int retLenAddrInt;
        byte[] retDataBytes;
        Address retAddr = MychainLib.allocateRawIntPointer(0);
        int retAddrInt = retAddr.toInt();
        int errCode = MychainLib.addPedersenCommitBytes(retAddrInt, retDataBytes = new byte[524288], retLenAddrInt = (retLenAddr = MychainLib.allocateRawIntPointer(524288)).toInt(), pcLeftBytes, pcRightBytes);
        MychainLib.require(errCode == 0, "MYCHAINLIB_ERROR: addPedersenCommit got unexpected return value");
        int code = Address.fromInt(retAddrInt).getInt();
        if (code == 0) {
            int retSize = Address.fromInt(retLenAddrInt).getInt();
            MychainLib.require(retSize <= 524288, "MYCHAINLIB_ERROR: addPedersenCommit value size too large");
            return Arrays.copyOf(retDataBytes, retSize);
        }
        throw new ContractException(code, "AddPedersenCommit failed.");
    }

    private static native int addPedersenCommitBytes(int var0, byte[] var1, int var2, byte[] var3, byte[] var4);

    public static byte[] subPedersenCommit(byte[] pcLeftBytes, byte[] pcRightBytes) throws ContractException {
        Address retLenAddr;
        int retLen;
        byte[] retDataBytes = new byte[524288];
        Address retAddr = MychainLib.allocateRawIntPointer(0);
        int errCode = MychainLib.subPedersenCommitBytes(retAddr, retDataBytes, retLen = (retLenAddr = MychainLib.allocateRawIntPointer(524288)).toInt(), pcLeftBytes, pcRightBytes);
        MychainLib.require(errCode == 0, "MYCHAINLIB_ERROR: subPedersenCommit got unexpected return value");
        int code = retAddr.getInt();
        if (code == 0) {
            int retSize = Address.fromInt(retLen).getInt();
            MychainLib.require(retSize <= 524288, "MYCHAINLIB_ERROR: subPedersenCommit value size too large");
            return Arrays.copyOf(retDataBytes, retSize);
        }
        throw new ContractException(code, "SubPedersenCommit failed.");
    }

    private static native int subPedersenCommitBytes(Address var0, byte[] var1, int var2, byte[] var3, byte[] var4);

    public static byte[] calculatePedersenCommit(byte[] srcPcBytes, byte[][] positive, byte[][] negative) throws ContractException {
        byte[] dstPcBytes = new byte[524288];
        IntWrapper retAddrWrapper = new IntWrapper(0);
        Address retAddr = MychainLib.allocateRawIntPointer(retAddrWrapper, 0);
        IntWrapper dstPcAddrWrapper = new IntWrapper(524288);
        Address dstPcAddr = MychainLib.allocateRawIntPointer(dstPcAddrWrapper, 524288);
        int dstLen = dstPcAddr.toInt();
        byte[] positiveBytes = ParamsStream.pack2DByteArray(positive);
        byte[] negativeBytes = ParamsStream.pack2DByteArray(negative);
        int errCode = MychainLib.calculatePedersenCommitBytes(retAddr.toInt(), dstPcBytes, dstLen, srcPcBytes, positiveBytes, negativeBytes);
        MychainLib.require(errCode == 0, "MYCHAINLIB_ERROR: calculatePedersenCommit got unexpected return value");
        System.out.println("err code return by hostapi = " + errCode);
        int code = retAddr.getInt();
        if (code == 0) {
            int retSize = Address.fromInt(dstLen).getInt();
            MychainLib.require(retSize <= 524288, "MYCHAINLIB_ERROR: calculatePedersenCommit value size too large");
            return Arrays.copyOf(dstPcBytes, retSize);
        }
        throw new ContractException(code, "CalculatePedersenCommit failed.");
    }

    private static native int calculatePedersenCommitBytes(int var0, byte[] var1, int var2, byte[] var3, byte[] var4, byte[] var5);

    public static int pedersenCommitEqualityVerify(byte[][] positive, byte[][] negative) throws ContractException {
        byte[] positiveBytes = ParamsStream.pack2DByteArray(positive);
        byte[] negativeBytes = ParamsStream.pack2DByteArray(negative);
        Address retAddr = MychainLib.allocateRawIntPointer(0);
        int retAddrInt = retAddr.toInt();
        int code = MychainLib.pedersenCommitEqualityVerifyBytes(retAddrInt, positiveBytes, negativeBytes);
        if (code == 0) {
            return Address.fromInt(retAddrInt).getInt();
        }
        throw new ContractException(code, "PedersenCommitEqualityVerify failed.");
    }

    private static native int pedersenCommitEqualityVerifyBytes(int var0, byte[] var1, byte[] var2);

    public static byte[] liftedElgamalContractHomomorphicAdd(byte[] firstBytes, byte[] secondBytes) throws ContractException {
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.liftedElgamalContractHomomorphicAddBytes(firstBytes, secondBytes, outAddrInt);
        if (code == 1) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] retBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(retBytes, outSize) == 0) {
                return retBytes;
            }
            MychainLib.revertString("liftedElgamalContractHomomorphicAdd: read buffer failed");
        }
        throw new ContractException(code, "LiftedElgamalContractHomomorphicAdd failed.");
    }

    private static native int liftedElgamalContractHomomorphicAddBytes(byte[] var0, byte[] var1, int var2);

    public static byte[] liftedElgamalContractHomomorphicSub(byte[] firstBytes, byte[] secondBytes) throws ContractException {
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.liftedElgamalContractHomomorphicSubBytes(firstBytes, secondBytes, outAddrInt);
        if (code == 1) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] retBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(retBytes, outSize) == 0) {
                return retBytes;
            }
            MychainLib.revertString("liftedElgamalContractHomomorphicSub: read buffer failed.");
        }
        throw new ContractException(code, "LiftedElgamalContractHomomorphicSub failed.");
    }

    private static native int liftedElgamalContractHomomorphicSubBytes(byte[] var0, byte[] var1, int var2);

    public static byte[] liftedElgamalScalarMutiply(byte[] srcBytes, long scalar) throws ContractException {
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.liftedElgamalScalarMutiplyBytes(srcBytes, scalar, outAddrInt);
        if (code == 1) {
            int outSize = Address.fromInt(outAddrInt).getInt();
            byte[] retBytes = new byte[outSize];
            if (MychainLib.readBufferBytes(retBytes, outSize) == 0) {
                return retBytes;
            }
            MychainLib.revertString("liftedElgamalScalarMutiply: read buffer failed");
        }
        throw new ContractException(code, "LiftedElgamalScalarMutiply failed.");
    }

    private static native int liftedElgamalScalarMutiplyBytes(byte[] var0, long var1, int var3);

    public static int liftedElgamalContractZeroCheckVerify(byte[] cipherBytes, byte[] proofBytes) throws ContractException {
        Address outAddr = MychainLib.allocateRawIntPointer(0);
        int outAddrInt = outAddr.toInt();
        int code = MychainLib.liftedElgamalContractZeroCheckVerifyBytes(cipherBytes, proofBytes, outAddrInt);
        if (code == 1) {
            return Address.fromInt(outAddrInt).getInt();
        }
        throw new ContractException(code, "LiftedElgamalContractZeroCheckVerify failed");
    }

    private static native int liftedElgamalContractZeroCheckVerifyBytes(byte[] var0, byte[] var1, int var2);

    public static int liftedElgamalContractRangeVerify(byte[][] ciphertext, int perValueBitSize, byte[] pubBytes, byte[] proofBytes) throws ContractException {
        int ciphertextLen = 68;
        int bufferLen = ciphertextLen * ciphertext.length;
        byte[] bufferBytes = new byte[bufferLen];
        for (int i = 0; i < ciphertext.length; ++i) {
            byte[] tmpBytes = ciphertext[i];
            if (tmpBytes.length != ciphertextLen) {
                return 10001;
            }
            System.arraycopy(tmpBytes, 0, bufferBytes, ciphertextLen * i, ciphertextLen);
        }
        Address retAddr = MychainLib.allocateRawIntPointer(0);
        int retAddrInt = retAddr.toInt();
        int code = MychainLib.liftedElgamalContractRangeVerifyBytes(bufferBytes, bufferLen, perValueBitSize, pubBytes, proofBytes, retAddrInt);
        if (code == 1) {
            return Address.fromInt(retAddrInt).getInt();
        }
        throw new ContractException(code, "LiftedElgamalContractRangeVerify failed.");
    }

    private static native int liftedElgamalContractRangeVerifyBytes(byte[] var0, int var1, int var2, byte[] var3, byte[] var4, int var5);

    public static int setStorage(String key, byte[] valueBytes) throws ContractException {
        return MychainLib.setStorage(key.getBytes(), valueBytes);
    }

    public static int setStorage(byte[] keyBytes, byte[] valueBytes) throws ContractException {
        int code = MychainLib.setStorageBytes(keyBytes, valueBytes);
        if (code != 0) {
            throw new ContractException(code, "SetStorage failed.");
        }
        return code;
    }

    @Unmanaged
    public static int setStorageWithCode(byte[] keyBytes, byte[] valueBytes) {
        return MychainLib.setStorageBytes(keyBytes, valueBytes);
    }

    private static native int setStorageBytes(byte[] var0, byte[] var1);

    public static int getStorageSize(String key) throws ContractException {
        return MychainLib.getStorageSize(key.getBytes());
    }

    public static int getStorageSize(byte[] keyBytes) throws ContractException {
        IntResult result = MychainLib.getStorageSizeWithCode(keyBytes);
        int code = result.getCode();
        if (code != 0) {
            throw new ContractException(code, "GetStorageSize failed.");
        }
        return result.getResult();
    }

    public static IntResult getStorageSizeWithCode(byte[] keyBytes) {
        Address lenAddr = MychainLib.allocateRawIntPointer(0);
        int code = MychainLib.getStorageSizeBytes(keyBytes, lenAddr.toInt());
        if (code != 0) {
            return new IntResult(code, 0);
        }
        return new IntResult(0, lenAddr.getInt());
    }

    public static native int getStorageSizeBytes(byte[] var0, int var1);

    public static byte[] getStorage(String key) throws ContractException {
        return MychainLib.getStorage(key.getBytes());
    }

    public static byte[] getStorage(byte[] keyBytes) throws ContractException {
        Result<byte[]> result = MychainLib.getStorageWithCode(keyBytes);
        int code = result.getCode();
        if (code != 0) {
            throw new ContractException(code, "GetStorage failed.");
        }
        return result.getResult();
    }

    public static Result<byte[]> getStorageWithCode(byte[] keyBytes) {
        Address lenAddr = MychainLib.allocateRawIntPointer(0);
        int code = MychainLib.getStorageSizeBytes(keyBytes, lenAddr.toInt());
        if (code != 0) {
            return new Result<Object>(code, null);
        }
        int valueSize = Address.fromInt(lenAddr.toInt()).getInt();
        byte[] valueBytes = new byte[valueSize];
        int code2 = MychainLib.getStorageBytes(keyBytes, valueBytes, lenAddr.toInt());
        if (code2 != 0) {
            return new Result<Object>(code2, null);
        }
        return new Result<byte[]>(code2, valueBytes);
    }

    public static native int getStorageBytes(byte[] var0, byte[] var1, int var2);

    public static int deleteStorage(String key) throws ContractException {
        return MychainLib.deleteStorage(key.getBytes());
    }

    public static int deleteStorage(byte[] keyBytes) throws ContractException {
        int code = MychainLib.deleteStorageBytes(keyBytes);
        if (code != 0) {
            throw new ContractException(code, "DeleteStorage failed.");
        }
        return code;
    }

    public static int deleteStorageWithCode(byte[] keyBytes) {
        return MychainLib.deleteStorageBytes(keyBytes);
    }

    private static native int deleteStorageBytes(byte[] var0);

    public static boolean hasStorage(String key) {
        return MychainLib.hasStorage(key.getBytes());
    }

    public static boolean hasStorage(byte[] key) {
        BoolResult result = MychainLib.hasStorageWithCode(key);
        return result.getCode() == 0;
    }

    public static BoolResult hasStorageWithCode(byte[] key) {
        MychainLib.require(key.length != 0, "key is empty");
        IntResult sizeResult = MychainLib.getStorageSizeWithCode(key);
        if (sizeResult.getCode() != 0) {
            return new BoolResult(sizeResult.getCode(), false);
        }
        return new BoolResult(0, true);
    }

    private static native int resultBytes(byte[] var0);

    private static native int readBufferRef(byte[] var0, int var1);

    public static native int verifyCommitment(int var0, int var1, byte[] var2, byte[] var3);

    public static native int verifyRange(int var0, long var1);

    public static native int verifyBalance(int var0);

    public static native int fTraceBegin(byte[] var0);

    @Import(name="FTraceEnd", module="env")
    public static native int fTraceEnd();

    public static int deployContract(Identity proposerId, Identity contractId, byte[] contractCodeBytes, Map<byte[], Integer> authMap) throws ContractException {
        byte[] authMapBytes = MychainLib.packMap(authMap);
        int code = MychainLib.deployContractBytes(proposerId.getData(), contractId.getData(), contractCodeBytes, authMapBytes);
        if (code != 0) {
            throw new ContractException(code, "DeployContract failed.");
        }
        return code;
    }

    private static native int deployContractBytes(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static int updateContract(Identity contractId, byte[] contractCodeBytes) throws ContractException {
        int code = MychainLib.updateContractBytes(contractId.getData(), contractCodeBytes);
        if (code != 0) {
            throw new ContractException(code, "UpdateContract failed.");
        }
        return code;
    }

    private static native int updateContractBytes(byte[] var0, byte[] var1);

    public static int updateContractStatus(Identity contractId, int status) throws ContractException {
        int code = MychainLib.updateContractStatusBytes(contractId.getData(), status);
        if (code != 0) {
            throw new ContractException(code, "UpdateContractStatus failed.");
        }
        return code;
    }

    private static native int updateContractStatusBytes(byte[] var0, int var1);

    public static byte[] dcGetStorage(Identity dcId, int dbId, byte[] keyBytes) throws ContractException {
        Address valueSizeAddr = MychainLib.allocateRawIntPointer(0);
        int valueSizeAddrInt = valueSizeAddr.toInt();
        int code = MychainLib.dcGetStorageSize(dcId.getData(), dbId, keyBytes, valueSizeAddrInt);
        if (code == 0) {
            int valueSize = Address.fromInt(valueSizeAddrInt).getInt();
            byte[] valueBytes = new byte[valueSize];
            int code0 = MychainLib.readBufferRef(valueBytes, valueSize);
            if (code0 != 0) {
                MychainLib.revertString("dcGetStorage: read buffer failed");
            }
            return valueBytes;
        }
        throw new ContractException(code, "DcGetStorage failed.");
    }

    private static native int dcGetStorageSize(byte[] var0, int var1, byte[] var2, int var3);

    public static int dcSetStorage(Identity dcId, int dbId, byte[] keyBytes, byte[] valueBytes) throws ContractException {
        int code = MychainLib.dcSetStorageBytes(dcId.getData(), dbId, keyBytes, valueBytes);
        if (code != 0) {
            throw new ContractException(code, "DcSetStorage failed.");
        }
        return code;
    }

    private static native int dcSetStorageBytes(byte[] var0, int var1, byte[] var2, byte[] var3);

    public static int dcDeleteStorage(Identity dcId, int dbId, byte[] keyBytes) throws ContractException {
        int code = MychainLib.dcDeleteStorageBytes(dcId.getData(), dbId, keyBytes);
        if (code != 0) {
            throw new ContractException(code, "DcDeleteStorage failed.");
        }
        return code;
    }

    private static native int dcDeleteStorageBytes(byte[] var0, int var1, byte[] var2);

    public static int grayscaleDeployContract(Identity contractId, byte[] contractCodeBytes) throws ContractException {
        int code = MychainLib.grayscaleDeployContractBytes(contractId.getData(), contractCodeBytes);
        if (code != 0) {
            throw new ContractException(code, "GrayscaleDeployContract failed.");
        }
        return code;
    }

    private static native int grayscaleDeployContractBytes(byte[] var0, byte[] var1);

    public static int grayscaleVerification(Identity contractId) throws ContractException {
        int code = MychainLib.grayscaleVerificationBytes(contractId.getData());
        if (code != 0) {
            throw new ContractException(code, "GrayscaleVerification failed.");
        }
        return code;
    }

    private static native int grayscaleVerificationBytes(byte[] var0);

    public static int grayscaleVersionSwitchBack(Identity contractId) throws ContractException {
        int code = MychainLib.grayscaleVersionSwitchBackBytes(contractId.getData());
        if (code != 0) {
            throw new ContractException(code, "GrayscaleVersionSwitchBack failed.");
        }
        return code;
    }

    private static native int grayscaleVersionSwitchBackBytes(byte[] var0);

    public static int grayscaleUpdateContract(Identity contractId) throws ContractException {
        int code = MychainLib.grayscaleUpdateContractBytes(contractId.getData());
        if (code != 0) {
            throw new ContractException(code, "GrayscaleUpdateContract failed.");
        }
        return code;
    }

    private static native int grayscaleUpdateContractBytes(byte[] var0);

    @Import(name="GetCallResultSize", module="env")
    public static native int getCallResultSize();

    private static native int getCallResult(Address var0, int var1);

    public static <T, E> Result<?> callContract(Identity contractId, String method, Class<T> retType, long value, long gas, E ... args) throws ContractException {
        if (value < 0L) {
            return new Result<String>(1, "Call contract value should not be less than zero.");
        }
        long contractIdBalance = 0L;
        try {
            contractIdBalance = MychainLib.getBalance(contractId);
        }
        catch (ContractException e) {
            return new Result<String>(1, e.getMessage());
        }
        if (Long.MAX_VALUE - contractIdBalance < value) {
            return new Result<String>(1, "Call Contract overflow.");
        }
        byte[] methodBytes = method.getBytes();
        byte[] argsBytes = ParamsStream.packVarargs(args);
        int code = MychainLib.callContractBytes(contractId.getData(), methodBytes, value, gas, argsBytes);
        int valLen = MychainLib.getCallResultSize();
        byte[] callRetBytes = new byte[valLen];
        Address callRetAddr = MychainLib.allocateRawIntPointer(valLen);
        int callRetAddrInt = callRetAddr.toInt();
        int getRet = MychainLib.getCallResult(Address.ofData(callRetBytes), callRetAddrInt);
        if (getRet != 0) {
            return new Result<String>(1, "get result failed");
        }
        if (Address.fromInt(callRetAddrInt).getInt() > 524288) {
            return new Result<String>(1, "bad result size");
        }
        if (Address.fromInt(callRetAddrInt).getInt() == 0) {
            return new Result<String>(code, "the result of a contract call is empty");
        }
        if (code != 0) {
            return new Result<String>(code, MychainLib.unpack(callRetBytes, String.class));
        }
        if (retType == Void.TYPE) {
            return new Result<Object>(code, null);
        }
        return new Result<T>(code, MychainLib.unpack(callRetBytes, retType));
    }

    public static void revertAbiNotFound(String abiName) {
        MychainLib.revert(MychainLib.pack("METHOD_NOT_FOUND: " + abiName));
    }

    private static native int callContractBytes(byte[] var0, byte[] var1, long var2, long var4, byte[] var6);

    public static int dcSetAcl(Identity dcId, Pair[] acl, int dbId) throws ContractException {
        byte[] aclBytes = ParamsStream.packPairInArray(acl);
        int code = MychainLib.dcSetAclBytes(dcId.getData(), dbId, aclBytes);
        if (code == 0) {
            return code;
        }
        if (code == 1) {
            throw new ContractException(code, "DCSetAcl govern id mismatch.");
        }
        if (code == 2) {
            throw new ContractException(code, "DCSetAcl invalid contractId.");
        }
        if (code == 3) {
            throw new ContractException(code, "DCSetAcl invalid acl.");
        }
        throw new ContractException(code, "DCSetAcl failed.");
    }

    private static native int dcSetAclBytes(byte[] var0, int var1, byte[] var2);

    public static Result<byte[]> callEvm(Identity id, EVMParameter p, long gas, long value) {
        if (value < 0L) {
            MychainLib.revertString("Call contract value should not be less than zero.");
        }
        long idBalance = 0L;
        try {
            idBalance = MychainLib.getBalance(id);
        }
        catch (ContractException e) {
            MychainLib.revertString(e.getMessage());
        }
        if (Long.MAX_VALUE - idBalance < value) {
            MychainLib.revertString("Call Contract overflow.");
        }
        byte[] idBytes = id.getData();
        byte[] input = p.getData();
        String method = p.methodParams;
        byte[] methodBytes = method.getBytes();
        int errCode = 1;
        errCode = MychainLib.callEvmBytes(idBytes, 32, methodBytes, methodBytes.length, input, input.length, gas, value);
        if (errCode != 0 && errCode != 10201) {
            return new Result<byte[]>(errCode, new byte[0]);
        }
        int valLen = MychainLib.getCallResultSize();
        byte[] callResult = new byte[valLen];
        Address callRetAddr = MychainLib.allocateRawIntPointer(valLen);
        int callRetAddrInt = callRetAddr.toInt();
        int getRet = MychainLib.getCallResult(Address.ofData(callResult), callRetAddrInt);
        if (getRet != 0) {
            MychainLib.revertString("GetCallResult fail, may be not enough memory.");
        }
        return new Result<byte[]>(errCode, callResult);
    }

    private static native int callEvmBytes(byte[] var0, int var1, byte[] var2, int var3, byte[] var4, int var5, long var6, long var8);

    public static <T> byte[] pack(T t) {
        Class<?> cls = t.getClass();
        if (cls == Integer.class) {
            return ParamsStream.packInt((Integer)t);
        }
        if (cls == Long.class) {
            return ParamsStream.packLong((Long)t);
        }
        if (cls == String.class) {
            return ParamsStream.packString((String)t);
        }
        if (cls == Boolean.class) {
            return ParamsStream.packBoolean((Boolean)t);
        }
        if (cls == Byte.class) {
            return ParamsStream.packByte((Byte)t);
        }
        if (cls == Character.class) {
            return ParamsStream.packChar(((Character)t).charValue());
        }
        if (cls == Identity.class) {
            return ParamsStream.packIdentity((Identity)t);
        }
        if (cls == int[].class) {
            return ParamsStream.packIntArray((int[])t);
        }
        if (cls == long[].class) {
            return ParamsStream.packLongArray((long[])t);
        }
        if (cls == String[].class) {
            return ParamsStream.packStringArray((String[])t);
        }
        if (cls == boolean[].class) {
            return ParamsStream.packBooleanArray((boolean[])t);
        }
        if (cls == byte[].class) {
            return ParamsStream.packByteArray((byte[])t);
        }
        if (cls == char[].class) {
            return ParamsStream.packCharArray((char[])t);
        }
        if (cls == Identity[].class) {
            return ParamsStream.packIdentityArray((Identity[])t);
        }
        throw new ContractRuntimeException("not supported type while pack");
    }

    public static long unpackLong(byte[] b) throws ContractException {
        Optional<Long> result = MychainLib.unpackLongOptional(b);
        if (!result.isPresent()) {
            throw new ContractException("unpackLong: illegal input");
        }
        return result.get();
    }

    public static Optional<Long> unpackLongOptional(byte[] b) {
        if (b == null || b.length < 8) {
            return Optional.empty();
        }
        long sum = 0L;
        for (int i = 0; i < 8; ++i) {
            sum = sum * 256L + (long)(b[7 - i] & 0xFF);
        }
        return Optional.of(sum);
    }

    public static int unpackInt(byte[] b) throws ContractException {
        Optional<Integer> result = MychainLib.unpackIntOptional(b);
        if (!result.isPresent()) {
            throw new ContractException("unpackInt: illegal input");
        }
        return result.get();
    }

    public static Optional<Integer> unpackIntOptional(byte[] b) {
        if (b == null || b.length < 4) {
            return Optional.empty();
        }
        int sum = 0;
        for (int i = 0; i < 4; ++i) {
            sum = sum * 256 + (b[3 - i] & 0xFF);
        }
        return Optional.of(sum);
    }

    public static boolean unpackBool(byte[] b) throws ContractException {
        Optional<Boolean> result = MychainLib.unpackBoolOptional(b);
        if (!result.isPresent()) {
            throw new ContractException("unpackBool: illegal input");
        }
        return result.get();
    }

    public static Optional<Boolean> unpackBoolOptional(byte[] b) {
        if (b == null || b.length == 0) {
            return Optional.empty();
        }
        int value = b[0] & 0xFF;
        if (value == 1) {
            return Optional.of(true);
        }
        if (value == 0) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public static byte unpackByte(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackByte: illegal input");
        }
        return b[0];
    }

    public static Optional<Byte> unpackByteOptional(byte[] b) {
        if (b == null || b.length == 0) {
            return Optional.empty();
        }
        return Optional.of(b[0]);
    }

    public static char unpackChar(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackChar: illegal input");
        }
        int value = b[0] & 0xFF;
        return (char)value;
    }

    public static Optional<Character> unpackCharOptional(byte[] b) {
        if (b == null || b.length == 0) {
            return Optional.empty();
        }
        int value = b[0] & 0xFF;
        return Optional.of(Character.valueOf((char)value));
    }

    private static Ret2Int decodeULeb128(byte[] b) throws ContractException {
        Optional<Ret2Int> result = MychainLib.decodeULeb128Optional(b);
        if (!result.isPresent()) {
            throw new ContractException("decodeULeb128: wrong size of unpacked data");
        }
        return result.get();
    }

    private static Optional<Ret2Int> decodeULeb128Optional(byte[] b) {
        int value;
        int pos = 0;
        int strLen = 0;
        do {
            if (pos >= b.length) {
                return Optional.empty();
            }
            value = b[pos] & 0xFF;
            int tmpValue = value & 0x7F;
            strLen |= tmpValue << 7 * pos;
            ++pos;
        } while ((value & 0x80) == 128);
        return Optional.of(new Ret2Int(pos, strLen));
    }

    public static String unpackString(byte[] b) throws ContractException {
        Optional<String> result = MychainLib.unpackStringOptional(b);
        if (!result.isPresent()) {
            throw new ContractException("unpackString: illegal input");
        }
        return result.get();
    }

    public static Optional<String> unpackStringOptional(byte[] b) {
        if (b == null || b.length == 0) {
            return Optional.empty();
        }
        Optional<Ret2Int> retOption = MychainLib.decodeULeb128Optional(b);
        if (!retOption.isPresent()) {
            return Optional.empty();
        }
        Ret2Int ret = retOption.get();
        int pos = ret.pos;
        int strLen = ret.len;
        if (strLen == 0) {
            return Optional.of("");
        }
        if (pos < b.length && pos + strLen <= b.length) {
            char[] charArr = new char[strLen];
            for (int i = 0; i < strLen; ++i) {
                charArr[i] = (char)b[pos + i];
            }
            return Optional.of(new String(charArr));
        }
        return Optional.empty();
    }

    public static Identity unpackIdentity(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackIdentity: illegal input");
        }
        Ret2Int ret = MychainLib.decodeULeb128(b);
        int pos = ret.pos;
        int len = ret.len;
        if (len != 32) {
            throw new ContractException("unpackIdentity: Identity size should be 32");
        }
        if (pos < b.length && pos + len <= b.length) {
            byte[] targerArr = new byte[len];
            System.arraycopy(b, pos, targerArr, 0, len);
            return new Identity(targerArr);
        }
        throw new ContractException("unpackIdentity failed");
    }

    public static int[] unpackIntArray(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackIntArray: illegal input");
        }
        Ret2Int ret = MychainLib.decodeULeb128(b);
        int pos = ret.pos;
        int len = ret.len;
        if (len == 0) {
            return new int[0];
        }
        int[] target = new int[len];
        if (pos < b.length && pos + len * 4 <= b.length) {
            for (int i = 0; i < len; ++i) {
                byte[] tmpArr = new byte[4];
                System.arraycopy(b, pos, tmpArr, 0, 4);
                target[i] = MychainLib.unpackInt(tmpArr);
                pos += 4;
            }
            return target;
        }
        throw new ContractException("unpackIntArray failed");
    }

    public static long[] unpackLongArray(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackLongArray: illegal input");
        }
        Ret2Int ret = MychainLib.decodeULeb128(b);
        int pos = ret.pos;
        int len = ret.len;
        if (len == 0) {
            return new long[0];
        }
        long[] target = new long[len];
        if (pos < b.length && pos + len * 8 <= b.length) {
            for (int i = 0; i < len; ++i) {
                byte[] tmpArr = new byte[8];
                System.arraycopy(b, pos, tmpArr, 0, 8);
                target[i] = MychainLib.unpackLong(tmpArr);
                pos += 8;
            }
            return target;
        }
        throw new ContractException("unpackLongArray failed");
    }

    public static String[] unpackStringArray(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackStringArray: illegal input");
        }
        Ret2Int ret = MychainLib.decodeULeb128(b);
        int pos = ret.pos;
        int len = ret.len;
        if (len == 0) {
            return new String[0];
        }
        String[] target = new String[len];
        for (int i = 0; i < len; ++i) {
            int tmpLen;
            int tmpPos;
            byte[] tmpBytes;
            if (pos < b.length) {
                tmpBytes = new byte[b.length - pos];
                System.arraycopy(b, pos, tmpBytes, 0, b.length - pos);
                Ret2Int tmpRet = MychainLib.decodeULeb128(tmpBytes);
                tmpPos = tmpRet.pos;
                tmpLen = tmpRet.len;
                if (tmpPos >= tmpBytes.length || tmpPos + tmpLen > tmpBytes.length) {
                    throw new ContractException("unpackStringArray failed");
                }
            } else {
                throw new ContractException("unpackStringArray: no more byte to read, illegal input");
            }
            byte[] strByte = new byte[tmpLen];
            System.arraycopy(tmpBytes, tmpPos, strByte, 0, tmpLen);
            target[i] = new String(strByte, StandardCharsets.UTF_8);
            pos = pos + tmpPos + tmpLen;
        }
        return target;
    }

    public static boolean[] unpackBoolArray(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackBoolArray: illegal input");
        }
        Ret2Int ret = MychainLib.decodeULeb128(b);
        int pos = ret.pos;
        int len = ret.len;
        if (len == 0) {
            return new boolean[0];
        }
        boolean[] target = new boolean[len];
        if (pos < b.length && pos + len <= b.length) {
            for (int i = 0; i < len; ++i) {
                int value = b[pos] & 0xFF;
                if (value == 1) {
                    target[i] = true;
                } else if (value == 0) {
                    target[i] = false;
                } else {
                    throw new ContractException("unpackBoolArray failed, wrong value");
                }
                ++pos;
            }
            return target;
        }
        throw new ContractException("unpackBoolArray failed");
    }

    public static byte[] unpackByteArray(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackByteArray: illegal input");
        }
        Ret2Int ret = MychainLib.decodeULeb128(b);
        int pos = ret.pos;
        int len = ret.len;
        if (len == 0) {
            return new byte[0];
        }
        byte[] target = new byte[len];
        if (pos < b.length && pos + len <= b.length) {
            System.arraycopy(b, pos, target, 0, len);
            return target;
        }
        throw new ContractException("unpackByteArray failed");
    }

    public static char[] unpackCharArray(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackCharArray: illegal input");
        }
        Ret2Int ret = MychainLib.decodeULeb128(b);
        int pos = ret.pos;
        int len = ret.len;
        if (len == 0) {
            return new char[0];
        }
        char[] target = new char[len];
        if (pos < b.length && pos + len <= b.length) {
            for (int i = 0; i < len; ++i) {
                int value = b[pos] & 0xFF;
                target[i] = (char)value;
                ++pos;
            }
            return target;
        }
        throw new ContractException("unpackCharArray failed");
    }

    public static Identity[] unpackIdentityArray(byte[] b) throws ContractException {
        if (b == null || b.length == 0) {
            throw new ContractException("unpackIdentityArray: illegal input");
        }
        Ret2Int ret = MychainLib.decodeULeb128(b);
        int pos = ret.pos;
        int len = ret.len;
        if (len == 0) {
            return new Identity[0];
        }
        Identity[] target = new Identity[len];
        for (int i = 0; i < len; ++i) {
            int tmpLen;
            int tmpPos;
            byte[] tmpBytes;
            if (pos < b.length) {
                tmpBytes = new byte[b.length - pos];
                System.arraycopy(b, pos, tmpBytes, 0, b.length - pos);
                Ret2Int tmpRet = MychainLib.decodeULeb128(tmpBytes);
                tmpPos = tmpRet.pos;
                tmpLen = tmpRet.len;
                if (tmpLen != 32) {
                    throw new ContractException("unpackIdentityArray: Identity size should be 32");
                }
                if (tmpPos >= tmpBytes.length || tmpPos + tmpLen > tmpBytes.length) {
                    throw new ContractException("unpackIdentityArray failed");
                }
            } else {
                throw new ContractException("unpackIdentityArray: no more byte to read, illegal input");
            }
            byte[] identityByte = new byte[tmpLen];
            System.arraycopy(tmpBytes, tmpPos, identityByte, 0, tmpLen);
            target[i] = new Identity(identityByte);
            pos = pos + tmpPos + tmpLen;
        }
        return target;
    }

    public static <T> T unpack(byte[] b, Class<T> type) throws ContractException {
        if (type == Integer.class) {
            return (T)Integer.valueOf(MychainLib.unpackInt(b));
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(MychainLib.unpackLong(b));
        }
        if (type == String.class) {
            return (T)MychainLib.unpackString(b);
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(MychainLib.unpackBool(b));
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(MychainLib.unpackByte(b));
        }
        if (type == Character.class) {
            return (T)Character.valueOf(MychainLib.unpackChar(b));
        }
        if (type == Identity.class) {
            return (T)MychainLib.unpackIdentity(b);
        }
        if (type == int[].class) {
            return (T)MychainLib.unpackIntArray(b);
        }
        if (type == long[].class) {
            return (T)MychainLib.unpackLongArray(b);
        }
        if (type == String[].class) {
            return (T)MychainLib.unpackStringArray(b);
        }
        if (type == boolean[].class) {
            return (T)MychainLib.unpackBoolArray(b);
        }
        if (type == byte[].class) {
            return (T)MychainLib.unpackByteArray(b);
        }
        if (type == char[].class) {
            return (T)MychainLib.unpackCharArray(b);
        }
        if (type == Identity[].class) {
            return (T)MychainLib.unpackIdentityArray(b);
        }
        throw new ContractException("not supported type while unpack");
    }

    public static <T, E> byte[] packMap(Map<T, E> map) {
        ArrayList<byte[]> targetList = new ArrayList<byte[]>();
        int mapLen = map.size();
        byte[] mapLenByte = ParamsStream.encodeULeb128(mapLen);
        targetList.add(mapLenByte);
        int allLen = mapLenByte.length;
        for (Map.Entry<T, E> entry : map.entrySet()) {
            byte[] keyBytes = MychainLib.pack(entry.getKey());
            byte[] valueBytes = MychainLib.pack(entry.getValue());
            targetList.add(keyBytes);
            targetList.add(valueBytes);
            allLen += keyBytes.length;
            allLen += valueBytes.length;
        }
        byte[] retByte = new byte[allLen];
        int pos = 0;
        for (byte[] tmp : targetList) {
            System.arraycopy(tmp, 0, retByte, pos, tmp.length);
            pos += tmp.length;
        }
        return retByte;
    }

    public static <T, E> Map<T, E> unpackMap(byte[] b, Class<T> keyType, Class<E> valueType) {
        ParamsStream ps = new ParamsStream(b);
        int mapSize = ps.decodeULeb128();
        HashMap<Object, Object> retMap = new HashMap<Object, Object>();
        Object key = null;
        Object value = null;
        for (int i = 0; i < mapSize; ++i) {
            if (keyType == Integer.class) {
                key = keyType.cast(ps.readInt());
            } else if (keyType == Long.class) {
                key = keyType.cast(ps.readLong());
            } else if (keyType == String.class) {
                key = keyType.cast(ps.readString());
            } else if (keyType == Boolean.class) {
                key = keyType.cast(ps.readBoolean());
            } else if (keyType == Byte.class) {
                key = keyType.cast(ps.readByte());
            } else if (keyType == Character.class) {
                key = keyType.cast(Character.valueOf(ps.readChar()));
            } else if (keyType == Identity.class) {
                key = keyType.cast(ps.readIdentity());
            } else if (keyType == int[].class) {
                key = keyType.cast(ps.readIntArray());
            } else if (keyType == long[].class) {
                key = keyType.cast(ps.readLongArray());
            } else if (keyType == String[].class) {
                key = keyType.cast(ps.readStringArray());
            } else if (keyType == boolean[].class) {
                key = keyType.cast(ps.readBooleanArray());
            } else if (keyType == byte[].class) {
                key = keyType.cast(ps.readByteArray());
            } else if (keyType == char[].class) {
                key = keyType.cast(ps.readCharArray());
            } else if (keyType == Identity[].class) {
                key = keyType.cast(ps.readIdentityArray());
            } else {
                MychainLib.revertString("not supported type of map key");
            }
            if (valueType == Integer.class) {
                value = valueType.cast(ps.readInt());
            } else if (valueType == Long.class) {
                value = valueType.cast(ps.readLong());
            } else if (valueType == String.class) {
                value = valueType.cast(ps.readString());
            } else if (valueType == Boolean.class) {
                value = valueType.cast(ps.readBoolean());
            } else if (valueType == Byte.class) {
                value = valueType.cast(ps.readByte());
            } else if (valueType == Character.class) {
                value = valueType.cast(Character.valueOf(ps.readChar()));
            } else if (valueType == Identity.class) {
                value = valueType.cast(ps.readIdentity());
            } else if (valueType == int[].class) {
                value = valueType.cast(ps.readIntArray());
            } else if (valueType == long[].class) {
                value = valueType.cast(ps.readLongArray());
            } else if (valueType == String[].class) {
                value = valueType.cast(ps.readStringArray());
            } else if (valueType == boolean[].class) {
                value = valueType.cast(ps.readBooleanArray());
            } else if (valueType == byte[].class) {
                value = valueType.cast(ps.readByteArray());
            } else if (valueType == char[].class) {
                value = valueType.cast(ps.readCharArray());
            } else if (valueType == Identity[].class) {
                value = valueType.cast(ps.readIdentityArray());
            } else {
                MychainLib.revertString("not supported type of map value");
            }
            retMap.put(key, value);
        }
        return retMap;
    }

    public static int setReturnStringValue(String s) throws ContractException {
        byte[] strBytes;
        int code;
        if (s == null) {
            s = "null";
        }
        if ((code = MychainLib.setReturnValue(strBytes = s.length() == 0 ? new byte[]{} : ParamsStream.packString(s))) == 0) {
            return code;
        }
        throw new ContractException(code, "SetReturnStringValue failed.");
    }

    public static int setReturnBooleanValue(boolean value) throws ContractException {
        byte[] valueBytes = MychainLib.pack(value);
        int code = MychainLib.setReturnValue(valueBytes);
        if (code == 0) {
            return code;
        }
        throw new ContractException(code, "setReturnBooleanValue failed.");
    }

    public static int setReturnIntValue(int value) throws ContractException {
        byte[] valueBytes = MychainLib.pack(value);
        int code = MychainLib.setReturnValue(valueBytes);
        if (code == 0) {
            return code;
        }
        throw new ContractException(code, "SetReturnIntValue failed.");
    }

    public static int setReturnLongValue(long value) throws ContractException {
        byte[] valueBytes = MychainLib.pack(value);
        int code = MychainLib.setReturnValue(valueBytes);
        if (code == 0) {
            return code;
        }
        throw new ContractException(code, "SetReturnLongValue failed.");
    }

    public static int setReturnByteArray(byte[] value) throws ContractException {
        byte[] valueBytes = MychainLib.pack(value);
        int code = MychainLib.setReturnValue(valueBytes);
        if (code == 0) {
            return code;
        }
        throw new ContractException(code, "setReturnByteArray failed.");
    }

    public static native int setReturnValue(byte[] var0);

    public static native int readInterfaceNameBytes(Address var0, int var1);

    public static native int readInterfaceParamsBytes(Address var0, int var1);

    public static Address allocateRawIntPointer(IntWrapper wrapper, int value) {
        lastRawIntWrapper1 = lastRawIntWrapper2;
        lastRawIntWrapper2 = wrapper;
        Address wrapperBodyAddr = Address.fromInt(WasmRuntime.getWrapperBodyAddress(Address.ofObject(wrapper).toInt()));
        wrapperBodyAddr.putInt(value);
        return wrapperBodyAddr;
    }

    public static Address allocateRawIntPointer(int value) {
        IntWrapper wrapper = new IntWrapper(value);
        return MychainLib.allocateRawIntPointer(wrapper, value);
    }

    private static Address allocateRawLongPointer(long value) {
        LongWrapper wrapper = new LongWrapper(value);
        lastRawLongWrapper1 = lastRawLongWrapper2;
        lastRawLongWrapper2 = wrapper;
        Address wrapperBodyAddr = Address.fromInt(WasmRuntime.getWrapperBodyAddress(Address.ofObject(wrapper).toInt()));
        wrapperBodyAddr.putLong(value);
        return wrapperBodyAddr;
    }

    public static String readInterfaceName() {
        int length = WasmRuntime.readInterfaceNameSize();
        IntWrapper lengthWrapper = new IntWrapper(length);
        Address lengthBodyAddr = MychainLib.allocateRawIntPointer(lengthWrapper, length);
        byte[] nameBytes = new byte[length];
        int code = MychainLib.readInterfaceNameBytes(Address.ofData(nameBytes), lengthBodyAddr.toInt());
        if (code != 0) {
            MychainLib.revertString("ReadInterfaceName failed.");
            return "";
        }
        char[] nameChars = new char[length];
        for (int i = 0; i < length; ++i) {
            nameChars[i] = (char)nameBytes[i];
        }
        return new String(nameChars);
    }

    public static byte[] readInterfaceParams() {
        int length = WasmRuntime.readInterfaceParamsSize();
        Address lengthAddr = MychainLib.allocateRawIntPointer(length);
        byte[] paramsBytes = new byte[length];
        int code = MychainLib.readInterfaceParamsBytes(Address.ofData(paramsBytes), lengthAddr.toInt());
        if (code == 0) {
            return paramsBytes;
        }
        throw new ContractRuntimeException(code, "ReadInterfaceParams failed.");
    }

    private static class Ret2Int {
        public int pos;
        public int len;

        public Ret2Int(int pos, int len) {
            this.pos = pos;
            this.len = len;
        }
    }

    public static class Pair {
        public byte[] id;
        public byte acl;

        public Pair(byte[] id, byte acl) {
            this.id = id;
            this.acl = acl;
        }
    }
}

