/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.GC;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

@Unmanaged
@StaticInit
@NoMetadata
final class MarkQueue {
    private static int head;
    private static int tail;
    private static int limit;

    private MarkQueue() {
    }

    static void init() {
        head = 0;
        tail = 0;
        limit = GC.gcMarkQueueBytesSize() / 4;
    }

    static void enqueue(RuntimeObject object) {
        Address queueItemAddr = GC.gcMarkQueueAddress().add(4 * tail);
        queueItemAddr.putInt(MarkQueue.pack(object.toAddress()));
        if (++tail >= limit) {
            tail = 0;
        }
        if (tail == head) {
            WasmRuntime.abortDirectly();
        }
    }

    static RuntimeObject dequeue() {
        Address result = MarkQueue.unpack(GC.gcMarkQueueAddress().add(4 * head).getInt());
        if (++head >= limit) {
            head = 0;
        }
        return (RuntimeObject)result.toStructure();
    }

    private static int pack(Address address) {
        return (int)(address.toLong() - GC.heapAddress().toLong() >>> 2);
    }

    private static Address unpack(int packed) {
        return GC.heapAddress().add((long)packed << 2);
    }

    static boolean isEmpty() {
        return head == tail;
    }
}

