/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.Export;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Structure;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.FreeChunk;
import com.antgroup.antchain.myjava.runtime.FreeChunkHolder;
import com.antgroup.antchain.myjava.runtime.MarkQueue;
import com.antgroup.antchain.myjava.runtime.MemoryTrace;
import com.antgroup.antchain.myjava.runtime.Mutator;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import com.antgroup.antchain.myjava.runtime.RuntimeArray;
import com.antgroup.antchain.myjava.runtime.RuntimeClass;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import com.antgroup.antchain.myjava.runtime.RuntimeReference;
import com.antgroup.antchain.myjava.runtime.RuntimeReferenceQueue;
import com.antgroup.antchain.myjava.runtime.ShadowStack;
import com.antgroup.antchain.myjava.runtime.WasmHeap;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

@Unmanaged
@StaticInit
@NoMetadata
public final class GC {
    private static final int MIN_CHUNK_SIZE = 8;
    static Address currentChunkLimit;
    static FreeChunk currentChunk;
    static FreeChunkHolder currentChunkPointer;
    public static int freeChunks;
    static int totalChunks;
    static int freeMemory;
    static RuntimeReference firstWeakReference;
    static FreeChunk lastChunk;

    private GC() {
    }

    static native Address gcStorageAddress();

    static native int gcStorageSize();

    static native Address gcMarkQueueAddress();

    static native int gcMarkQueueBytesSize();

    public static native Address heapAddress();

    public static native long availableBytes();

    public static native long minAvailableBytes();

    public static native long maxAvailableBytes();

    public static native void resizeHeap(long var0);

    public static native void writeBarrier(RuntimeObject var0);

    public static int getFreeMemory() {
        return freeMemory;
    }

    private static boolean moveCurrentChunkToNextFree() {
        while (GC.currentChunk.classReference != 0) {
            if ((currentChunk = (FreeChunk)currentChunk.toAddress().add(GC.objectSize(currentChunk)).toStructure()).toAddress().toInt() <= lastChunk.toAddress().toInt()) continue;
            return false;
        }
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        return true;
    }

    public static RuntimeObject alloc(int size) {
        if (size < 8) {
            size = 8;
        }
        if (currentChunk.toAddress().toInt() > lastChunk.toAddress().toInt()) {
            GC.doCollectGarbage();
        }
        FreeChunk current = currentChunk;
        Address next = current.toAddress().add(size);
        if (current.toAddress().toInt() > lastChunk.toAddress().toInt() || !next.add(Structure.sizeOf(FreeChunk.class)).isLessThan(currentChunkLimit)) {
            GC.getNextChunk(size);
            current = currentChunk;
            next = current.toAddress().add(size);
        }
        boolean lastIsCurrent = lastChunk == currentChunk;
        currentChunk = (FreeChunk)next.toStructure();
        boolean hasNextFreeChunk = true;
        if (current.size == size) {
            --freeChunks;
            hasNextFreeChunk = GC.moveCurrentChunkToNextFree();
        } else {
            GC.currentChunk.classReference = 0;
            GC.currentChunk.size = current.size - size;
            currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        }
        GC.currentChunkPointer.value = currentChunk;
        if (lastIsCurrent && hasNextFreeChunk) {
            lastChunk = currentChunk;
        }
        freeMemory -= size;
        MemoryTrace.allocate(current.toAddress(), size);
        if (current.toAddress().toInt() == 0) {
            MychainLib.revert(MychainLib.OUT_OF_MEMORY);
        }
        return (RuntimeObject)current.toAddress().toStructure();
    }

    private static void getNextChunk(int size) {
        if (GC.getNextChunkIfPossible(size)) {
            return;
        }
        GC.resizeHeapIfNecessary(size);
        if (GC.currentChunk.classReference == 0 && GC.currentChunk.size >= size + 8 || GC.getNextChunkIfPossible(size)) {
            return;
        }
        GC.doCollectGarbage();
        if (GC.currentChunk.size != size && GC.currentChunk.size <= size + 8 && !GC.getNextChunkIfPossible(size)) {
            MychainLib.revert(MychainLib.OUT_OF_MEMORY);
        }
    }

    public static void testDumpFreeChunks() {
        int fc = freeChunks;
        int freeChunkIterator = freeChunks;
        FreeChunkHolder pointer = currentChunkPointer;
        int chunk0Addr = 0;
        int chunk0Size = 0;
        int chunk0Tag = 0;
        int chunk1Addr = 0;
        int chunk1Size = 0;
        int chunk1Tag = 0;
        int chunk2Size = 0;
        int chunk2Tag = 0;
        int chunk3Size = 0;
        int chunk4Size = 0;
        int chunk5Size = 0;
        int chunk6Size = 0;
        int chunk7Size = 0;
        for (int i = 0; i < freeChunkIterator; ++i) {
            FreeChunk chunk = pointer.value;
            if (i == 0) {
                chunk0Addr = Address.ofObject(chunk).toInt();
                chunk0Size = chunk.size + 1;
                chunk0Tag = chunk.classReference + 1;
            } else if (i == 1) {
                chunk1Addr = Address.ofObject(chunk).toInt();
                chunk1Size = chunk.size + 1;
                chunk1Tag = chunk.classReference + 1;
            } else if (i == 2) {
                chunk2Size = chunk.size + 1;
                chunk2Tag = chunk.classReference + 1;
            } else if (i == 3) {
                chunk3Size = chunk.size + 1;
            } else if (i == 4) {
                chunk4Size = chunk.size + 1;
            } else if (i == 5) {
                chunk5Size = chunk.size + 1;
            } else if (i == 6) {
                chunk6Size = chunk.size + 1;
            } else if (i == 7) {
                chunk7Size = chunk.size + 1;
            }
            pointer = Structure.add(FreeChunkHolder.class, pointer, 1);
        }
        WasmRuntime.abortDirectly();
        System.out.println(fc + chunk0Size + chunk0Tag + chunk0Addr + chunk1Size + chunk1Tag + chunk1Addr + chunk2Size + chunk2Tag + chunk3Size + chunk4Size + chunk5Size + chunk6Size + chunk7Size);
    }

    private static boolean getNextChunkIfPossible(int size) {
        int freeChunkIterator = freeChunks;
        while (true) {
            currentChunkPointer = Structure.add(FreeChunkHolder.class, currentChunkPointer, 1);
            currentChunk = GC.currentChunkPointer.value;
            currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
            if (currentChunk.toAddress().toInt() >= WasmHeap.storageAddress.toInt()) {
                return false;
            }
            if (--freeChunkIterator == 0) {
                return false;
            }
            if (GC.currentChunk.size >= size + 8 || GC.currentChunk.size == size) break;
            freeMemory -= GC.currentChunk.size;
        }
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        return true;
    }

    @Export(name="myjava_gc_collect")
    public static void collectGarbage() {
        GC.fixHeap();
        GC.doCollectGarbage();
    }

    @Export(name="myjava_gc_collectFull")
    public static void collectGarbageFull() {
        GC.fixHeap();
        GC.collectGarbageFullImpl(0);
    }

    private static void collectGarbageFullImpl(int size) {
        GC.doCollectGarbage();
    }

    private static void doCollectGarbage() {
        MemoryTrace.gcStarted(true);
        GC.mark();
        GC.processReferences();
        GC.sweep();
        GC.updateFreeMemory();
        MemoryTrace.gcCompleted();
        totalChunks = freeChunks;
        currentChunk = GC.currentChunkPointer.value;
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
    }

    private static boolean hasAvailableChunk(int size) {
        if (size == 0) {
            return true;
        }
        FreeChunkHolder ptr = currentChunkPointer;
        for (int i = 0; i < freeChunks; ++i) {
            if (size == ptr.value.size || size + 8 <= ptr.value.size) {
                return true;
            }
            ptr = Structure.add(FreeChunkHolder.class, ptr, 1);
        }
        return false;
    }

    private static long computeMinRequestedSize(int size) {
        if (GC.lastChunk.classReference == 0) {
            size -= GC.lastChunk.size;
        }
        return GC.availableBytes() + (long)size;
    }

    @Export(name="myjava_gc_fixHeap")
    public static void fixHeap() {
        if (freeChunks > 0) {
            GC.currentChunk.classReference = 0;
            GC.currentChunk.size = (int)(currentChunkLimit.toLong() - currentChunk.toAddress().toLong());
        }
    }

    @Export(name="myjava_gc_tryShrink")
    public static void tryShrink() {
        long availableBytes = GC.availableBytes();
        long occupiedMemory = availableBytes - (long)freeMemory;
        if (occupiedMemory < availableBytes / 4L) {
            GC.collectGarbageFull();
        }
    }

    private static void mark() {
        MemoryTrace.markStarted();
        firstWeakReference = null;
        GC.markFromStaticFields();
        GC.markFromClasses();
        GC.markFromStack();
        MemoryTrace.markCompleted();
    }

    private static void markFromStaticFields() {
        Address staticRoots = Mutator.getStaticGCRoots();
        int staticCount = staticRoots.getInt();
        staticRoots = staticRoots.add(4);
        while (staticCount-- > 0) {
            RuntimeObject object = (RuntimeObject)staticRoots.getAddress().getAddress().toStructure();
            if (object != null) {
                GC.mark(object);
            }
            staticRoots = staticRoots.add(Address.sizeOf());
        }
    }

    private static void markFromClasses() {
        int classCount = Mutator.getClassCount();
        Address classPtr = Mutator.getClasses();
        for (int i = 0; i < classCount; ++i) {
            RuntimeClass cls = (RuntimeClass)classPtr.getAddress().toStructure();
            if (cls.simpleName != null) {
                GC.mark(cls.simpleName);
            }
            if (cls.canonicalName != null) {
                GC.mark(cls.canonicalName);
            }
            if (cls.name != null) {
                GC.mark(cls.name);
            }
            classPtr = classPtr.add(Address.sizeOf());
        }
    }

    private static void markFromStack() {
        Address stackRoots = ShadowStack.getStackTop();
        while (stackRoots != null) {
            int count = ShadowStack.getStackRootCount(stackRoots);
            Address stackRootsPtr = ShadowStack.getStackRootPointer(stackRoots);
            while (count-- > 0) {
                RuntimeObject obj = (RuntimeObject)stackRootsPtr.getAddress().toStructure();
                GC.mark(obj);
                stackRootsPtr = stackRootsPtr.add(Address.sizeOf());
            }
            stackRoots = ShadowStack.getNextStackFrame(stackRoots);
        }
    }

    private static void mark(RuntimeObject object) {
        if (object == null || GC.isMarked(object)) {
            return;
        }
        MarkQueue.init();
        GC.enqueueMark(object);
        GC.doProcessMarkQueue();
    }

    private static void doProcessMarkQueue() {
        while (!MarkQueue.isEmpty()) {
            RuntimeObject object = MarkQueue.dequeue();
            MemoryTrace.mark(object.toAddress());
            GC.markObjectData(object);
        }
    }

    private static boolean markObjectData(RuntimeObject object) {
        RuntimeClass cls = RuntimeClass.getClass(object);
        if (cls.itemType == null) {
            return GC.markObject(cls, object);
        }
        return GC.markArray(cls, (RuntimeArray)object);
    }

    private static boolean markObject(RuntimeClass cls, RuntimeObject object) {
        boolean hasObjectsFromYoungGen = false;
        while (cls != null) {
            int type = cls.flags >> 7 & 7;
            switch (type) {
                case 1: {
                    hasObjectsFromYoungGen |= GC.markWeakReference((RuntimeReference)object);
                    break;
                }
                case 2: {
                    hasObjectsFromYoungGen |= GC.markReferenceQueue((RuntimeReferenceQueue)object);
                    break;
                }
                default: {
                    hasObjectsFromYoungGen |= GC.markFields(cls, object);
                }
            }
            cls = cls.parent;
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean markWeakReference(RuntimeReference object) {
        boolean hasObjectsFromYoungGen = false;
        if (object.queue != null) {
            hasObjectsFromYoungGen |= GC.enqueueMark(object.queue);
            if (object.next != null && object.object != null) {
                hasObjectsFromYoungGen |= GC.enqueueMark(object.object);
            }
        }
        if (object.next != null) {
            hasObjectsFromYoungGen |= GC.enqueueMark(object.next);
        } else if (object.object != null) {
            object.next = firstWeakReference;
            firstWeakReference = object;
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean markReferenceQueue(RuntimeReferenceQueue object) {
        RuntimeReference reference = object.first;
        boolean hasObjectsFromYoungGen = false;
        if (reference != null) {
            hasObjectsFromYoungGen |= GC.enqueueMark(reference);
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean markFields(RuntimeClass cls, RuntimeObject object) {
        Address layout = cls.layout;
        if (layout == null) {
            return false;
        }
        boolean hasObjectsFromYoungGen = false;
        short fieldCount = layout.getShort();
        while (true) {
            short s = fieldCount;
            fieldCount = (short)(fieldCount - 1);
            if (s <= 0) break;
            layout = layout.add(2);
            short fieldOffset = layout.getShort();
            RuntimeObject reference = (RuntimeObject)object.toAddress().add(fieldOffset).getAddress().toStructure();
            hasObjectsFromYoungGen |= GC.enqueueMark(reference);
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean markArray(RuntimeClass cls, RuntimeArray array) {
        if ((cls.itemType.flags & 2) != 0) {
            return false;
        }
        Address base = Address.align(array.toAddress().add(RuntimeArray.class, 1), Address.sizeOf());
        boolean hasObjectsFromYoungGen = false;
        for (int i = 0; i < array.size; ++i) {
            RuntimeObject reference = (RuntimeObject)base.getAddress().toStructure();
            hasObjectsFromYoungGen |= GC.enqueueMark(reference);
            base = base.add(Address.sizeOf());
        }
        return hasObjectsFromYoungGen;
    }

    private static boolean enqueueMark(RuntimeObject object) {
        if (object == null) {
            return false;
        }
        if (object.toAddress().toInt() < WasmHeap.heapAddress.toInt()) {
            return false;
        }
        if (!GC.isMarked(object)) {
            GC.doEnqueueMark(object);
            return true;
        }
        return true;
    }

    private static void doEnqueueMark(RuntimeObject object) {
        object.classReference |= Integer.MIN_VALUE;
        MarkQueue.enqueue(object);
    }

    private static void processReferences() {
        RuntimeReference reference = firstWeakReference;
        while (reference != null) {
            RuntimeReference next = reference.next;
            reference.next = null;
            if (!GC.isMarked(reference.object)) {
                reference.object = null;
                RuntimeReferenceQueue queue = reference.queue;
                if (queue != null) {
                    if (queue.first == null) {
                        queue.first = reference;
                    } else {
                        queue.last.next = reference;
                        GC.makeInvalid(queue.last);
                    }
                    queue.last = reference;
                    GC.makeInvalid(queue);
                }
            }
            reference = next;
        }
    }

    private static void makeInvalid(RuntimeObject object) {
    }

    public static boolean isAvailableSpaceAddress(Address address) {
        FreeChunk object = (FreeChunk)GC.heapAddress().toStructure();
        long heapSize = GC.availableBytes();
        Address limit = GC.heapAddress().add(heapSize);
        while (object.toAddress().isLessThan(limit)) {
            int size = GC.objectSize(object);
            if (object.classReference == 0 && object.toAddress().toInt() <= address.toInt() && object.toAddress().toInt() + size > address.toInt()) {
                return true;
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        return false;
    }

    private static void sweep() {
        MemoryTrace.sweepStarted();
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        freeChunks = 0;
        totalChunks = 0;
        FreeChunk object = (FreeChunk)GC.heapAddress().toStructure();
        FreeChunk lastFreeSpace = null;
        long heapSize = GC.availableBytes();
        Address limit = GC.heapAddress().add(heapSize);
        while (object.toAddress().isLessThan(limit)) {
            int size;
            boolean free;
            int tag = object.classReference;
            if (tag == 0) {
                free = true;
            } else {
                boolean bl = free = (tag & Integer.MIN_VALUE) == 0;
                if (!free) {
                    tag &= Integer.MAX_VALUE;
                }
                object.classReference = tag;
            }
            if (free) {
                if (lastFreeSpace == null) {
                    lastFreeSpace = object;
                }
            } else if (lastFreeSpace != null) {
                GC.freeMemory(lastFreeSpace, object);
                lastFreeSpace = null;
            }
            if ((size = GC.objectSize(object)) == 0) {
                WasmRuntime.abortDirectly();
                break;
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        if (lastFreeSpace != null) {
            GC.freeMemory(lastFreeSpace, object);
        }
        GC.freeAllFreeChunks();
        MemoryTrace.sweepCompleted();
    }

    private static void freeAllFreeChunks() {
        FreeChunk pointer = (FreeChunk)WasmHeap.heapAddress.toStructure();
        int heapEnd = WasmHeap.storageAddress.toInt();
        freeChunks = 0;
        while (pointer.toAddress().toInt() < heapEnd) {
            if (pointer.classReference == 0) {
                ++freeChunks;
                GC.currentChunkPointer.value = pointer;
                currentChunkPointer = Structure.add(FreeChunkHolder.class, currentChunkPointer, 1);
            }
            pointer = (FreeChunk)pointer.toAddress().add(GC.objectSize(pointer)).toStructure();
        }
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
    }

    private static void freeMemory(FreeChunk from, FreeChunk to) {
        from.classReference = 0;
        from.size = (int)(to.toAddress().toLong() - from.toAddress().toLong());
        MemoryTrace.free(from.toAddress(), from.size);
        GC.currentChunkPointer.value = from;
        currentChunkPointer = Structure.add(FreeChunkHolder.class, currentChunkPointer, 1);
        lastChunk = from;
        ++freeChunks;
        ++totalChunks;
    }

    private static void updateFreeMemory() {
        freeMemory = 0;
        FreeChunkHolder freeChunkPtr = currentChunkPointer;
        for (int i = 0; i < freeChunks; ++i) {
            freeMemory += freeChunkPtr.value.size;
            freeChunkPtr = Structure.add(FreeChunkHolder.class, freeChunkPtr, 1);
        }
    }

    private static void resizeHeapConsistent(long newSize) {
        long oldSize = GC.availableBytes();
        if (newSize <= oldSize) {
            return;
        }
        int oldHeapSize = WasmHeap.heapSize;
        GC.resizeHeap(newSize);
        int newHeapSize = WasmHeap.heapSize;
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        if (GC.lastChunk.classReference == 0) {
            GC.lastChunk.size += newHeapSize - oldHeapSize;
        } else {
            int size = GC.objectSize(lastChunk);
            lastChunk = (FreeChunk)lastChunk.toAddress().add(size).toStructure();
            GC.lastChunk.classReference = 0;
            GC.lastChunk.size = newHeapSize - oldHeapSize;
            Structure.add(FreeChunkHolder.class, GC.currentChunkPointer, (int)GC.freeChunks).value = lastChunk;
            ++freeChunks;
            ++totalChunks;
        }
        currentChunk = GC.currentChunkPointer.value;
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
    }

    private static void resizeHeapIfNecessary(int size) {
        long minRequestedSize = 0L;
        if (!GC.hasAvailableChunk(size)) {
            minRequestedSize = GC.computeMinRequestedSize(size);
        }
        long requestedSize = minRequestedSize;
        long availableBytes = GC.availableBytes();
        long occupiedMemory = availableBytes - (long)freeMemory;
        if (GC.isAboutToExpand(requestedSize)) {
            long maxSize;
            long newSize = GC.max(requestedSize, availableBytes * 2L);
            if (newSize >= (maxSize = GC.maxAvailableBytes()) / 3L) {
                newSize = maxSize;
            }
            if (newSize != availableBytes) {
                if (newSize % 8L != 0L) {
                    newSize += 8L - newSize % 8L;
                }
                GC.resizeHeapConsistent(newSize);
            }
        } else if (occupiedMemory < availableBytes / 4L) {
            long newSize = occupiedMemory * 3L;
            if ((newSize = GC.max(newSize, GC.minAvailableBytes())) % 8L != 0L) {
                newSize -= newSize % 8L;
            }
            GC.resizeHeapConsistent(newSize);
        }
    }

    private static boolean isAboutToExpand(long requestedSize) {
        long availableBytes = GC.availableBytes();
        long occupiedMemory = availableBytes - (long)freeMemory;
        return requestedSize > availableBytes || occupiedMemory > availableBytes / 2L;
    }

    private static long min(long a, long b) {
        return a < b ? a : b;
    }

    private static long max(long a, long b) {
        return a > b ? a : b;
    }

    private static int objectSize(FreeChunk object) {
        if (object.classReference == 0) {
            return object.size;
        }
        RuntimeObject realObject = (RuntimeObject)object.toAddress().toStructure();
        RuntimeClass cls = RuntimeClass.getClass(realObject);
        return GC.objectSize(realObject, cls);
    }

    private static int objectSize(RuntimeObject object, RuntimeClass cls) {
        if (cls.itemType == null) {
            int clsDataSize = cls.size;
            if (clsDataSize < 8) {
                clsDataSize = 8;
            }
            return clsDataSize;
        }
        int itemSize = (cls.itemType.flags & 2) == 0 ? Address.sizeOf() : cls.itemType.size;
        RuntimeArray array = (RuntimeArray)object.toAddress().toStructure();
        Address address = Address.fromInt(Structure.sizeOf(RuntimeArray.class));
        address = Address.align(address, itemSize);
        address = address.add(itemSize * array.size);
        int clsDataSize = (address = Address.align(address, Address.sizeOf())).toInt();
        if (clsDataSize < 8) {
            clsDataSize = 8;
        }
        return clsDataSize;
    }

    private static boolean isMarked(RuntimeObject object) {
        return (object.classReference & Integer.MIN_VALUE) != 0;
    }

    static {
        freeMemory = (int)GC.availableBytes();
        currentChunk = (FreeChunk)GC.heapAddress().toStructure();
        GC.currentChunk.classReference = 0;
        GC.currentChunk.size = (int)GC.availableBytes();
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        GC.currentChunkPointer.value = currentChunk;
        lastChunk = currentChunk;
        freeChunks = 1;
        totalChunks = 1;
    }
}

