/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.runtime.ContractRuntimeException;
import com.antgroup.antchain.myjava.runtime.Identity;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class EVMParameter {
    public boolean hasFail = false;
    public String methodParams;
    private int paramNum = 0;
    Map<Integer, byte[]> staticParams = new LinkedHashMap<Integer, byte[]>();
    Map<Integer, byte[]> dynamicParams = new LinkedHashMap<Integer, byte[]>();

    private static byte[] long2Bytes(long value) {
        byte[] ret = new byte[32];
        int len = 8;
        byte[] tmp = ByteBuffer.allocate(len).putLong(value).array();
        System.arraycopy(tmp, 0, ret, 32 - len, len);
        return ret;
    }

    public void setFunctionSelector(String methodParams) {
        if (methodParams.length() != 0) {
            this.methodParams = methodParams;
        }
    }

    public byte[] getData() {
        ArrayList<byte[]> tmp = new ArrayList<byte[]>();
        int offset = (this.staticParams.size() + this.dynamicParams.size()) * 32;
        int totalLen = 0;
        for (int i = 0; i < this.paramNum; ++i) {
            if (this.staticParams.containsKey(i)) {
                byte[] tmpBytes = this.staticParams.get(i);
                tmp.add(tmpBytes);
                totalLen += tmpBytes.length;
                continue;
            }
            byte[] offsetBytes = EVMParameter.long2Bytes(offset);
            tmp.add(offsetBytes);
            totalLen += offsetBytes.length;
            offset += this.dynamicParams.get(i).length;
        }
        for (byte[] value : this.dynamicParams.values()) {
            tmp.add(value);
            totalLen += value.length;
        }
        byte[] data = new byte[totalLen];
        int pos = 0;
        for (byte[] item : tmp) {
            System.arraycopy(item, 0, data, pos, item.length);
            pos += item.length;
        }
        return data;
    }

    public void addLong(long value) {
        byte[] tmp = EVMParameter.long2Bytes(value);
        this.staticParams.put(this.paramNum++, tmp);
    }

    public void addBool(boolean value) {
        byte[] tmp = new byte[32];
        tmp[31] = value ? (byte)1 : 0;
        this.staticParams.put(this.paramNum++, tmp);
    }

    public void addIdentity(Identity value) {
        byte[] tmp = value.getData();
        this.staticParams.put(this.paramNum++, tmp);
    }

    public void addString(String value) {
        byte[] lenBytes = EVMParameter.long2Bytes(value.length());
        int dataLen = lenBytes.length + (value.length() + 31) / 32 * 32;
        byte[] data = new byte[dataLen];
        System.arraycopy(lenBytes, 0, data, 0, 32);
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        System.arraycopy(valueBytes, 0, data, 32, valueBytes.length);
        this.dynamicParams.put(this.paramNum++, data);
    }

    public void addBytes(byte[] value) {
        byte[] lenBytes = EVMParameter.long2Bytes(value.length);
        int dataLen = lenBytes.length + (value.length + 31) / 32 * 32;
        byte[] data = new byte[dataLen];
        System.arraycopy(lenBytes, 0, data, 0, 32);
        System.arraycopy(value, 0, data, 32, value.length);
        this.dynamicParams.put(this.paramNum++, data);
    }

    public void addBytesN(byte[] value) {
        if (value.length > 32) {
            throw new ContractRuntimeException("The length of bytes exceeds 32 bytes.");
        }
        byte[] tmp = new byte[32];
        System.arraycopy(value, 0, tmp, 0, value.length);
        this.staticParams.put(this.paramNum++, tmp);
    }

    public void addLongArray(long[] value) {
        int valueLen = value.length;
        byte[] data = new byte[(valueLen + 1) * 32];
        byte[] lenBytes = EVMParameter.long2Bytes(valueLen);
        System.arraycopy(lenBytes, 0, data, 0, 32);
        int pos = 32;
        for (int i = 0; i < valueLen; ++i) {
            byte[] tmp = EVMParameter.long2Bytes(value[i]);
            System.arraycopy(tmp, 0, data, pos, 32);
            pos += 32;
        }
        this.dynamicParams.put(this.paramNum++, data);
    }

    public void addBoolArray(boolean[] value) {
        int valueLen = value.length;
        byte[] data = new byte[(valueLen + 1) * 32];
        byte[] lenBytes = EVMParameter.long2Bytes(valueLen);
        System.arraycopy(lenBytes, 0, data, 0, 32);
        int pos = 32;
        for (int i = 0; i < valueLen; ++i) {
            byte[] tmp = new byte[32];
            tmp = value[i] ? EVMParameter.long2Bytes(1L) : EVMParameter.long2Bytes(0L);
            System.arraycopy(tmp, 0, data, pos, 32);
            pos += 32;
        }
        this.dynamicParams.put(this.paramNum++, data);
    }

    public void addBytesNArray(byte[][] value) {
        int valueLen = value.length;
        byte[] tmp = new byte[(valueLen + 1) * 32];
        byte[] lenBytes = EVMParameter.long2Bytes(valueLen);
        System.arraycopy(lenBytes, 0, tmp, 0, 32);
        for (int i = 0; i < value.length; ++i) {
            if (value[i].length > 32) {
                MychainLib.revertString("item exceeds 32 bytes");
            }
            System.arraycopy(value[i], 0, tmp, (i + 1) * 32, value[i].length);
        }
        this.dynamicParams.put(this.paramNum++, tmp);
    }

    public void addStringArray(String[] value) {
        int itemLen;
        int valueLen = value.length;
        byte[] lenBytes = EVMParameter.long2Bytes(valueLen);
        int totalLen = (1 + valueLen) * 32;
        for (String item : value) {
            itemLen = (item.length() + 31) / 32;
            totalLen += (1 + itemLen) * 32;
        }
        byte[] data = new byte[totalLen];
        System.arraycopy(lenBytes, 0, data, 0, 32);
        int offset = 32 * valueLen;
        for (int i = 0; i < valueLen; ++i) {
            String item;
            item = value[i];
            itemLen = (item.length() + 31) / 32;
            byte[] offsetBytes = EVMParameter.long2Bytes(offset);
            System.arraycopy(offsetBytes, 0, data, 32 * (i + 1), 32);
            System.arraycopy(EVMParameter.long2Bytes(itemLen), 0, data, offset + 32, 32);
            byte[] itemBytes = item.getBytes(StandardCharsets.UTF_8);
            System.arraycopy(itemBytes, 0, data, offset + 64, itemBytes.length);
            offset += 32 * (1 + itemLen);
        }
        this.dynamicParams.put(this.paramNum++, data);
    }
}

