/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.parsing.substitution;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ClassExclusions
implements Function<String, Boolean> {
    private final Map<String, Boolean> classExclusions = new HashMap<String, Boolean>();
    private Boolean isExcluded;
    private Boolean isSubpackagesExcluded;
    private final Map<String, ClassExclusions> subExclusions = new HashMap<String, ClassExclusions>();

    @Override
    public Boolean apply(String className) {
        return this.isExcluded(className.split("\\.")) == Boolean.TRUE;
    }

    public void setPackageHierarchyExclusion(String[] packageNameSegments, boolean isExcluded) {
        if (packageNameSegments == null || packageNameSegments.length < 1) {
            this.isSubpackagesExcluded = isExcluded;
            return;
        }
        this.subExclusions.computeIfAbsent(packageNameSegments[0], packageName -> new ClassExclusions()).setPackageHierarchyExclusion(Arrays.copyOfRange(packageNameSegments, 1, packageNameSegments.length), isExcluded);
    }

    public void setPackageExclusion(String[] packageNameSegments, boolean isExcluded) {
        if (packageNameSegments == null || packageNameSegments.length < 1) {
            this.isExcluded = isExcluded;
            return;
        }
        this.subExclusions.computeIfAbsent(packageNameSegments[0], packageName -> new ClassExclusions()).setPackageExclusion(Arrays.copyOfRange(packageNameSegments, 1, packageNameSegments.length), isExcluded);
    }

    public void setClassExclusion(String[] classNameSegments, boolean isExcluded) {
        if (classNameSegments == null || classNameSegments.length < 1) {
            return;
        }
        if (classNameSegments.length == 1) {
            this.classExclusions.put(classNameSegments[0], isExcluded);
        } else {
            this.subExclusions.computeIfAbsent(classNameSegments[0], packageName -> new ClassExclusions()).setClassExclusion(Arrays.copyOfRange(classNameSegments, 1, classNameSegments.length), isExcluded);
        }
    }

    private Boolean isExcluded(String[] classNameSegments) {
        if (classNameSegments == null || classNameSegments.length < 1) {
            return this.isExcluded;
        }
        if (classNameSegments.length == 1) {
            Boolean isClassExcluded = this.classExclusions.get(classNameSegments[0]);
            return isClassExcluded != null ? isClassExcluded : (this.isExcluded != null ? this.isExcluded : this.isSubpackagesExcluded);
        }
        ClassExclusions subPackageExclusions = this.subExclusions.get(classNameSegments[0]);
        if (subPackageExclusions != null) {
            Boolean isExcluded = subPackageExclusions.isExcluded(Arrays.copyOfRange(classNameSegments, 1, classNameSegments.length));
            return isExcluded != null ? isExcluded : this.isSubpackagesExcluded;
        }
        return this.isSubpackagesExcluded;
    }
}

