/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.model.InvokeDynamicInstruction;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.ArrayLengthInstruction;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryBranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BoundCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.BranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastIntegerInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastNumberInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.EmptyInstruction;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.IsInstanceInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorEnterInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.NegateInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.RaiseInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchInstruction;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;

public class UsageExtractor
implements InstructionVisitor {
    private Variable[] usedVariables;

    public Variable[] getUsedVariables() {
        return this.usedVariables;
    }

    @Override
    public void visit(EmptyInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(ClassConstantInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(NullConstantInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(IntegerConstantInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(LongConstantInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(FloatConstantInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(DoubleConstantInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(StringConstantInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(BinaryInstruction insn) {
        this.usedVariables = new Variable[]{insn.getFirstOperand(), insn.getSecondOperand()};
    }

    @Override
    public void visit(NegateInstruction insn) {
        this.usedVariables = new Variable[]{insn.getOperand()};
    }

    @Override
    public void visit(AssignInstruction insn) {
        this.usedVariables = new Variable[]{insn.getAssignee()};
    }

    @Override
    public void visit(CastInstruction insn) {
        this.usedVariables = new Variable[]{insn.getValue()};
    }

    @Override
    public void visit(CastNumberInstruction insn) {
        this.usedVariables = new Variable[]{insn.getValue()};
    }

    @Override
    public void visit(CastIntegerInstruction insn) {
        this.usedVariables = new Variable[]{insn.getValue()};
    }

    @Override
    public void visit(BranchingInstruction insn) {
        this.usedVariables = new Variable[]{insn.getOperand()};
    }

    @Override
    public void visit(BinaryBranchingInstruction insn) {
        this.usedVariables = new Variable[]{insn.getFirstOperand(), insn.getSecondOperand()};
    }

    @Override
    public void visit(JumpInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(SwitchInstruction insn) {
        this.usedVariables = new Variable[]{insn.getCondition()};
    }

    @Override
    public void visit(ExitInstruction insn) {
        Variable[] variableArray;
        if (insn.getValueToReturn() != null) {
            Variable[] variableArray2 = new Variable[1];
            variableArray = variableArray2;
            variableArray2[0] = insn.getValueToReturn();
        } else {
            variableArray = new Variable[]{};
        }
        this.usedVariables = variableArray;
    }

    @Override
    public void visit(RaiseInstruction insn) {
        this.usedVariables = new Variable[]{insn.getException()};
    }

    @Override
    public void visit(ConstructArrayInstruction insn) {
        this.usedVariables = new Variable[]{insn.getSize()};
    }

    @Override
    public void visit(ConstructInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(ConstructMultiArrayInstruction insn) {
        this.usedVariables = insn.getDimensions().toArray(new Variable[0]);
    }

    @Override
    public void visit(GetFieldInstruction insn) {
        Variable[] variableArray;
        if (insn.getInstance() != null) {
            Variable[] variableArray2 = new Variable[1];
            variableArray = variableArray2;
            variableArray2[0] = insn.getInstance();
        } else {
            variableArray = new Variable[]{};
        }
        this.usedVariables = variableArray;
    }

    @Override
    public void visit(PutFieldInstruction insn) {
        Variable[] variableArray;
        if (insn.getInstance() != null) {
            Variable[] variableArray2 = new Variable[2];
            variableArray2[0] = insn.getInstance();
            variableArray = variableArray2;
            variableArray2[1] = insn.getValue();
        } else {
            Variable[] variableArray3 = new Variable[1];
            variableArray = variableArray3;
            variableArray3[0] = insn.getValue();
        }
        this.usedVariables = variableArray;
    }

    @Override
    public void visit(ArrayLengthInstruction insn) {
        this.usedVariables = new Variable[]{insn.getArray()};
    }

    @Override
    public void visit(CloneArrayInstruction insn) {
        this.usedVariables = new Variable[]{insn.getArray()};
    }

    @Override
    public void visit(UnwrapArrayInstruction insn) {
        this.usedVariables = new Variable[]{insn.getArray()};
    }

    @Override
    public void visit(GetElementInstruction insn) {
        this.usedVariables = new Variable[]{insn.getArray(), insn.getIndex()};
    }

    @Override
    public void visit(PutElementInstruction insn) {
        this.usedVariables = new Variable[]{insn.getArray(), insn.getIndex(), insn.getValue()};
    }

    @Override
    public void visit(InvokeInstruction insn) {
        if (insn.getInstance() != null) {
            this.usedVariables = new Variable[insn.getArguments().size() + 1];
            insn.getArguments().toArray(this.usedVariables);
            this.usedVariables[insn.getArguments().size()] = insn.getInstance();
        } else {
            this.usedVariables = new Variable[insn.getArguments().size()];
            insn.getArguments().toArray(this.usedVariables);
        }
    }

    @Override
    public void visit(InvokeDynamicInstruction insn) {
        if (insn.getInstance() != null) {
            this.usedVariables = new Variable[insn.getArguments().size() + 1];
            insn.getArguments().toArray(this.usedVariables);
            this.usedVariables[insn.getArguments().size()] = insn.getInstance();
        } else {
            this.usedVariables = new Variable[insn.getArguments().size()];
            insn.getArguments().toArray(this.usedVariables);
        }
    }

    @Override
    public void visit(IsInstanceInstruction insn) {
        this.usedVariables = new Variable[]{insn.getValue()};
    }

    @Override
    public void visit(InitClassInstruction insn) {
        this.usedVariables = new Variable[0];
    }

    @Override
    public void visit(NullCheckInstruction insn) {
        this.usedVariables = new Variable[]{insn.getValue()};
    }

    @Override
    public void visit(MonitorEnterInstruction insn) {
        this.usedVariables = new Variable[]{insn.getObjectRef()};
    }

    @Override
    public void visit(MonitorExitInstruction insn) {
        this.usedVariables = new Variable[]{insn.getObjectRef()};
    }

    @Override
    public void visit(BoundCheckInstruction insn) {
        this.usedVariables = insn.getArray() != null ? new Variable[]{insn.getArray(), insn.getIndex()} : new Variable[]{insn.getIndex()};
    }
}

