/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.InvokeDynamicInstruction;
import com.antgroup.antchain.myjava.model.instructions.ArrayLengthInstruction;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryBranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BoundCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.BranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastIntegerInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastNumberInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.EmptyInstruction;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.IsInstanceInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorEnterInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.NegateInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.RaiseInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchTableEntry;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;
import java.util.List;

public class TransitionExtractor
implements InstructionVisitor {
    private BasicBlock[] targets;

    public BasicBlock[] getTargets() {
        return this.targets;
    }

    @Override
    public void visit(EmptyInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(ClassConstantInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(NullConstantInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(IntegerConstantInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(LongConstantInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(FloatConstantInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(DoubleConstantInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(StringConstantInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(BinaryInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(NegateInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(AssignInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(BranchingInstruction insn) {
        this.targets = new BasicBlock[]{insn.getConsequent(), insn.getAlternative()};
    }

    @Override
    public void visit(BinaryBranchingInstruction insn) {
        this.targets = new BasicBlock[]{insn.getConsequent(), insn.getAlternative()};
    }

    @Override
    public void visit(JumpInstruction insn) {
        this.targets = new BasicBlock[]{insn.getTarget()};
    }

    @Override
    public void visit(SwitchInstruction insn) {
        List<SwitchTableEntry> entries = insn.getEntries();
        this.targets = new BasicBlock[entries.size() + 1];
        for (int i = 0; i < entries.size(); ++i) {
            this.targets[i] = entries.get(i).getTarget();
        }
        this.targets[entries.size()] = insn.getDefaultTarget();
    }

    @Override
    public void visit(ExitInstruction insn) {
        this.targets = new BasicBlock[0];
    }

    @Override
    public void visit(RaiseInstruction insn) {
        this.targets = new BasicBlock[0];
    }

    @Override
    public void visit(ConstructArrayInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(ConstructInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(ConstructMultiArrayInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(GetFieldInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(PutFieldInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(GetElementInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(PutElementInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(InvokeInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(InvokeDynamicInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(IsInstanceInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(CastInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(CastNumberInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(CastIntegerInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(ArrayLengthInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(UnwrapArrayInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(CloneArrayInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(InitClassInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(NullCheckInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(MonitorEnterInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(MonitorExitInstruction insn) {
        this.targets = null;
    }

    @Override
    public void visit(BoundCheckInstruction insn) {
        this.targets = null;
    }
}

