/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.dependency.DependencyInfo;
import com.antgroup.antchain.myjava.dependency.MethodDependencyInfo;
import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.interop.SupportedOn;
import com.antgroup.antchain.myjava.interop.UnsupportedOn;
import com.antgroup.antchain.myjava.model.AnnotationContainerReader;
import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.model.TryCatchBlock;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.IsInstanceInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.RaiseInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.optimization.UnreachableBasicBlockEliminator;
import com.antgroup.antchain.myjava.model.util.TransitionExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MissingItemsProcessor {
    private DependencyInfo dependencyInfo;
    private ClassHierarchy hierarchy;
    private Diagnostics diagnostics;
    private List<Instruction> instructionsToAdd = new ArrayList<Instruction>();
    private MethodReference methodRef;
    private Program program;
    private Collection<String> reachableClasses;
    private Collection<MethodReference> reachableMethods;
    private Collection<FieldReference> reachableFields;
    private Set<String> platformTags = new HashSet<String>();
    private InstructionVisitor instructionProcessor = new AbstractInstructionVisitor(){

        @Override
        public void visit(InitClassInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getClassName());
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getType());
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getType() != InvocationType.VIRTUAL) {
                MissingItemsProcessor.this.checkMethod(insn.getLocation(), insn.getMethod());
            } else {
                MissingItemsProcessor.this.checkVirtualMethod(insn.getLocation(), insn.getMethod());
            }
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            MissingItemsProcessor.this.checkField(insn.getLocation(), insn.getField());
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            MissingItemsProcessor.this.checkField(insn.getLocation(), insn.getField());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getItemType());
        }

        @Override
        public void visit(ConstructInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getType());
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getItemType());
        }

        @Override
        public void visit(CastInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getTargetType());
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getConstant());
        }
    };

    public MissingItemsProcessor(DependencyInfo dependencyInfo, ClassHierarchy hierarchy, Diagnostics diagnostics, String[] platformTags) {
        this.dependencyInfo = dependencyInfo;
        this.diagnostics = diagnostics;
        this.hierarchy = hierarchy;
        this.reachableClasses = dependencyInfo.getReachableClasses();
        this.reachableMethods = dependencyInfo.getReachableMethods();
        this.reachableFields = dependencyInfo.getReachableFields();
        this.platformTags.addAll(Arrays.asList(platformTags));
    }

    public void processClass(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods()) {
            if (!this.reachableMethods.contains(method.getReference()) || method.getProgram() == null) continue;
            this.processMethod(method);
        }
    }

    public void processMethod(MethodHolder method) {
        this.processMethod(method.getReference(), method.getProgram());
    }

    public void processMethod(MethodReference method, Program program) {
        this.methodRef = method;
        this.program = program;
        boolean wasModified = false;
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            this.instructionsToAdd.clear();
            boolean missing = false;
            for (Instruction insn : block) {
                insn.acceptVisitor(this.instructionProcessor);
                if (this.instructionsToAdd.isEmpty()) continue;
                wasModified = true;
                this.truncateBlock(insn);
                missing = true;
                break;
            }
            if (missing) continue;
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                this.checkClass(null, tryCatch.getExceptionType());
            }
        }
        if (wasModified) {
            new UnreachableBasicBlockEliminator().optimize(program);
        }
    }

    private void truncateBlock(Instruction instruction) {
        TransitionExtractor transitionExtractor = new TransitionExtractor();
        BasicBlock block = instruction.getBasicBlock();
        if (block.getLastInstruction() != null) {
            block.getLastInstruction().acceptVisitor(transitionExtractor);
        }
        for (BasicBlock successor : transitionExtractor.getTargets()) {
            successor.removeIncomingsFrom(block);
        }
        while (instruction.getNext() != null) {
            instruction.getNext().delete();
        }
        instruction.insertNextAll(this.instructionsToAdd);
        instruction.delete();
    }

    private void emitExceptionThrow(TextLocation location, String exceptionName, String text) {
        Variable exceptionVar = this.program.createVariable();
        ConstructInstruction newExceptionInsn = new ConstructInstruction();
        newExceptionInsn.setType(exceptionName);
        newExceptionInsn.setReceiver(exceptionVar);
        newExceptionInsn.setLocation(location);
        this.instructionsToAdd.add(newExceptionInsn);
        Variable constVar = this.program.createVariable();
        StringConstantInstruction constInsn = new StringConstantInstruction();
        constInsn.setConstant(text);
        constInsn.setReceiver(constVar);
        constInsn.setLocation(location);
        this.instructionsToAdd.add(constInsn);
        InvokeInstruction initExceptionInsn = new InvokeInstruction();
        initExceptionInsn.setInstance(exceptionVar);
        initExceptionInsn.setMethod(new MethodReference(exceptionName, "<init>", ValueType.object("java.lang.String"), ValueType.VOID));
        initExceptionInsn.setType(InvocationType.SPECIAL);
        initExceptionInsn.setArguments(constVar);
        initExceptionInsn.setLocation(location);
        this.instructionsToAdd.add(initExceptionInsn);
        RaiseInstruction raiseInsn = new RaiseInstruction();
        raiseInsn.setException(exceptionVar);
        raiseInsn.setLocation(location);
        this.instructionsToAdd.add(raiseInsn);
    }

    private boolean checkClass(TextLocation location, String className) {
        if (!this.reachableClasses.contains(className)) {
            return false;
        }
        if (!this.dependencyInfo.getClass(className).isMissing()) {
            ClassReader cls = this.dependencyInfo.getClassSource().get(className);
            if (cls != null && !this.checkPlatformSupported(cls.getAnnotations())) {
                this.diagnostics.error(new CallLocation(this.methodRef, location), "Class {{c0}} is not supported on current target", className);
                this.emitExceptionThrow(location, NoClassDefFoundError.class.getName(), "Class not found: " + className);
                return false;
            }
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodRef, location), "Class {{c0}} was not found", className);
        this.emitExceptionThrow(location, NoClassDefFoundError.class.getName(), "Class not found: " + className);
        return false;
    }

    private boolean checkClass(TextLocation location, ValueType type) {
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            return this.checkClass(location, ((ValueType.Object)type).getClassName());
        }
        return true;
    }

    private boolean checkMethod(TextLocation location, MethodReference method) {
        if (!this.checkClass(location, method.getClassName())) {
            return false;
        }
        if (!this.reachableMethods.contains(method)) {
            return true;
        }
        MethodDependencyInfo methodDep = this.dependencyInfo.getMethod(method);
        if (!methodDep.isUsed()) {
            return true;
        }
        if (!methodDep.isMissing()) {
            MethodReader methodReader;
            ClassReader cls = this.dependencyInfo.getClassSource().get(method.getClassName());
            if (cls != null && (methodReader = cls.getMethod(method.getDescriptor())) != null && !this.checkPlatformSupported(methodReader.getAnnotations())) {
                this.diagnostics.error(new CallLocation(this.methodRef, location), "Method {{m0}} is not supported on current target", method);
                this.emitExceptionThrow(location, NoSuchMethodError.class.getName(), "Method not found: " + method);
                return false;
            }
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodRef, location), "Method {{m0}} was not found", method);
        this.emitExceptionThrow(location, NoSuchMethodError.class.getName(), "Method not found: " + method);
        return false;
    }

    private boolean checkVirtualMethod(TextLocation location, MethodReference method) {
        if (!this.checkClass(location, method.getClassName())) {
            return false;
        }
        if (this.hierarchy.resolve(method) != null) {
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodRef, location), "Method {{m0}} was not found", method);
        this.emitExceptionThrow(location, NoSuchMethodError.class.getName(), "Method not found: " + method);
        return true;
    }

    private boolean checkField(TextLocation location, FieldReference field) {
        if (!this.checkClass(location, field.getClassName())) {
            return false;
        }
        if (!this.reachableFields.contains(field) || !this.dependencyInfo.getField(field).isMissing()) {
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodRef, location), "Field {{f0}} was not found", field);
        this.emitExceptionThrow(location, NoSuchFieldError.class.getName(), "Field not found: " + field);
        return true;
    }

    private boolean checkPlatformSupported(AnnotationContainerReader annotations) {
        AnnotationReader supportedAnnot = annotations.get(SupportedOn.class.getName());
        AnnotationReader unsupportedAnnot = annotations.get(UnsupportedOn.class.getName());
        if (supportedAnnot != null) {
            for (AnnotationValue value : supportedAnnot.getValue("value").getList()) {
                if (!this.platformTags.contains(value.getString())) continue;
                return true;
            }
            return false;
        }
        if (unsupportedAnnot != null) {
            for (AnnotationValue value : unsupportedAnnot.getValue("value").getList()) {
                if (!this.platformTags.contains(value.getString())) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

