/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TryCatchBlock;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.BinaryBranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.BranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchTableEntry;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;

public class BasicBlockMapper
extends AbstractInstructionVisitor {
    private Function<BasicBlock, BasicBlock> mapFunction;

    public BasicBlockMapper(Function<BasicBlock, BasicBlock> mapFunction) {
        this.mapFunction = mapFunction;
    }

    public BasicBlockMapper(IntUnaryOperator mapFunction) {
        this((BasicBlock block) -> block.getProgram().basicBlockAt(mapFunction.applyAsInt(block.getIndex())));
    }

    private BasicBlock map(BasicBlock block) {
        return this.mapFunction.apply(block);
    }

    public void transform(Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            this.transform(program.basicBlockAt(i));
        }
    }

    public void transform(BasicBlock block) {
        this.transformWithoutPhis(block);
        for (Phi phi : block.getPhis()) {
            for (Incoming incoming : phi.getIncomings()) {
                incoming.setSource(this.map(incoming.getSource()));
            }
        }
    }

    public void transformWithoutPhis(BasicBlock block) {
        Instruction lastInsn = block.getLastInstruction();
        if (lastInsn != null) {
            lastInsn.acceptVisitor(this);
        }
        for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
            tryCatch.setHandler(this.map(tryCatch.getHandler()));
        }
    }

    @Override
    public void visit(BranchingInstruction insn) {
        insn.setConsequent(this.map(insn.getConsequent()));
        insn.setAlternative(this.map(insn.getAlternative()));
    }

    @Override
    public void visit(BinaryBranchingInstruction insn) {
        insn.setConsequent(this.map(insn.getConsequent()));
        insn.setAlternative(this.map(insn.getAlternative()));
    }

    @Override
    public void visit(JumpInstruction insn) {
        insn.setTarget(this.map(insn.getTarget()));
    }

    @Override
    public void visit(SwitchInstruction insn) {
        for (SwitchTableEntry entry : insn.getEntries()) {
            entry.setTarget(this.map(entry.getTarget()));
        }
        insn.setDefaultTarget(this.map(insn.getDefaultTarget()));
    }
}

