/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.transformation;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorEnterInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.RaiseInstruction;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;
import com.antgroup.antchain.myjava.model.transformation.NullCheckFilter;
import com.antgroup.antchain.myjava.model.util.DominatorWalker;
import com.antgroup.antchain.myjava.model.util.DominatorWalkerCallback;
import com.antgroup.antchain.myjava.model.util.PhiUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntSet;

public class NullCheckInsertion {
    private NullCheckFilter filter;

    public NullCheckInsertion(NullCheckFilter filter) {
        this.filter = filter;
    }

    public void transformProgram(Program program, MethodReference methodReference) {
        if (!this.filter.apply(methodReference) || program.basicBlockCount() == 0) {
            return;
        }
        InsertionVisitor visitor = new InsertionVisitor(program.variableCount());
        new DominatorWalker(program).walk(visitor);
        if (visitor.changed) {
            new PhiUpdater().updatePhis(program, methodReference.parameterCount() + 1);
        }
    }

    static class BlockNullness {
        IntSet notNullVariables = new IntHashSet();

        BlockNullness() {
        }
    }

    class InsertionVisitor
    extends AbstractInstructionVisitor
    implements DominatorWalkerCallback<BlockNullness> {
        boolean changed;
        boolean[] notNullVariables;
        BlockNullness blockNullness;

        InsertionVisitor(int variableCount) {
            this.notNullVariables = new boolean[variableCount];
            if (variableCount > 0) {
                this.notNullVariables[0] = true;
            }
        }

        @Override
        public BlockNullness visit(BasicBlock block) {
            this.blockNullness = new BlockNullness();
            if (block.getExceptionVariable() != null) {
                this.notNullVariables[block.getExceptionVariable().getIndex()] = true;
                this.blockNullness.notNullVariables.add(block.getExceptionVariable().getIndex());
            }
            for (Instruction instruction : block) {
                instruction.acceptVisitor(this);
            }
            return this.blockNullness;
        }

        @Override
        public void endVisit(BasicBlock block, BlockNullness state) {
            for (int variable : state.notNullVariables.toArray()) {
                this.notNullVariables[variable] = false;
            }
        }

        @Override
        public void visit(RaiseInstruction insn) {
            this.addGuard(insn, RaiseInstruction::getException, RaiseInstruction::setException);
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            if (NullCheckInsertion.this.filter.apply(insn.getField())) {
                this.addGuard(insn, GetFieldInstruction::getInstance, GetFieldInstruction::setInstance);
            }
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            if (NullCheckInsertion.this.filter.apply(insn.getField())) {
                this.addGuard(insn, PutFieldInstruction::getInstance, PutFieldInstruction::setInstance);
            }
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.addGuard(insn, CloneArrayInstruction::getArray, CloneArrayInstruction::setArray);
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            this.addGuard(insn, UnwrapArrayInstruction::getArray, UnwrapArrayInstruction::setArray);
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (NullCheckInsertion.this.filter.apply(insn.getMethod())) {
                this.addGuard(insn, InvokeInstruction::getInstance, InvokeInstruction::setInstance);
            }
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
            this.addGuard(insn, MonitorEnterInstruction::getObjectRef, MonitorEnterInstruction::setObjectRef);
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
            this.addGuard(insn, MonitorExitInstruction::getObjectRef, MonitorExitInstruction::setObjectRef);
        }

        private <T extends Instruction> void addGuard(T instruction, Function<T, Variable> get, BiConsumer<T, Variable> set) {
            Variable value = get.apply(instruction);
            if (value == null) {
                return;
            }
            if (this.notNullVariables[value.getIndex()]) {
                return;
            }
            this.notNullVariables[value.getIndex()] = true;
            this.blockNullness.notNullVariables.add(value.getIndex());
            NullCheckInstruction nullCheck = new NullCheckInstruction();
            nullCheck.setValue(value);
            nullCheck.setReceiver(value);
            nullCheck.setLocation(instruction.getLocation());
            set.accept(instruction, nullCheck.getReceiver());
            instruction.insertPrevious(nullCheck);
            this.changed = true;
        }
    }
}

