/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.transformation;

import com.antgroup.antchain.myjava.dependency.DependencyInfo;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.util.DominatorWalker;
import com.antgroup.antchain.myjava.model.util.DominatorWalkerCallback;
import com.antgroup.antchain.myjava.model.util.DominatorWalkerContext;
import java.util.HashSet;
import java.util.Set;

public class ClassInitInsertion {
    private static final MethodDescriptor CLINIT = new MethodDescriptor("<clinit>", Void.TYPE);
    private DependencyInfo dependencyInfo;

    public ClassInitInsertion(DependencyInfo dependencyInfo) {
        this.dependencyInfo = dependencyInfo;
    }

    public void apply(Program program, MethodReader method) {
        if (program.basicBlockCount() == 0) {
            return;
        }
        String currentClass = null;
        if (method.hasModifier(ElementModifier.STATIC)) {
            currentClass = method.getOwnerName();
        }
        Visitor visitor = new Visitor(currentClass);
        new DominatorWalker(program).walk(visitor);
    }

    static class State {
        Set<String> newInitializedClasses = new HashSet<String>();
        Set<String> oldInitializedClasses;

        State() {
        }
    }

    class Visitor
    extends AbstractInstructionVisitor
    implements DominatorWalkerCallback<State> {
        private String currentClass;
        private DominatorWalkerContext context;
        Set<String> initializedClasses = new HashSet<String>();
        private State state;

        Visitor(String currentClass) {
            this.currentClass = currentClass;
            if (currentClass != null) {
                this.initializedClasses.add(currentClass);
            }
        }

        @Override
        public void setContext(DominatorWalkerContext context) {
            this.context = context;
        }

        @Override
        public State visit(BasicBlock block) {
            this.state = new State();
            if (this.context.isExceptionHandler(block.getIndex())) {
                this.markAllClassesAsNotInitialized();
                if (this.currentClass != null) {
                    this.markClassAsInitialized(this.currentClass);
                }
            }
            for (Instruction instruction : block) {
                instruction.acceptVisitor(this);
            }
            return this.state;
        }

        @Override
        public void endVisit(BasicBlock block, State state) {
            if (state.oldInitializedClasses != null) {
                this.initializedClasses.clear();
                this.initializedClasses.addAll(state.oldInitializedClasses);
            } else {
                this.initializedClasses.removeAll(state.newInitializedClasses);
            }
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            if (insn.getInstance() == null) {
                this.initializeClass(insn.getField().getClassName(), insn);
            }
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            if (insn.getInstance() == null) {
                this.initializeClass(insn.getField().getClassName(), insn);
            }
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getInstance() == null) {
                this.markClassAsInitialized(insn.getMethod().getClassName());
            }
        }

        @Override
        public void visit(InitClassInstruction insn) {
            this.markClassAsInitialized(insn.getClassName());
        }

        private void initializeClass(String className, Instruction instruction) {
            ClassReader cls;
            if (this.markClassAsInitialized(className) && ((cls = ClassInitInsertion.this.dependencyInfo.getClassSource().get(className)) == null || cls.getMethod(CLINIT) != null)) {
                InitClassInstruction initInsn = new InitClassInstruction();
                initInsn.setClassName(className);
                initInsn.setLocation(instruction.getLocation());
                instruction.insertPrevious(initInsn);
            }
        }

        boolean markClassAsInitialized(String className) {
            if (this.initializedClasses.add(className)) {
                if (this.state.newInitializedClasses != null) {
                    this.state.newInitializedClasses.add(className);
                }
                return true;
            }
            return false;
        }

        private void markAllClassesAsNotInitialized() {
            if (this.state.newInitializedClasses != null) {
                this.state.oldInitializedClasses = new HashSet<String>();
                for (String className : this.initializedClasses) {
                    if (this.state.newInitializedClasses.contains(className)) continue;
                    this.state.oldInitializedClasses.add(className);
                }
                this.state.newInitializedClasses = null;
            }
            this.initializedClasses.clear();
        }
    }
}

