/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.GraphBuilder;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.ArrayLengthInstruction;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BoundCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastIntegerInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastNumberInstruction;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.IsInstanceInstruction;
import com.antgroup.antchain.myjava.model.instructions.NegateInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;

public final class VariableUsageGraphBuilder {
    private VariableUsageGraphBuilder() {
    }

    public static Graph build(Program program) {
        GraphBuilder builder = new GraphBuilder(program.variableCount());
        InstructionAnalyzer analyzer = new InstructionAnalyzer(builder);
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                insn.acceptVisitor(analyzer);
            }
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    builder.addEdge(incoming.getValue().getIndex(), phi.getReceiver().getIndex());
                }
            }
        }
        return builder.build();
    }

    static class InstructionAnalyzer
    extends AbstractInstructionVisitor {
        private GraphBuilder builder;

        InstructionAnalyzer(GraphBuilder builder) {
            this.builder = builder;
        }

        private void use(Variable receiver, Variable ... arguments) {
            for (Variable arg : arguments) {
                this.builder.addEdge(arg.getIndex(), receiver.getIndex());
            }
        }

        @Override
        public void visit(BinaryInstruction insn) {
            this.use(insn.getReceiver(), insn.getFirstOperand(), insn.getSecondOperand());
        }

        @Override
        public void visit(NegateInstruction insn) {
            this.use(insn.getReceiver(), insn.getOperand());
        }

        @Override
        public void visit(AssignInstruction insn) {
            this.use(insn.getReceiver(), insn.getAssignee());
        }

        @Override
        public void visit(CastInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            this.use(insn.getReceiver(), insn.getSize());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            this.use(insn.getReceiver(), insn.getDimensions().toArray(new Variable[0]));
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            if (insn.getInstance() != null) {
                this.use(insn.getReceiver(), insn.getInstance());
            }
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            this.use(insn.getReceiver(), insn.getArray());
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.use(insn.getReceiver(), insn.getArray());
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            this.use(insn.getReceiver(), insn.getArray());
        }

        @Override
        public void visit(GetElementInstruction insn) {
            this.use(insn.getReceiver(), insn.getArray(), insn.getIndex());
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }

        @Override
        public void visit(BoundCheckInstruction insn) {
            if (insn.getArray() != null) {
                this.use(insn.getReceiver(), insn.getIndex(), insn.getArray());
            } else {
                this.use(insn.getReceiver(), insn.getIndex());
            }
        }
    }
}

