/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.analysis.NullnessInformation;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimization;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimizationContext;
import com.antgroup.antchain.myjava.model.optimization.UnreachableBasicBlockEliminator;
import com.antgroup.antchain.myjava.model.util.ProgramUtils;

public class RedundantNullCheckElimination
implements MethodOptimization {
    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        NullnessInformation nullness = NullnessInformation.build(program, context.getMethod().getDescriptor());
        boolean hasChanges = false;
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                NullCheckInstruction nullCheck;
                if (!(instruction instanceof NullCheckInstruction) || nullness.isSynthesized((nullCheck = (NullCheckInstruction)instruction).getReceiver())) continue;
                if (nullness.isNotNull(nullCheck.getValue())) {
                    AssignInstruction assign = new AssignInstruction();
                    assign.setAssignee(nullCheck.getValue());
                    assign.setReceiver(nullCheck.getReceiver());
                    assign.setLocation(nullCheck.getLocation());
                    nullCheck.replace(assign);
                    hasChanges = true;
                    continue;
                }
                if (!nullness.isNull(nullCheck.getValue())) continue;
                block.detachSuccessors();
                while (nullCheck.getNext() != null) {
                    nullCheck.getNext().delete();
                }
                nullCheck.insertPreviousAll(ProgramUtils.createThrowNPEInstructions(program, nullCheck.getLocation()));
                nullCheck.delete();
                hasChanges = true;
            }
        }
        if (hasChanges) {
            new UnreachableBasicBlockEliminator().optimize(program);
        }
        nullness.dispose();
        return hasChanges;
    }
}

