/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TryCatchBlock;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimization;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimizationContext;
import com.antgroup.antchain.myjava.model.util.ProgramUtils;
import com.antgroup.antchain.myjava.model.util.TransitionExtractor;
import java.util.Arrays;

public class RedundantJumpElimination
implements MethodOptimization {
    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        return RedundantJumpElimination.optimize(program);
    }

    public static boolean optimize(Program program) {
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        int[] incomingCount = new int[cfg.size()];
        Arrays.setAll(incomingCount, cfg::incomingEdgesCount);
        boolean changed = false;
        TransitionExtractor transitionExtractor = new TransitionExtractor();
        for (int i = 1; i < program.basicBlockCount(); ++i) {
            BasicBlock target;
            Instruction insn;
            BasicBlock block = program.basicBlockAt(i);
            if (block == null || !((insn = block.getLastInstruction()) instanceof JumpInstruction) || incomingCount[(target = ((JumpInstruction)insn).getTarget()).getIndex()] > 1 || !block.getTryCatchBlocks().isEmpty() || !target.getTryCatchBlocks().isEmpty()) continue;
            block.getLastInstruction().delete();
            for (Phi phi2 : target.getPhis()) {
                if (phi2.getIncomings().isEmpty()) continue;
                BasicBlock[] incoming2 = phi2.getIncomings().get(0);
                AssignInstruction assign = new AssignInstruction();
                assign.setReceiver(phi2.getReceiver());
                assign.setAssignee(incoming2.getValue());
                block.add(assign);
            }
            while (target.getFirstInstruction() != null) {
                Instruction instruction = target.getFirstInstruction();
                instruction.delete();
                block.add(instruction);
            }
            Instruction lastInsn = block.getLastInstruction();
            if (lastInsn != null) {
                lastInsn.acceptVisitor(transitionExtractor);
                BasicBlock[] successors = transitionExtractor.getTargets();
                if (successors != null) {
                    for (BasicBlock successor : successors) {
                        successor.getPhis().stream().flatMap(phi -> phi.getIncomings().stream()).filter(incoming -> incoming.getSource() == target).forEach(incoming -> incoming.setSource(block));
                    }
                }
            }
            for (TryCatchBlock tryCatch : target.getTryCatchBlocks()) {
                for (Phi phi3 : tryCatch.getHandler().getPhis()) {
                    phi3.getIncomings().removeIf(incoming -> incoming.getSource() == target);
                }
            }
            incomingCount[target.getIndex()] = 2;
            program.deleteBasicBlock(target.getIndex());
            --i;
            changed = true;
        }
        if (changed) {
            program.pack();
        }
        return changed;
    }
}

