/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.common.DominatorTree;
import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.GraphUtils;
import com.antgroup.antchain.myjava.common.Loop;
import com.antgroup.antchain.myjava.common.LoopGraph;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TryCatchBlock;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.analysis.NullnessInformation;
import com.antgroup.antchain.myjava.model.optimization.LoopInvariantAnalyzer;
import com.antgroup.antchain.myjava.model.util.BasicBlockMapper;
import com.antgroup.antchain.myjava.model.util.DefinitionExtractor;
import com.antgroup.antchain.myjava.model.util.InstructionCopyReader;
import com.antgroup.antchain.myjava.model.util.PhiUpdater;
import com.antgroup.antchain.myjava.model.util.ProgramUtils;
import com.antgroup.antchain.myjava.model.util.UsageExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntIntHashMap;
import org.teavm.hppc.IntIntMap;
import org.teavm.hppc.IntSet;

class LoopInversionImpl {
    private final Program program;
    private final MethodReference method;
    private final int parameterCount;
    private Graph cfg;
    private DominatorTree dom;
    private boolean postponed;
    private boolean changed;
    private BasicBlock[] definitionPlaces;
    private boolean affected;

    LoopInversionImpl(Program program, MethodReference method, int parameterCount) {
        this.program = program;
        this.method = method;
        this.parameterCount = parameterCount;
        this.definitionPlaces = ProgramUtils.getVariableDefinitionPlaces(program);
    }

    boolean apply() {
        do {
            this.cfg = ProgramUtils.buildControlFlowGraph(this.program);
            LoopGraph loopGraph = new LoopGraph(this.cfg);
            this.dom = GraphUtils.buildDominatorTree(this.cfg);
            List<LoopWithExits> loops = this.getLoopsWithExits(loopGraph);
            this.postponed = false;
            if (loops.isEmpty()) continue;
            for (LoopWithExits loop : loops) {
                loop.invert();
            }
            if (!this.changed) continue;
            this.affected = true;
            Variable[] inputs = new Variable[this.parameterCount];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = this.program.variableAt(i);
            }
            new PhiUpdater().updatePhis(this.program, inputs);
        } while (this.postponed);
        return this.affected;
    }

    private List<LoopWithExits> getLoopsWithExits(LoopGraph cfg) {
        HashMap<Loop, LoopWithExits> loops = new HashMap<Loop, LoopWithExits>();
        for (int node = 0; node < cfg.size(); ++node) {
            block1: for (Loop loop = cfg.loopAt(node); loop != null; loop = loop.getParent()) {
                LoopWithExits loopWithExits = this.getLoopWithExits(loops, loop);
                loopWithExits.nodes.add(node);
                for (int successor : cfg.outgoingEdges(node)) {
                    Loop successorLoop = cfg.loopAt(successor);
                    if (successorLoop != null && successorLoop.isChildOf(loop)) continue;
                    loopWithExits.exits.add(node);
                    continue block1;
                }
            }
        }
        ArrayList<LoopWithExits> resultList = new ArrayList<LoopWithExits>();
        HashSet<LoopWithExits> visited = new HashSet<LoopWithExits>();
        for (LoopWithExits loop : loops.values()) {
            this.sortLoops(loop, visited, resultList);
        }
        Collections.reverse(resultList);
        return resultList;
    }

    private LoopWithExits getLoopWithExits(Map<Loop, LoopWithExits> cache, Loop loop) {
        return cache.computeIfAbsent(loop, k -> {
            LoopWithExits parent = loop.getParent() != null ? this.getLoopWithExits(cache, loop.getParent()) : null;
            return new LoopWithExits(loop.getHead(), parent);
        });
    }

    private void sortLoops(LoopWithExits loop, Set<LoopWithExits> visited, List<LoopWithExits> target) {
        if (!visited.add(loop)) {
            return;
        }
        if (loop.parent != null) {
            this.sortLoops(loop.parent, visited, target);
        }
        target.add(loop);
    }

    private class LoopWithExits {
        final int head;
        final LoopWithExits parent;
        final IntSet nodes = new IntHashSet();
        final IntSet nodesAndCopies = new IntHashSet();
        final IntSet exits = new IntHashSet();
        int bodyStart;
        int headCopy;
        final IntIntMap copiedNodes = new IntIntHashMap();
        boolean shouldSkip;

        LoopWithExits(int head, LoopWithExits parent) {
            this.head = head;
            this.parent = parent;
        }

        void invert() {
            if (this.tryInvert()) {
                LoopWithExits ancestor = this.parent;
                while (ancestor != null) {
                    ancestor.shouldSkip = true;
                    ancestor = ancestor.parent;
                }
            }
        }

        private boolean tryInvert() {
            if (this.shouldSkip) {
                LoopInversionImpl.this.postponed = true;
                return false;
            }
            if (!this.findCondition() || this.bodyStart < 0) {
                return false;
            }
            IntSet nodesToCopy = this.nodesToCopy();
            NullnessInformation nullness = NullnessInformation.build(LoopInversionImpl.this.program, LoopInversionImpl.this.method.getDescriptor());
            boolean profitable = this.isInversionProfitable(nodesToCopy, nullness);
            nullness.dispose();
            if (!profitable) {
                return false;
            }
            this.copyBasicBlocks(nodesToCopy);
            this.copyCondition();
            this.moveBackEdges();
            this.removeInternalPhiInputsFromCondition();
            this.removeExternalPhiInputsFromConditionCopy();
            LoopInversionImpl.this.changed = true;
            return true;
        }

        private boolean isInversionProfitable(IntSet nodesToCopy, NullnessInformation nullness) {
            UsageExtractor useExtractor = new UsageExtractor();
            DefinitionExtractor defExtractor = new DefinitionExtractor();
            LoopInvariantAnalyzer invariantAnalyzer = new LoopInvariantAnalyzer(nullness);
            for (int node : this.nodes.toArray()) {
                if (nodesToCopy.contains(node)) continue;
                BasicBlock block = LoopInversionImpl.this.program.basicBlockAt(node);
                HashSet<Variable> currentInvariants = new HashSet<Variable>();
                for (Instruction insn : block) {
                    invariantAnalyzer.reset();
                    insn.acceptVisitor(invariantAnalyzer);
                    if (!invariantAnalyzer.canMove && !invariantAnalyzer.constant) continue;
                    insn.acceptVisitor(useExtractor);
                    boolean invariant = Arrays.stream(useExtractor.getUsedVariables()).allMatch(var -> {
                        if (currentInvariants.contains(var)) {
                            return true;
                        }
                        BasicBlock definedAt = var.getIndex() < LoopInversionImpl.this.definitionPlaces.length ? LoopInversionImpl.this.definitionPlaces[var.getIndex()] : null;
                        return definedAt == null || LoopInversionImpl.this.dom.dominates(definedAt.getIndex(), this.head);
                    });
                    if (!invariant) continue;
                    if (invariantAnalyzer.sideEffect) {
                        return true;
                    }
                    insn.acceptVisitor(defExtractor);
                    currentInvariants.addAll(Arrays.asList(defExtractor.getDefinedVariables()));
                }
            }
            return false;
        }

        private boolean findCondition() {
            IntHashSet tailNodes = new IntHashSet(LoopInversionImpl.this.program.basicBlockCount());
            for (int tailCandidate : LoopInversionImpl.this.cfg.incomingEdges(this.head)) {
                if (!this.nodes.contains(tailCandidate)) continue;
                tailNodes.add(tailCandidate);
            }
            int candidate = this.bodyStart = LoopInversionImpl.this.dom.commonDominatorOf(tailNodes.toArray());
            while (this.bodyStart != this.head) {
                int currentCandidate = candidate;
                if (Arrays.stream(this.exits.toArray()).anyMatch(exit -> LoopInversionImpl.this.dom.dominates(currentCandidate, exit))) break;
                this.bodyStart = candidate;
                candidate = LoopInversionImpl.this.dom.immediateDominatorOf(candidate);
            }
            return candidate != this.bodyStart;
        }

        private void copyBasicBlocks(IntSet nodesToCopy) {
            int[] nodes = this.nodes.toArray();
            Arrays.sort(nodes);
            for (int node : nodes) {
                this.nodesAndCopies.add(node);
                if (!nodesToCopy.contains(node)) continue;
                int copy = LoopInversionImpl.this.program.createBasicBlock().getIndex();
                if (this.head == node) {
                    this.headCopy = copy;
                }
                this.copiedNodes.put(node, copy);
                this.nodesAndCopies.add(copy);
            }
        }

        private IntSet nodesToCopy() {
            IntHashSet result = new IntHashSet();
            for (int node : this.nodes.toArray()) {
                if (node != this.head && (node == this.bodyStart || LoopInversionImpl.this.dom.dominates(this.bodyStart, node))) continue;
                result.add(node);
            }
            return result;
        }

        private void copyCondition() {
            BasicBlockMapper blockMapper = new BasicBlockMapper(block -> this.copiedNodes.getOrDefault(block, block));
            InstructionCopyReader copier = new InstructionCopyReader(LoopInversionImpl.this.program);
            for (int node : this.copiedNodes.keys().toArray()) {
                BasicBlock sourceBlock = LoopInversionImpl.this.program.basicBlockAt(node);
                BasicBlock targetBlock = LoopInversionImpl.this.program.basicBlockAt(this.copiedNodes.get(node));
                targetBlock.setExceptionVariable(sourceBlock.getExceptionVariable());
                copier.resetLocation();
                List<Instruction> instructionCopies = ProgramUtils.copyInstructions(sourceBlock.getFirstInstruction(), null, targetBlock.getProgram());
                for (Instruction insn : instructionCopies) {
                    insn.acceptVisitor(blockMapper);
                    targetBlock.add(insn);
                }
                for (Phi phi : sourceBlock.getPhis()) {
                    Phi phiCopy = new Phi();
                    phiCopy.setReceiver(phi.getReceiver());
                    for (Incoming incoming : phi.getIncomings()) {
                        Incoming incomingCopy = new Incoming();
                        int source = incoming.getSource().getIndex();
                        incomingCopy.setSource(LoopInversionImpl.this.program.basicBlockAt(this.copiedNodes.getOrDefault(source, source)));
                        incomingCopy.setValue(incoming.getValue());
                        phiCopy.getIncomings().add(incomingCopy);
                    }
                    targetBlock.getPhis().add(phiCopy);
                }
                for (TryCatchBlock tryCatch : sourceBlock.getTryCatchBlocks()) {
                    TryCatchBlock tryCatchCopy = new TryCatchBlock();
                    int handler = tryCatch.getHandler().getIndex();
                    tryCatchCopy.setExceptionType(tryCatch.getExceptionType());
                    tryCatchCopy.setHandler(LoopInversionImpl.this.program.basicBlockAt(this.copiedNodes.getOrDefault(handler, handler)));
                    targetBlock.getTryCatchBlocks().add(tryCatchCopy);
                }
            }
            for (int node = 0; node < LoopInversionImpl.this.cfg.size(); ++node) {
                BasicBlock block2 = LoopInversionImpl.this.program.basicBlockAt(node);
                if (this.copiedNodes.containsKey(block2.getIndex())) continue;
                for (Phi phi : block2.getPhis()) {
                    for (Incoming incoming : phi.getIncomings().toArray(new Incoming[0])) {
                        int source = incoming.getSource().getIndex();
                        if (!this.copiedNodes.containsKey(source)) continue;
                        Incoming incomingCopy = new Incoming();
                        incomingCopy.setValue(incoming.getValue());
                        incomingCopy.setSource(LoopInversionImpl.this.program.basicBlockAt(this.copiedNodes.get(source)));
                        phi.getIncomings().add(incomingCopy);
                    }
                }
            }
        }

        private void moveBackEdges() {
            BasicBlockMapper mapper = new BasicBlockMapper(block -> block == this.head ? this.headCopy : block);
            for (int node : this.nodes.toArray()) {
                BasicBlock block2 = LoopInversionImpl.this.program.basicBlockAt(node);
                Instruction last = block2.getLastInstruction();
                if (last == null) continue;
                last.acceptVisitor(mapper);
            }
        }

        private void removeInternalPhiInputsFromCondition() {
            BasicBlock block = LoopInversionImpl.this.program.basicBlockAt(this.head);
            for (Phi phi : block.getPhis()) {
                List<Incoming> incomings = phi.getIncomings();
                for (int i = 0; i < incomings.size(); ++i) {
                    Incoming incoming = incomings.get(i);
                    if (!this.nodes.contains(incoming.getSource().getIndex())) continue;
                    incomings.remove(i--);
                }
            }
        }

        private void removeExternalPhiInputsFromConditionCopy() {
            BasicBlock block = LoopInversionImpl.this.program.basicBlockAt(this.headCopy);
            for (Phi phi : block.getPhis()) {
                List<Incoming> incomings = phi.getIncomings();
                for (int i = 0; i < incomings.size(); ++i) {
                    Incoming incoming = incomings.get(i);
                    if (this.nodesAndCopies.contains(incoming.getSource().getIndex())) continue;
                    incomings.remove(i--);
                }
            }
        }
    }
}

