/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.common.DominatorTree;
import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.GraphUtils;
import com.antgroup.antchain.myjava.common.IntegerStack;
import com.antgroup.antchain.myjava.common.Loop;
import com.antgroup.antchain.myjava.common.LoopGraph;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.analysis.NullnessInformation;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.optimization.LoopInvariantAnalyzer;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimization;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimizationContext;
import com.antgroup.antchain.myjava.model.util.BasicBlockMapper;
import com.antgroup.antchain.myjava.model.util.ControlFlowUtils;
import com.antgroup.antchain.myjava.model.util.DefinitionExtractor;
import com.antgroup.antchain.myjava.model.util.InstructionVariableMapper;
import com.antgroup.antchain.myjava.model.util.ProgramUtils;
import com.antgroup.antchain.myjava.model.util.UsageExtractor;
import java.util.ArrayList;
import java.util.Arrays;

public class LoopInvariantMotion
implements MethodOptimization {
    private int[] preheaders;
    private LoopGraph graph;
    private DominatorTree dom;
    private Program program;

    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        int i;
        NullnessInformation nullness = NullnessInformation.build(program, context.getMethod().getDescriptor());
        boolean affected = false;
        this.program = program;
        this.graph = new LoopGraph(ProgramUtils.buildControlFlowGraph(program));
        this.dom = GraphUtils.buildDominatorTree(this.graph);
        Graph domGraph = GraphUtils.buildDominatorGraph(this.dom, this.graph.size());
        this.preheaders = new int[this.graph.size()];
        Arrays.fill(this.preheaders, -1);
        IntegerStack stack = new IntegerStack(this.graph.size());
        int[] defLocation = new int[program.variableCount()];
        Arrays.fill(defLocation, -1);
        Instruction[] constantInstructions = new Instruction[program.variableCount()];
        for (i = 0; i <= context.getMethod().parameterCount(); ++i) {
            defLocation[i] = 0;
        }
        for (i = 0; i < domGraph.size(); ++i) {
            if (this.dom.immediateDominatorOf(i) >= 0) continue;
            stack.push(i);
        }
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        UsageExtractor useExtractor = new UsageExtractor();
        LoopInvariantAnalyzer analyzer = new LoopInvariantAnalyzer(nullness);
        CopyConstantVisitor constantCopier = new CopyConstantVisitor();
        int[][] loopExits = ControlFlowUtils.findLoopExits(this.graph);
        while (!stack.isEmpty()) {
            int v = stack.pop();
            Loop defLoop = this.graph.loopAt(v);
            int[] exits = loopExits[v];
            boolean dominatesExits = exits != null && Arrays.stream(exits).allMatch(exit -> this.dom.dominates(v, exit));
            BasicBlock block = program.basicBlockAt(v);
            Instruction insn = block.getFirstInstruction();
            while (insn != null) {
                Instruction nextInsn;
                block15: {
                    Variable[] defs;
                    nextInsn = insn.getNext();
                    insn.acceptVisitor(defExtractor);
                    for (Variable def : defs = defExtractor.getDefinedVariables()) {
                        defLocation[def.getIndex()] = v;
                    }
                    analyzer.reset();
                    insn.acceptVisitor(analyzer);
                    if (analyzer.constant) {
                        constantInstructions[defs[0].getIndex()] = insn;
                    }
                    if (analyzer.canMove && defLoop != null && (!analyzer.sideEffect || dominatesExits)) {
                        insn.acceptVisitor(useExtractor);
                        Loop commonUseLoop = null;
                        for (Variable variable : useExtractor.getUsedVariables()) {
                            Loop useLoop;
                            if (constantInstructions[variable.getIndex()] != null) continue;
                            int useLoc = defLocation[variable.getIndex()];
                            if (useLoc != -1 && (useLoop = this.graph.loopAt(useLoc)) != defLoop) {
                                if (useLoop == null || !useLoop.isChildOf(commonUseLoop)) continue;
                                commonUseLoop = useLoop;
                                continue;
                            }
                            break block15;
                        }
                        while (defLoop.getParent() != commonUseLoop) {
                            if ((defLoop = defLoop.getParent()) != null) continue;
                            break block15;
                        }
                        insn.delete();
                        BasicBlock preheader = program.basicBlockAt(this.getPreheader(defLoop.getHead()));
                        ArrayList<Instruction> newInstructions = new ArrayList<Instruction>();
                        Variable[] variableMap = null;
                        for (Variable use3 : useExtractor.getUsedVariables()) {
                            Instruction constInsn = constantInstructions[use3.getIndex()];
                            if (constInsn == null) continue;
                            constInsn.acceptVisitor(constantCopier);
                            newInstructions.add(constantCopier.copy);
                            if (variableMap == null) {
                                variableMap = new Variable[program.variableCount()];
                                for (int j2 = 0; j2 < variableMap.length; ++j2) {
                                    variableMap[j2] = program.variableAt(j2);
                                }
                            }
                            variableMap[use3.getIndex()] = constantCopier.var;
                        }
                        if (variableMap != null) {
                            Variable[] variableArray = variableMap;
                            insn.acceptVisitor(new InstructionVariableMapper(var -> currentVariableMap[var.getIndex()]));
                        }
                        newInstructions.add(insn);
                        preheader.getLastInstruction().insertPreviousAll(newInstructions);
                        defLocation[defs[0].getIndex()] = commonUseLoop != null ? commonUseLoop.getHead() : 0;
                        affected = true;
                    }
                }
                insn = nextInsn;
            }
            for (int succ : domGraph.outgoingEdges(v)) {
                stack.push(succ);
            }
        }
        nullness.dispose();
        return affected;
    }

    private int getPreheader(int header) {
        int preheader = this.preheaders[header];
        if (preheader < 0) {
            int[] entries = this.getLoopEntries(header);
            preheader = entries.length == 1 && this.graph.outgoingEdgesCount(entries[0]) == 1 ? entries[0] : this.insertPreheader(header);
            this.preheaders[header] = preheader;
        }
        return preheader;
    }

    private int[] getLoopEntries(int header) {
        int[] predecessors = this.graph.incomingEdges(header);
        int j = 0;
        for (int i = 0; i < predecessors.length; ++i) {
            int pred = predecessors[i];
            if (this.dom.dominates(header, pred)) continue;
            predecessors[j++] = pred;
        }
        return Arrays.copyOf(predecessors, j);
    }

    private int insertPreheader(int headerIndex) {
        BasicBlock preheader = this.program.createBasicBlock();
        JumpInstruction escapeInsn = new JumpInstruction();
        BasicBlock header = this.program.basicBlockAt(headerIndex);
        escapeInsn.setTarget(header);
        preheader.add(escapeInsn);
        for (Phi phi : header.getPhis()) {
            Phi preheaderPhi = null;
            for (int i = 0; i < phi.getIncomings().size(); ++i) {
                Incoming incoming = phi.getIncomings().get(i);
                if (this.dom.dominates(headerIndex, incoming.getSource().getIndex())) continue;
                phi.getIncomings().remove(i--);
                if (preheaderPhi == null) {
                    preheaderPhi = new Phi();
                    preheaderPhi.setReceiver(this.program.createVariable());
                    preheaderPhi.getReceiver().setLabel(phi.getReceiver().getLabel());
                    preheaderPhi.getReceiver().setDebugName(phi.getReceiver().getDebugName());
                    preheader.getPhis().add(preheaderPhi);
                }
                preheaderPhi.getIncomings().add(incoming);
            }
            if (preheaderPhi == null) continue;
            Incoming incoming = new Incoming();
            incoming.setSource(preheader);
            incoming.setValue(preheaderPhi.getReceiver());
            phi.getIncomings().add(incoming);
        }
        for (Object predIndex : (Object)this.graph.incomingEdges(headerIndex)) {
            if (this.dom.dominates(headerIndex, (int)predIndex)) continue;
            BasicBlock pred = this.program.basicBlockAt((int)predIndex);
            pred.getLastInstruction().acceptVisitor(new BasicBlockMapper(block -> block == header.getIndex() ? preheader.getIndex() : block));
        }
        return preheader.getIndex();
    }

    private class CopyConstantVisitor
    extends AbstractInstructionVisitor {
        Instruction copy;
        Variable var;

        private CopyConstantVisitor() {
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.setDebugName(insn.getReceiver().getDebugName());
            this.var.setLabel(insn.getReceiver().getLabel());
            ClassConstantInstruction copy = new ClassConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.setDebugName(insn.getReceiver().getDebugName());
            this.var.setLabel(insn.getReceiver().getLabel());
            NullConstantInstruction copy = new NullConstantInstruction();
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.setDebugName(insn.getReceiver().getDebugName());
            this.var.setLabel(insn.getReceiver().getLabel());
            IntegerConstantInstruction copy = new IntegerConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.setDebugName(insn.getReceiver().getDebugName());
            this.var.setLabel(insn.getReceiver().getLabel());
            LongConstantInstruction copy = new LongConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.setDebugName(insn.getReceiver().getDebugName());
            this.var.setLabel(insn.getReceiver().getLabel());
            FloatConstantInstruction copy = new FloatConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.setDebugName(insn.getReceiver().getDebugName());
            this.var.setLabel(insn.getReceiver().getLabel());
            DoubleConstantInstruction copy = new DoubleConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.setDebugName(insn.getReceiver().getDebugName());
            this.var.setLabel(insn.getReceiver().getLabel());
            StringConstantInstruction copy = new StringConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }
    }
}

