/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.model.analysis.NullnessInformation;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.ArrayLengthInstruction;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryOperation;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastIntegerInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastNumberInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.IsInstanceInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.NegateInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.NumericOperandType;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;

public class LoopInvariantAnalyzer
extends AbstractInstructionVisitor {
    private NullnessInformation nullness;
    public boolean canMove;
    public boolean constant;
    public boolean sideEffect;

    public LoopInvariantAnalyzer(NullnessInformation nullness) {
        this.nullness = nullness;
    }

    public void reset() {
        this.canMove = false;
        this.constant = false;
        this.sideEffect = false;
    }

    @Override
    public void visit(ClassConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(NullConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(IntegerConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(LongConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(FloatConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(DoubleConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(StringConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(BinaryInstruction insn) {
        this.canMove = true;
        if (insn.getOperation() == BinaryOperation.DIVIDE) {
            this.sideEffect = insn.getOperandType() == NumericOperandType.INT || insn.getOperandType() == NumericOperandType.LONG;
        }
    }

    @Override
    public void visit(NegateInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(AssignInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(CastInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(CastNumberInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(CastIntegerInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(ArrayLengthInstruction insn) {
        this.canMove = true;
        if (!this.nullness.isNotNull(insn.getArray())) {
            this.sideEffect = true;
        }
    }

    @Override
    public void visit(UnwrapArrayInstruction insn) {
        this.canMove = true;
        if (!this.nullness.isNotNull(insn.getArray())) {
            this.sideEffect = true;
        }
    }

    @Override
    public void visit(IsInstanceInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(NullCheckInstruction insn) {
        this.canMove = true;
        if (!this.nullness.isNotNull(insn.getValue())) {
            this.sideEffect = true;
        }
    }
}

