/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.lowlevel;

import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.GraphBuilder;
import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.model.BasicBlockReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.IncomingReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.PhiReader;
import com.antgroup.antchain.myjava.model.ProgramReader;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.VariableReader;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionReader;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.lowlevel.Characteristics;
import java.util.List;
import org.teavm.hppc.IntArrayDeque;
import org.teavm.hppc.IntDeque;

public class NativePointerFinder {
    private Characteristics characteristics;

    public NativePointerFinder(Characteristics characteristics) {
        this.characteristics = characteristics;
    }

    public boolean[] findNativePointers(MethodReference method, ProgramReader program) {
        IntArrayDeque stack = new IntArrayDeque();
        for (int i = 0; i < method.parameterCount(); ++i) {
            if (!this.isNativeType(method.parameterType(i))) continue;
            stack.addLast(i + 1);
        }
        Analyzer analyzer = new Analyzer(program.variableCount(), stack);
        for (BasicBlockReader basicBlockReader : program.getBasicBlocks()) {
            for (PhiReader phiReader : basicBlockReader.readPhis()) {
                for (IncomingReader incomingReader : phiReader.readIncomings()) {
                    analyzer.assignmentGraph.addEdge(incomingReader.getValue().getIndex(), phiReader.getReceiver().getIndex());
                }
            }
            basicBlockReader.readAllInstructions(analyzer);
        }
        boolean[] result = new boolean[program.variableCount()];
        Graph graph = analyzer.assignmentGraph.build();
        while (!stack.isEmpty()) {
            int v = stack.removeLast();
            if (result[v]) continue;
            result[v] = true;
            for (int succ : graph.outgoingEdges(v)) {
                if (result[succ]) continue;
                stack.addLast(succ);
            }
        }
        return result;
    }

    private boolean isNativeType(ValueType type) {
        if (!(type instanceof ValueType.Object)) {
            return false;
        }
        String className = ((ValueType.Object)type).getClassName();
        return this.characteristics.isStructure(className) || className.equals(Address.class.getName()) || this.characteristics.isFunction(className);
    }

    class Analyzer
    extends AbstractInstructionReader {
        GraphBuilder assignmentGraph;
        IntDeque steps;

        Analyzer(int variableCount, IntDeque steps) {
            this.assignmentGraph = new GraphBuilder(variableCount);
            this.steps = steps;
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            this.assignmentGraph.addEdge(assignee.getIndex(), receiver.getIndex());
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
            this.assignmentGraph.addEdge(value.getIndex(), receiver.getIndex());
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            if (receiver != null && NativePointerFinder.this.isNativeType(method.getReturnType())) {
                this.steps.addLast(receiver.getIndex());
            }
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
            if (NativePointerFinder.this.isNativeType(fieldType)) {
                this.steps.addLast(receiver.getIndex());
            }
        }
    }
}

