/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.lowlevel;

import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Structure;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import java.util.HashMap;
import java.util.Map;

public class ClassInitializerEliminator {
    private ClassReaderSource unprocessedClassSource;
    private Map<String, Boolean> cache = new HashMap<String, Boolean>();

    public ClassInitializerEliminator(ClassReaderSource unprocessedClassSource) {
        this.unprocessedClassSource = unprocessedClassSource;
    }

    public void apply(Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                if (!(insn instanceof InitClassInstruction) || this.filter(((InitClassInstruction)insn).getClassName())) continue;
                insn.delete();
            }
        }
    }

    private boolean filter(String className) {
        return this.cache.computeIfAbsent(className, key -> this.clinitNeeded((String)key) && !this.isStaticInit((String)key) && !this.isStructure((String)key));
    }

    private boolean clinitNeeded(String className) {
        ClassReader cls = this.unprocessedClassSource.get(className);
        if (cls == null) {
            return true;
        }
        return cls.getMethod(new MethodDescriptor("<clinit>", Void.TYPE)) != null;
    }

    private boolean isStaticInit(String className) {
        ClassReader cls = this.unprocessedClassSource.get(className);
        if (cls == null) {
            return false;
        }
        return cls.getAnnotations().get(StaticInit.class.getName()) != null;
    }

    private boolean isStructure(String className) {
        while (!className.equals(Structure.class.getName())) {
            ClassReader cls = this.unprocessedClassSource.get(className);
            if (cls == null) {
                return false;
            }
            if (cls.getParent() == null) {
                return false;
            }
            className = cls.getParent();
        }
        return true;
    }
}

